/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractAnnotation
extends AbstractChangeable
implements Annotation,
Serializable {
    protected abstract Map getProperties();

    protected abstract boolean propertiesAllocated();

    public Object getProperty(Object key) throws NoSuchElementException {
        Map prop;
        if (this.propertiesAllocated() && (prop = this.getProperties()).containsKey(key)) {
            return prop.get(key);
        }
        throw new NoSuchElementException("Property " + key + " unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(Object key, Object value) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.getProperties().put(key, value);
        } else {
            ChangeSupport cs;
            Map properties = this.getProperties();
            ChangeEvent ce = new ChangeEvent(this, Annotation.PROPERTY, new Object[]{key, value}, new Object[]{key, properties.get(key)});
            ChangeSupport changeSupport = cs = this.getChangeSupport(Annotation.PROPERTY);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                properties.put(key, value);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(Object key) throws ChangeVetoException, NoSuchElementException {
        if (!this.getProperties().containsKey(key)) {
            throw new NoSuchElementException("Can't remove key " + key.toString());
        }
        if (!this.hasListeners()) {
            this.getProperties().remove(key);
        } else {
            ChangeSupport cs;
            Map properties = this.getProperties();
            ChangeEvent ce = new ChangeEvent(this, Annotation.PROPERTY, new Object[]{key, null}, new Object[]{key, properties.get(key)});
            ChangeSupport changeSupport = cs = this.getChangeSupport(Annotation.PROPERTY);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                properties.remove(key);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public boolean containsProperty(Object key) {
        if (this.propertiesAllocated()) {
            return this.getProperties().containsKey(key);
        }
        return false;
    }

    public Set keys() {
        if (this.propertiesAllocated()) {
            return this.getProperties().keySet();
        }
        return Collections.EMPTY_SET;
    }

    public String toString() {
        Object key;
        StringBuffer sb = new StringBuffer("{");
        Map prop = this.getProperties();
        Iterator i = prop.keySet().iterator();
        if (i.hasNext()) {
            key = i.next();
            sb.append(key + "=" + prop.get(key));
        }
        while (i.hasNext()) {
            key = i.next();
            sb.append("," + key + "=" + prop.get(key));
        }
        sb.append("}");
        return sb.substring(0);
    }

    public Map asMap() {
        return Collections.unmodifiableMap(this.getProperties());
    }

    protected AbstractAnnotation() {
    }

    protected AbstractAnnotation(Annotation ann) throws IllegalArgumentException {
        if (ann == null) {
            throw new IllegalArgumentException("Null annotation not allowed. Use Annotation.EMPTY_ANNOTATION instead.");
        }
        if (ann == Annotation.EMPTY_ANNOTATION) {
            return;
        }
        Map properties = this.getProperties();
        Iterator i = ann.keys().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            try {
                properties.put(key, ann.getProperty(key));
            }
            catch (IllegalArgumentException iae) {
                throw new BioError(iae, "Property was there and then disappeared: " + key);
            }
        }
    }

    public AbstractAnnotation(Map annMap) {
        if (annMap == null) {
            throw new IllegalArgumentException("Null annotation Map not allowed. Use an empy map instead.");
        }
        if (annMap.isEmpty()) {
            return;
        }
        Map properties = this.getProperties();
        Iterator i = annMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            properties.put(key, annMap.get(key));
        }
    }

    public int hashCode() {
        return ((Object)this.asMap()).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Annotation)) {
            return false;
        }
        return ((Object)((Annotation)o).asMap()).equals(this.asMap());
    }
}

