/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.chromatogram.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.chromatogram.ChromatogramTools;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class ChromatogramGraphic
implements Cloneable {
    private static SymbolList SINGLE_CALL = new SimpleSymbolList(new Symbol[]{DNATools.getDNA().getGapSymbol()}, 1, DNATools.getDNA());
    private static final int A = 0;
    private static final int C = 1;
    private static final int G = 2;
    private static final int T = 3;
    private Chromatogram chromat;
    private float vertScale = -1.0f;
    private float horizScale = -1.0f;
    private int width = -1;
    private int height = -1;
    protected boolean subpathsValid;
    protected boolean callboxesValid;
    protected boolean drawableCallboxesValid;
    private GeneralPath[][] subpaths;
    private Rectangle2D.Float[] callboxes;
    private Rectangle2D[] drawableCallboxes;
    private AffineTransform drawnCallboxesTx;
    protected Map options = new HashMap(Option.DEFAULTS);
    protected Map colors = new HashMap();
    protected Map fillColors = new HashMap();
    private static final Map DEFAULT_COLORS = new HashMap();

    public ChromatogramGraphic() {
        this(null);
    }

    public ChromatogramGraphic(Chromatogram c) {
        this.subpaths = new GeneralPath[4][];
        Iterator it = DEFAULT_COLORS.keySet().iterator();
        while (it.hasNext()) {
            Symbol key = (Symbol)it.next();
            this.setBaseColor(key, (Color)DEFAULT_COLORS.get(key));
        }
        this.setChromatogram(c);
    }

    protected synchronized void generateSubpaths() {
        if (this.chromat != null && !this.subpathsValid) {
            if (this.subpaths == null) {
                this.subpaths = new GeneralPath[4][];
            }
            int[][] samples = new int[4][];
            try {
                samples[0] = this.chromat.getTrace(DNATools.a());
                samples[1] = this.chromat.getTrace(DNATools.c());
                samples[2] = this.chromat.getTrace(DNATools.g());
                samples[3] = this.chromat.getTrace(DNATools.t());
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Can't happen");
            }
            float max = this.chromat.getMax();
            float rescale = 1.0f;
            int subpathLength = this.getIntOption(Option.SUBPATH_LENGTH);
            int countSubpaths = (int)Math.ceil((float)samples[0].length / (float)subpathLength);
            for (int i = 0; i < 4; ++i) {
                this.subpaths[i] = new GeneralPath[countSubpaths];
                for (int j = 0; j < countSubpaths; ++j) {
                    this.subpaths[i][j] = new GeneralPath(0, subpathLength);
                    int offsetIdx = j == 0 ? 0 : j * subpathLength - 1;
                    this.subpaths[i][j].moveTo(offsetIdx, rescale * (max - (float)samples[i][offsetIdx]));
                    for (int k = offsetIdx; k < samples[i].length && k <= offsetIdx + subpathLength; ++k) {
                        this.subpaths[i][j].lineTo(k, rescale * (max - (float)samples[i][k]));
                    }
                }
            }
            this.subpathsValid = true;
        }
    }

    protected synchronized void generateCallboxes() {
        if (this.chromat != null && !this.callboxesValid) {
            if (this.chromat.getSequenceLength() < 2) {
                this.callboxes = new Rectangle2D.Float[1];
                this.callboxes[0] = new Rectangle2D.Float(0.0f, 0.0f, this.chromat.getTraceLength() - 1, this.chromat.getMax());
            } else {
                int[] bcOffsets = ChromatogramTools.getTraceOffsetArray(this.chromat);
                if (this.callboxes == null || this.callboxes.length != bcOffsets.length) {
                    this.callboxes = new Rectangle2D.Float[bcOffsets.length];
                }
                float max = this.chromat.getMax();
                float left = 0.0f;
                float right = (float)bcOffsets[0] + (float)(bcOffsets[1] - bcOffsets[0]) / 2.0f;
                this.callboxes[0] = new Rectangle2D.Float(0.0f, 0.0f, right - left, max);
                for (int i = 1; i < bcOffsets.length - 1; ++i) {
                    left = right;
                    right = (float)bcOffsets[i] + (float)(bcOffsets[i + 1] - bcOffsets[i]) / 2.0f;
                    this.callboxes[i] = new Rectangle2D.Float(left, 0.0f, right - left, max);
                }
                left = right - 1.0f;
                right = this.chromat.getTraceLength() - 1;
                this.callboxes[i] = new Rectangle2D.Float(left, 0.0f, right - left, max);
            }
            this.callboxesValid = true;
            this.drawableCallboxesValid = false;
        }
    }

    protected synchronized void generateDrawableCallboxes(AffineTransform shapeTx) {
        if (!shapeTx.equals(this.drawnCallboxesTx) || !this.drawableCallboxesValid) {
            if (this.drawableCallboxes == null || this.drawableCallboxes.length != this.callboxes.length) {
                this.drawableCallboxes = new Rectangle2D[this.callboxes.length];
            }
            for (int i = 0; i < this.drawableCallboxes.length; ++i) {
                this.drawableCallboxes[i] = shapeTx.createTransformedShape(this.callboxes[i]).getBounds2D();
            }
            this.drawnCallboxesTx = (AffineTransform)shapeTx.clone();
            this.drawableCallboxesValid = true;
        }
    }

    public Chromatogram getChromatogram() {
        return this.chromat;
    }

    public synchronized void setChromatogram(Chromatogram c) {
        this.chromat = c;
        this.callboxesValid = false;
        this.subpathsValid = false;
        if (this.optionIsTrue(Option.WIDTH_IS_AUTHORITATIVE)) {
            this.setWidth(this.width);
        } else {
            this.setHorizontalScale(this.horizScale);
        }
        if (this.optionIsTrue(Option.HEIGHT_IS_AUTHORITATIVE)) {
            this.setHeight(this.height);
        } else {
            this.setVerticalScale(this.vertScale);
        }
        this.setOption(Option.FROM_TRACE_SAMPLE, new Integer(0));
        if (c == null) {
            this.setOption(Option.TO_TRACE_SAMPLE, new Integer(Integer.MAX_VALUE));
        } else {
            this.setOption(Option.TO_TRACE_SAMPLE, new Integer(c.getTraceLength() - 1));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getHorizontalScale() {
        return this.horizScale;
    }

    public float getVerticalScale() {
        return this.vertScale;
    }

    public int getRenderedWidth() {
        return this.getRenderedWidth(this.horizScale);
    }

    public int getRenderedWidth(float horizontalScale) {
        return (int)Math.ceil(horizontalScale * (this.getFloatOption(Option.TO_TRACE_SAMPLE) - this.getFloatOption(Option.FROM_TRACE_SAMPLE) + 1.0f));
    }

    public void setHeight(int h) {
        this.height = h;
        this.vertScale = this.chromat != null ? (float)this.height / (float)this.chromat.getMax() : -1.0f;
        this.drawableCallboxesValid = false;
    }

    public void setVerticalScale(float vs) {
        this.vertScale = vs;
        this.height = this.chromat != null ? (int)(this.vertScale * (float)this.chromat.getMax()) : -1;
        this.drawableCallboxesValid = false;
    }

    public void setWidth(int w) {
        this.width = w;
        this.horizScale = this.chromat != null ? (float)this.width / (float)this.chromat.getTraceLength() : -1.0f;
        this.drawableCallboxesValid = false;
    }

    public void setHorizontalScale(float hs) {
        this.horizScale = hs;
        this.width = this.chromat != null ? (int)(this.horizScale * (float)this.chromat.getTraceLength()) : -1;
        this.drawableCallboxesValid = false;
    }

    public Color getBaseColor(Symbol b) {
        return (Color)this.colors.get(b);
    }

    public Color getBaseFillColor(Symbol b) {
        return (Color)this.fillColors.get(b);
    }

    public void setBaseColor(Symbol b, Color c) {
        this.colors.put(b, c);
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.fillColors.put(b, Color.getHSBColor(hsb[0], hsb[1] * 0.09f, Math.max(hsb[2], 0.8f)));
    }

    public int getCallboxCount() {
        if (!this.callboxesValid) {
            this.generateCallboxes();
        }
        return this.callboxes.length;
    }

    public Rectangle2D getCallboxBounds(int index) {
        return this.getCallboxBounds(index, true);
    }

    public Rectangle2D getCallboxBounds(int index, boolean boundsOnScreen) {
        if (this.chromat != null && index >= 0 && index < this.getCallboxCount()) {
            if (!this.callboxesValid) {
                this.generateCallboxes();
            }
            if (boundsOnScreen) {
                if (!this.drawableCallboxesValid) {
                    this.generateDrawableCallboxes(this.getTransform());
                }
                return this.drawableCallboxes[index].getBounds2D();
            }
            return this.callboxes[index].getBounds2D();
        }
        return null;
    }

    public int getCallContaining(Point2D point, boolean pointOnScreen) {
        if (this.chromat != null) {
            int i;
            if (!this.callboxesValid) {
                this.generateCallboxes();
            }
            Point2D.Double trans = new Point2D.Double(point.getX(), point.getY());
            if (pointOnScreen) {
                this.getInvTransform().transform(point, trans);
            }
            for (i = 0; i < this.callboxes.length && ((Point2D)trans).getX() > this.callboxes[i].getMaxX(); ++i) {
            }
            return i < this.callboxes.length ? i : i - 1;
        }
        return 0;
    }

    public int getCallContaining(Point2D point) {
        return this.getCallContaining(point, true);
    }

    public int getCallContaining(float x, boolean xOnScreen) {
        return this.getCallContaining(new Point2D.Float(x, 0.0f), xOnScreen);
    }

    public int getCallContaining(float x) {
        return this.getCallContaining(x, true);
    }

    public AffineTransform getTransform() {
        AffineTransform at = new AffineTransform();
        this.getTransformAndConcat(at);
        return at;
    }

    public void getTransformAndConcat(AffineTransform target) {
        target.scale(this.horizScale, this.vertScale);
        target.translate(-1.0 * (double)this.getFloatOption(Option.FROM_TRACE_SAMPLE), 1.0);
    }

    public AffineTransform getInvTransform() {
        AffineTransform at = new AffineTransform();
        at.translate(this.getFloatOption(Option.FROM_TRACE_SAMPLE), -1.0);
        at.scale(1.0 / (double)this.horizScale, 1.0 / (double)this.vertScale);
        return at;
    }

    public void drawTo(Graphics2D g2) {
        int j;
        AffineTransform origTx = g2.getTransform();
        Color origC = g2.getColor();
        Shape origClip = g2.getClip();
        Object origAA = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke origStroke = g2.getStroke();
        Rectangle2D clip = origClip.getBounds2D();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean usePerShpTx = this.optionIsTrue(Option.USE_PER_SHAPE_TRANSFORM);
        AffineTransform shapeTx = (AffineTransform)origTx.clone();
        this.getTransformAndConcat(shapeTx);
        if (usePerShpTx) {
            g2.setTransform(new AffineTransform());
        } else {
            g2.setTransform(shapeTx);
        }
        if (this.optionIsTrue(Option.USE_CUSTOM_STROKE)) {
            g2.setStroke((Stroke)this.getOption(Option.SEPARATOR_STROKE));
        }
        if (!this.callboxesValid) {
            this.generateCallboxes();
        }
        if (usePerShpTx) {
            this.generateDrawableCallboxes(AffineTransform.getScaleInstance(shapeTx.getScaleX(), shapeTx.getScaleY()));
            g2.translate(shapeTx.getTranslateX(), shapeTx.getTranslateY());
        }
        int leftCbIdx = this.getCallContaining((float)clip.getX());
        int rightCbIdx = this.getCallContaining((float)clip.getMaxX());
        SymbolList calls = ChromatogramTools.getDNASequence(this.chromat);
        if (calls.length() < 1) {
            calls = SINGLE_CALL;
        }
        boolean drawSep = this.optionIsTrue(Option.DRAW_CALL_SEPARATORS);
        Line2D.Double sep = new Line2D.Double();
        for (int i = leftCbIdx; i <= rightCbIdx; ++i) {
            int callIdx = i + 1;
            if (this.doDrawCallbox(calls.symbolAt(callIdx))) {
                Color fill = (Color)this.fillColors.get(calls.symbolAt(callIdx));
                Color line = (Color)this.colors.get(calls.symbolAt(callIdx));
                if (line == null) {
                    line = Color.black;
                    fill = Color.white;
                }
                g2.setColor(fill);
                if (usePerShpTx) {
                    g2.fill(this.drawableCallboxes[i]);
                } else {
                    g2.fill(this.callboxes[i]);
                }
            }
            if (!drawSep) continue;
            g2.setColor((Color)this.getOption(Option.SEPARATOR_COLOR));
            if (usePerShpTx) {
                sep.setLine(this.drawableCallboxes[i].getX(), this.drawableCallboxes[i].getY(), this.drawableCallboxes[i].getX(), this.drawableCallboxes[i].getMaxY());
            } else {
                sep.setLine(this.callboxes[i].x, this.callboxes[i].y, this.callboxes[i].x, this.callboxes[i].y + this.callboxes[i].height);
            }
            g2.draw(sep);
        }
        if (usePerShpTx) {
            g2.translate(-1.0 * shapeTx.getTranslateX(), -1.0 * shapeTx.getTranslateY());
        }
        if (this.optionIsTrue(Option.USE_CUSTOM_STROKE)) {
            g2.setStroke((Stroke)this.getOption(Option.TRACE_STROKE));
        }
        if (!this.subpathsValid) {
            this.generateSubpaths();
        }
        float toTraceSample = this.getFloatOption(Option.TO_TRACE_SAMPLE);
        float fromTraceSample = this.getFloatOption(Option.FROM_TRACE_SAMPLE);
        int subpathLength = this.getIntOption(Option.SUBPATH_LENGTH);
        int loSubpath = (int)Math.floor((clip.getX() / shapeTx.getScaleX() + (double)fromTraceSample) / (double)subpathLength);
        int hiSubpath = (int)Math.ceil(Math.min(clip.getMaxX() / shapeTx.getScaleX() + (double)fromTraceSample, (double)toTraceSample) / (double)subpathLength);
        if (this.optionIsTrue(Option.DRAW_TRACE_A)) {
            g2.setColor((Color)this.colors.get(DNATools.a()));
            if (usePerShpTx) {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(shapeTx.createTransformedShape(this.subpaths[0][j]));
                }
            } else {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(this.subpaths[0][j]);
                }
            }
        }
        if (this.optionIsTrue(Option.DRAW_TRACE_C)) {
            g2.setColor((Color)this.colors.get(DNATools.c()));
            if (usePerShpTx) {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(shapeTx.createTransformedShape(this.subpaths[1][j]));
                }
            } else {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(this.subpaths[1][j]);
                }
            }
        }
        if (this.optionIsTrue(Option.DRAW_TRACE_G)) {
            g2.setColor((Color)this.colors.get(DNATools.g()));
            if (usePerShpTx) {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(shapeTx.createTransformedShape(this.subpaths[2][j]));
                }
            } else {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(this.subpaths[2][j]);
                }
            }
        }
        if (this.optionIsTrue(Option.DRAW_TRACE_T)) {
            g2.setColor((Color)this.colors.get(DNATools.t()));
            if (usePerShpTx) {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(shapeTx.createTransformedShape(this.subpaths[3][j]));
                }
            } else {
                for (j = loSubpath; j < hiSubpath; ++j) {
                    g2.draw(this.subpaths[3][j]);
                }
            }
        }
        g2.setStroke(origStroke);
        g2.setTransform(origTx);
        g2.setColor(origC);
        g2.setClip(origClip);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origAA);
    }

    public void setOption(Option opt, Object value) {
        this.options.put(opt, value);
        if (opt == Option.SUBPATH_LENGTH) {
            this.subpathsValid = false;
        }
    }

    public Object getOption(Option opt) {
        return this.options.get(opt);
    }

    public boolean optionIsTrue(Option opt) throws ClassCastException {
        if (this.getOption(opt) instanceof Boolean) {
            return (Boolean)this.getOption(opt);
        }
        throw new ClassCastException("Option \"" + opt + "\" is not set to a Boolean value");
    }

    public float getFloatOption(Option opt) throws ClassCastException {
        if (this.getOption(opt) instanceof Number) {
            return ((Number)this.getOption(opt)).floatValue();
        }
        throw new ClassCastException("Option \"" + opt + "\" is not set to a Number value");
    }

    public int getIntOption(Option opt) throws ClassCastException {
        if (this.getOption(opt) instanceof Number) {
            return ((Number)this.getOption(opt)).intValue();
        }
        throw new ClassCastException("Option \"" + opt + "\" is not set to a Number value");
    }

    private boolean doDrawCallbox(Symbol bc) {
        if (bc == DNATools.a()) {
            return this.optionIsTrue(Option.DRAW_CALL_A);
        }
        if (bc == DNATools.c()) {
            return this.optionIsTrue(Option.DRAW_CALL_C);
        }
        if (bc == DNATools.g()) {
            return this.optionIsTrue(Option.DRAW_CALL_G);
        }
        if (bc == DNATools.t()) {
            return this.optionIsTrue(Option.DRAW_CALL_T);
        }
        if (DNATools.getDNA().contains(bc)) {
            return this.optionIsTrue(Option.DRAW_CALL_OTHER);
        }
        return false;
    }

    public Object clone() {
        ChromatogramGraphic copy = null;
        try {
            copy = (ChromatogramGraphic)super.clone();
            copy.callboxesValid = false;
            copy.drawableCallboxesValid = false;
            copy.drawableCallboxes = null;
            copy.subpathsValid = false;
            copy.subpaths = null;
            copy.options = new HashMap();
            Iterator it = this.options.keySet().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                copy.options.put(next, this.options.get(next));
            }
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
            throw new BioError("Can't happen");
        }
        return copy;
    }

    private static final String basicStrokeToString(BasicStroke bs) {
        StringBuffer sb = new StringBuffer(bs.toString());
        sb.append("[width=").append(bs.getLineWidth());
        sb.append("; EndCap=");
        switch (bs.getEndCap()) {
            case 0: {
                sb.append("CAP_BUTT");
                break;
            }
            case 1: {
                sb.append("CAP_ROUND");
                break;
            }
            case 2: {
                sb.append("CAP_SQUARE");
            }
        }
        sb.append("; Join=");
        switch (bs.getLineJoin()) {
            case 2: {
                sb.append("JOIN_BEVEL");
                break;
            }
            case 0: {
                sb.append("JOIN_MITER");
                break;
            }
            case 1: {
                sb.append("JOIN_ROUND");
            }
        }
        sb.append("; MiterLimit=").append(bs.getMiterLimit()).append(']');
        return sb.toString();
    }

    static {
        DEFAULT_COLORS.put(DNATools.a(), Color.green);
        DEFAULT_COLORS.put(DNATools.c(), Color.blue);
        DEFAULT_COLORS.put(DNATools.g(), Color.black);
        DEFAULT_COLORS.put(DNATools.t(), Color.red);
    }

    public static class Option {
        private String desc;
        private static HashMap map = new HashMap();
        static final HashMap DEFAULTS = new HashMap();
        public static final Option DRAW_CALL_A = new Option("draw-A-calls", Boolean.TRUE);
        public static final Option DRAW_CALL_C = new Option("draw-C-calls", Boolean.TRUE);
        public static final Option DRAW_CALL_G = new Option("draw-G-calls", Boolean.TRUE);
        public static final Option DRAW_CALL_T = new Option("draw-T-calls", Boolean.TRUE);
        public static final Option DRAW_CALL_OTHER = new Option("draw-other-calls", Boolean.TRUE);
        public static final Option DRAW_TRACE_A = new Option("draw-A-trace", Boolean.TRUE);
        public static final Option DRAW_TRACE_C = new Option("draw-C-trace", Boolean.TRUE);
        public static final Option DRAW_TRACE_G = new Option("draw-G-trace", Boolean.TRUE);
        public static final Option DRAW_TRACE_T = new Option("draw-T-trace", Boolean.TRUE);
        public static final Option DRAW_CALL_SEPARATORS = new Option("draw-call-separators", Boolean.TRUE);
        public static final Option SEPARATOR_COLOR = new Option("separator-color", Color.lightGray);
        public static final Option WIDTH_IS_AUTHORITATIVE = new Option("width-is-authoritative", Boolean.FALSE);
        public static final Option HEIGHT_IS_AUTHORITATIVE = new Option("height-is-authoritative", Boolean.TRUE);
        public static final Option USE_CUSTOM_STROKE = new Option("use-custom-stroke", Boolean.TRUE);
        public static final Option TRACE_STROKE = new Option("trace-stroke", new BasicStroke(1.0f, 1, 1));
        public static final Option SEPARATOR_STROKE = new Option("separator-stroke", new BasicStroke(1.0f));
        public static final Option USE_PER_SHAPE_TRANSFORM = new Option("use-per-shape-transform", Boolean.FALSE);
        public static final Option SUBPATH_LENGTH = new Option("subpath-length", new Integer(250));
        public static final Option FROM_TRACE_SAMPLE = new Option("from-trace-sample", new Integer(0));
        public static final Option TO_TRACE_SAMPLE = new Option("to-trace-sample", new Integer(Integer.MAX_VALUE));

        private Option(String desc, Object def) {
            this.desc = desc;
            map.put(desc, this);
            DEFAULTS.put(this, def);
        }

        public String toString() {
            return this.desc;
        }

        public static final Option lookup(String desc) {
            return (Option)map.get(desc);
        }
    }
}

