/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Count;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public final class IndexedCount
extends AbstractChangeable
implements Count,
Serializable {
    private transient AlphabetIndex indexer;
    private transient double[] counts;
    private Map symbolIndices = null;
    private FiniteAlphabet alpha;

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public double getCount(AtomicSymbol s) throws IllegalSymbolException {
        return this.counts[this.indexer.indexForSymbol(s)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCount(AtomicSymbol s, double c) throws IllegalSymbolException, ChangeVetoException {
        if (!this.hasListeners()) {
            this.counts[this.indexer.indexForSymbol((Symbol)s)] = c;
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(Count.COUNTS);
            synchronized (changeSupport2) {
                int index = this.indexer.indexForSymbol(s);
                ChangeEvent ce = new ChangeEvent(this, Count.COUNTS, new Object[]{s, new Double(this.counts[index])}, new Object[]{s, new Double(c)});
                changeSupport.firePreChangeEvent(ce);
                this.counts[index] = c;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseCount(AtomicSymbol s, double c) throws IllegalSymbolException, ChangeVetoException {
        if (!this.hasListeners()) {
            int n = this.indexer.indexForSymbol(s);
            this.counts[n] = this.counts[n] + c;
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(Count.COUNTS);
            synchronized (changeSupport2) {
                int index = this.indexer.indexForSymbol(s);
                double oc = this.counts[index];
                double nc = oc + c;
                ChangeEvent ce = new ChangeEvent(this, Count.COUNTS, new Object[]{s, new Double(oc)}, new Object[]{s, new Double(nc)});
                changeSupport.firePreChangeEvent(ce);
                this.counts[index] = nc;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCounts(Count c) throws IllegalAlphabetException, ChangeVetoException {
        block9: {
            if (c.getAlphabet() != this.getAlphabet()) {
                throw new IllegalAlphabetException("Alphabet must match: " + c.getAlphabet().getName() + " != " + c.getAlphabet().getName());
            }
            try {
                ChangeSupport changeSupport;
                if (!this.hasListeners()) {
                    for (int i = 0; i < this.counts.length; ++i) {
                        this.counts[i] = c.getCount((AtomicSymbol)this.indexer.symbolForIndex(i));
                    }
                    break block9;
                }
                ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(Count.COUNTS);
                synchronized (changeSupport2) {
                    ChangeEvent ce = new ChangeEvent(this, Count.COUNTS);
                    changeSupport.firePreChangeEvent(ce);
                    for (int i = 0; i < this.counts.length; ++i) {
                        this.counts[i] = c.getCount((AtomicSymbol)this.indexer.symbolForIndex(i));
                    }
                    changeSupport.firePostChangeEvent(ce);
                }
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Assertion Failure: Should have no illegal symbols");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zeroCounts() throws ChangeVetoException {
        if (!this.hasListeners()) {
            for (int i = 0; i < this.counts.length; ++i) {
                this.counts[i] = 0.0;
            }
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(Count.COUNTS);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, Count.COUNTS);
                changeSupport.firePreChangeEvent(ce);
                for (int i = 0; i < this.counts.length; ++i) {
                    this.counts[i] = 0.0;
                }
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.symbolIndices = new HashMap(this.counts.length);
        for (int i = 0; i < this.counts.length; ++i) {
            this.symbolIndices.put(this.indexer.symbolForIndex(i), new Double(this.counts[i]));
        }
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.indexer = AlphabetManager.getAlphabetIndex(this.alpha);
        this.counts = new double[this.alpha.size()];
        for (int i = 0; i < this.alpha.size(); ++i) {
            Symbol key = this.indexer.symbolForIndex(0);
            Double d = (Double)this.symbolIndices.get(key);
            this.counts[i] = d == null ? 0.0 : d;
        }
        this.symbolIndices = null;
    }

    public IndexedCount(FiniteAlphabet fa) {
        this(AlphabetManager.getAlphabetIndex(fa));
    }

    public IndexedCount(AlphabetIndex indexer) {
        indexer.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        this.indexer = indexer;
        this.counts = new double[indexer.getAlphabet().size()];
        this.alpha = indexer.getAlphabet();
    }
}

