/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.FlatModel;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleStatePath;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;

public abstract class DP {
    private MarkovModel model;
    private State[] states;
    private int[][] forwardTransitions;
    private int[][] backwardTransitions;
    private int dotStatesIndex;
    private int lockCount = 0;
    private Map forwardTransitionScores;
    private Map backwardTransitionScores;
    private final ChangeListener UPDATER = new ChangeListener(){

        public void preChange(ChangeEvent ce) throws ChangeVetoException {
        }

        public void postChange(ChangeEvent ce) {
            if (ce.getType() == MarkovModel.ARCHITECTURE || ce.getType() == MarkovModel.PARAMETER) {
                DP.this.update();
            }
        }
    };

    public static double scoreWeightMatrix(WeightMatrix matrix, SymbolList symList, int start) throws IllegalSymbolException {
        double score = 0.0;
        int cols = matrix.columns();
        for (int c = 0; c < cols; ++c) {
            score += Math.log(matrix.getColumn(c).getWeight(symList.symbolAt(c + start)));
        }
        return score;
    }

    public static MarkovModel flatView(MarkovModel model) throws IllegalAlphabetException, IllegalSymbolException {
        Iterator i = model.stateAlphabet().iterator();
        while (i.hasNext()) {
            State s = (State)i.next();
            if (s instanceof DotState || s instanceof EmissionState) continue;
            return new FlatModel(model);
        }
        return model;
    }

    public static State[] stateList(MarkovModel mm) throws IllegalSymbolException, IllegalTransitionException, BioException {
        FiniteAlphabet alpha = mm.stateAlphabet();
        ArrayList emissionStates = new ArrayList();
        HMMOrderByTransition comp = new HMMOrderByTransition(mm);
        LinkedList dotStates = new LinkedList();
        Iterator addStates = alpha.iterator();
        while (addStates.hasNext()) {
            Object state = addStates.next();
            if (state instanceof MagicalState) {
                emissionStates.add(0, state);
                continue;
            }
            if (state instanceof EmissionState) {
                emissionStates.add(state);
                continue;
            }
            ListIterator checkOld = dotStates.listIterator();
            int insertPos = -1;
            while (checkOld.hasNext() && insertPos == -1) {
                Object oldState = checkOld.next();
                if (comp.compare(state, oldState) != HMMOrderByTransition.LESS_THAN) continue;
                insertPos = checkOld.nextIndex() - 1;
            }
            if (insertPos >= 0) {
                dotStates.add(insertPos, state);
                continue;
            }
            dotStates.add(state);
        }
        State[] sl = new State[emissionStates.size() + dotStates.size()];
        int i = 0;
        Iterator si = emissionStates.iterator();
        while (si.hasNext()) {
            EmissionState ex = (EmissionState)si.next();
            int[] ad = ex.getAdvance();
            if (ad.length != mm.heads()) {
                throw new BioException("State " + ex.getName() + " advances " + ad.length + " heads. " + " however, the model " + mm.stateAlphabet().getName() + " advances " + mm.heads() + " heads.");
            }
            for (int adi = 0; ad != null && adi < ad.length; ++adi) {
                if (ad[adi] == 0) continue;
                ad = null;
            }
            if (ad != null) {
                throw new Error("State " + ex.getName() + " has advance " + ad);
            }
            sl[i++] = ex;
        }
        si = dotStates.iterator();
        while (si.hasNext()) {
            sl[i++] = (State)si.next();
        }
        return sl;
    }

    public static int[][] forwardTransitions(MarkovModel model, State[] states) throws IllegalSymbolException {
        int stateCount = states.length;
        int[][] transitions = new int[stateCount][];
        for (int i = 0; i < stateCount; ++i) {
            int[] tmp = new int[stateCount];
            int len = 0;
            FiniteAlphabet trans = model.transitionsTo(states[i]);
            for (int j = 0; j < stateCount; ++j) {
                if (!trans.contains(states[j])) continue;
                tmp[len++] = j;
            }
            int[] tmp2 = new int[len];
            for (int j = 0; j < len; ++j) {
                tmp2[j] = tmp[j];
            }
            transitions[i] = tmp2;
        }
        return transitions;
    }

    public static double[][] forwardTransitionScores(MarkovModel model, State[] states, int[][] transitions, ScoreType scoreType) throws IllegalSymbolException {
        int stateCount = states.length;
        double[][] scores = new double[stateCount][];
        for (int i = 0; i < stateCount; ++i) {
            State is = states[i];
            scores[i] = new double[transitions[i].length];
            for (int j = 0; j < scores[i].length; ++j) {
                try {
                    scores[i][j] = Math.log(scoreType.calculateScore(model.getWeights(states[transitions[i][j]]), is));
                    continue;
                }
                catch (IllegalSymbolException ite) {
                    throw new BioError(ite, "Transition listed in transitions array has dissapeared.");
                }
            }
        }
        return scores;
    }

    public static int[][] backwardTransitions(MarkovModel model, State[] states) throws IllegalSymbolException {
        int stateCount = states.length;
        int[][] transitions = new int[stateCount][];
        for (int i = 0; i < stateCount; ++i) {
            int[] tmp = new int[stateCount];
            int len = 0;
            FiniteAlphabet trans = model.transitionsFrom(states[i]);
            for (int j = 0; j < stateCount; ++j) {
                if (!trans.contains(states[j])) continue;
                tmp[len++] = j;
            }
            int[] tmp2 = new int[len];
            for (int j = 0; j < len; ++j) {
                tmp2[j] = tmp[j];
            }
            transitions[i] = tmp2;
        }
        return transitions;
    }

    public static double[][] backwardTransitionScores(MarkovModel model, State[] states, int[][] transitions, ScoreType scoreType) throws IllegalSymbolException {
        int stateCount = states.length;
        double[][] scores = new double[stateCount][];
        for (int i = 0; i < stateCount; ++i) {
            State is = states[i];
            scores[i] = new double[transitions[i].length];
            for (int j = 0; j < scores[i].length; ++j) {
                try {
                    scores[i][j] = Math.log(scoreType.calculateScore(model.getWeights(is), states[transitions[i][j]]));
                    continue;
                }
                catch (IllegalSymbolException ite) {
                    throw new BioError(ite, "Transition listed in transitions array has dissapeared");
                }
            }
        }
        return scores;
    }

    public int getDotStatesIndex() {
        return this.dotStatesIndex;
    }

    public MarkovModel getModel() {
        return this.model;
    }

    public State[] getStates() {
        return this.states;
    }

    public int[][] getForwardTransitions() {
        return this.forwardTransitions;
    }

    public double[][] getForwardTransitionScores(ScoreType scoreType) {
        double[][] ts = (double[][])this.forwardTransitionScores.get(scoreType);
        if (ts == null) {
            try {
                ts = DP.forwardTransitionScores(this.getModel(), this.getStates(), this.forwardTransitions, scoreType);
                this.forwardTransitionScores.put(scoreType, ts);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Inconsistency in model");
            }
        }
        return ts;
    }

    public int[][] getBackwardTransitions() {
        return this.backwardTransitions;
    }

    public double[][] getBackwardTransitionScores(ScoreType scoreType) {
        double[][] ts = (double[][])this.backwardTransitionScores.get(scoreType);
        if (ts == null) {
            try {
                ts = DP.backwardTransitionScores(this.getModel(), this.getStates(), this.backwardTransitions, scoreType);
                this.backwardTransitionScores.put(scoreType, ts);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Inconsistency in model");
            }
        }
        return ts;
    }

    public void lockModel() {
        if (this.lockCount++ == 0) {
            this.getModel().addChangeListener(ChangeListener.ALWAYS_VETO);
        }
    }

    public void unlockModel() {
        if (--this.lockCount == 0) {
            this.getModel().removeChangeListener(ChangeListener.ALWAYS_VETO);
        }
    }

    public void update() {
        try {
            int i;
            this.states = DP.stateList(this.model);
            this.forwardTransitions = DP.forwardTransitions(this.model, this.states);
            this.forwardTransitionScores.clear();
            this.backwardTransitions = DP.backwardTransitions(this.model, this.states);
            this.backwardTransitionScores.clear();
            for (i = 0; i < this.states.length && this.states[i] instanceof EmissionState; ++i) {
            }
            this.dotStatesIndex = i;
        }
        catch (Exception e) {
            throw new BioError(e, "Something is seriously wrong with the DP code");
        }
    }

    public DP(MarkovModel model) throws IllegalSymbolException, IllegalTransitionException, BioException {
        this.model = model;
        this.forwardTransitionScores = new HashMap();
        this.backwardTransitionScores = new HashMap();
        this.update();
        model.addChangeListener(this.UPDATER);
    }

    public abstract double forward(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract double backward(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix forwardMatrix(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix backwardMatrix(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix forwardMatrix(SymbolList[] var1, DPMatrix var2, ScoreType var3) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract DPMatrix backwardMatrix(SymbolList[] var1, DPMatrix var2, ScoreType var3) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException;

    public abstract StatePath viterbi(SymbolList[] var1, ScoreType var2) throws IllegalSymbolException, IllegalArgumentException, IllegalAlphabetException, IllegalTransitionException;

    public DPMatrix forwardsBackwards(SymbolList[] symList, ScoreType scoreType) throws BioException {
        try {
            System.out.println("Making backward matrix");
            final DPMatrix bMatrix = this.backwardMatrix(symList, scoreType);
            System.out.println("Making forward matrix");
            final DPMatrix fMatrix = this.forwardMatrix(symList, scoreType);
            System.out.println("Making forward/backward matrix");
            return new DPMatrix(){

                public double getCell(int[] index) {
                    return fMatrix.getCell(index) + bMatrix.getCell(index);
                }

                public double getScore() {
                    return fMatrix.getScore();
                }

                public MarkovModel model() {
                    return fMatrix.model();
                }

                public SymbolList[] symList() {
                    return fMatrix.symList();
                }

                public State[] states() {
                    return fMatrix.states();
                }
            };
        }
        catch (Exception e) {
            throw new BioException(e, "Couldn't build forwards-backwards matrix");
        }
    }

    public StatePath generate(int length) throws IllegalSymbolException, BioException {
        Symbol token;
        ArrayList<Symbol> tokenList = new ArrayList<Symbol>();
        ArrayList<State> stateList = new ArrayList<State>();
        ArrayList<DoubleAlphabet.DoubleSymbol> scoreList = new ArrayList<DoubleAlphabet.DoubleSymbol>();
        double totScore = 0.0;
        double symScore = 0.0;
        int i = length;
        State oldState = (State)this.model.getWeights(this.model.magicalState()).sampleSymbol();
        symScore += this.model.getWeights(this.model.magicalState()).getWeight(oldState);
        DoubleAlphabet dAlpha = DoubleAlphabet.getInstance();
        if (oldState instanceof EmissionState) {
            EmissionState eState = (EmissionState)oldState;
            token = eState.getDistribution().sampleSymbol();
            stateList.add(oldState);
            tokenList.add(token);
            scoreList.add(dAlpha.getSymbol(symScore += eState.getDistribution().getWeight(token)));
            totScore += symScore;
            symScore = 0.0;
            --i;
        }
        while (i != 0) {
            State newState = null;
            Distribution dist = this.model.getWeights(oldState);
            while ((newState = (State)dist.sampleSymbol()) == this.model.magicalState() && i > 0) {
            }
            try {
                symScore += dist.getWeight(newState);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Transition returned from sampleTransition is invalid");
            }
            if (newState == this.model.magicalState()) break;
            if (newState instanceof EmissionState) {
                EmissionState eState = (EmissionState)newState;
                token = eState.getDistribution().sampleSymbol();
                stateList.add(newState);
                tokenList.add(token);
                scoreList.add(dAlpha.getSymbol(symScore += eState.getDistribution().getWeight(token)));
                totScore += symScore;
                symScore = 0.0;
                --i;
            }
            oldState = newState;
        }
        SimpleSymbolList tokens = new SimpleSymbolList(this.model.emissionAlphabet(), tokenList);
        SimpleSymbolList states = new SimpleSymbolList(this.model.stateAlphabet(), stateList);
        SimpleSymbolList scores = new SimpleSymbolList(dAlpha, scoreList);
        return new SimpleStatePath(totScore, tokens, states, new SimpleSymbolList(dAlpha, scoreList));
    }

    private static class HMMOrderByTransition {
        public static final Object GREATER_THAN = new Object();
        public static final Object LESS_THAN = new Object();
        public static final Object EQUAL = new Object();
        public static final Object DISJOINT = new Object();
        private MarkovModel mm;

        private HMMOrderByTransition(MarkovModel mm) {
            this.mm = mm;
        }

        public Object compare(Object o1, Object o2) throws IllegalTransitionException, IllegalSymbolException {
            if (o1 == o2) {
                return EQUAL;
            }
            State s1 = (State)o1;
            State s2 = (State)o2;
            if (this.transitionsTo(s1, s2)) {
                return LESS_THAN;
            }
            if (this.transitionsTo(s2, s1)) {
                return GREATER_THAN;
            }
            return DISJOINT;
        }

        private boolean transitionsTo(State from, State to) throws IllegalTransitionException, IllegalSymbolException {
            HashSet<State> checkedSet = new HashSet<State>();
            HashSet<Iterator> workingSet = new HashSet<Iterator>();
            Iterator i = this.mm.transitionsFrom(from).iterator();
            while (i.hasNext()) {
                workingSet.add(i);
            }
            while (workingSet.size() > 0) {
                HashSet<State> newWorkingSet = new HashSet<State>();
                Iterator i2 = workingSet.iterator();
                while (i2.hasNext()) {
                    State s = (State)i2.next();
                    if (s instanceof EmissionState) continue;
                    if (s == from) {
                        throw new IllegalTransitionException(from, from, "Loop in dot states.");
                    }
                    if (s == to) {
                        return true;
                    }
                    Iterator j = this.mm.transitionsFrom(s).iterator();
                    while (j.hasNext()) {
                        State s2 = (State)j.next();
                        if (workingSet.contains(s2) || checkedSet.contains(s2)) continue;
                        newWorkingSet.add(s2);
                    }
                    checkedSet.add(s);
                }
                workingSet = newWorkingSet;
            }
            return false;
        }
    }

    public static class ReverseIterator
    implements Iterator,
    Serializable {
        private SymbolList sym;
        private int index;

        public ReverseIterator(SymbolList sym) {
            this.sym = sym;
            this.index = sym.length();
        }

        public boolean hasNext() {
            return this.index > 0;
        }

        public Object next() {
            return this.sym.symbolAt(this.index--);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("This itterator can not cause modifications");
        }
    }
}

