/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.ViewSequence;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class WeightMatrixAnnotator
implements SequenceAnnotator,
Serializable {
    private WeightMatrix matrix;
    private double threshold;

    public Sequence annotate(Sequence seq) throws IllegalAlphabetException, BioException, ChangeVetoException {
        seq = new ViewSequence(seq);
        int cols = this.matrix.columns();
        Feature.Template template = new Feature.Template();
        template.source = "WeightMatrixAnnotator";
        template.type = "hit";
        for (int offset = 1; offset <= seq.length() - cols + 1; ++offset) {
            double score = DP.scoreWeightMatrix(this.matrix, seq, offset);
            double q = Math.exp(score);
            if (!(q >= this.threshold)) continue;
            template.location = new RangeLocation(offset, offset + cols - 1);
            SimpleAnnotation ann = new SimpleAnnotation();
            ann.setProperty("score", new Double(q));
            ann.setProperty("weightMatrix", this.matrix);
            template.annotation = ann;
            seq.createFeature(template);
        }
        return seq;
    }

    public WeightMatrixAnnotator(WeightMatrix wm, double threshold) {
        this.matrix = wm;
        this.threshold = threshold;
    }
}

