/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.onehead;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleStatePath;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.onehead.DPCursor;
import org.biojava.bio.dp.onehead.MatrixCursor;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.dp.onehead.SmallCursor;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleGappedSymbolList;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SingleDP
extends DP
implements Serializable {
    protected final HashMap emissionsProb = new HashMap();
    protected final HashMap emissionsOdds = new HashMap();
    protected final HashMap emissionsNull = new HashMap();

    public SingleDP(MarkovModel model) throws IllegalSymbolException, IllegalTransitionException, BioException {
        super(model);
    }

    public void update() {
        super.update();
        if (this.emissionsProb != null) {
            this.emissionsProb.clear();
        }
        if (this.emissionsOdds != null) {
            this.emissionsOdds.clear();
        }
        if (this.emissionsNull != null) {
            this.emissionsNull.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public double[] getEmission(Symbol sym, ScoreType scoreType) throws IllegalSymbolException {
        void var3_3;
        HashMap emissions;
        if (scoreType == ScoreType.PROBABILITY) {
            emissions = this.emissionsProb;
        } else if (scoreType == ScoreType.ODDS) {
            emissions = this.emissionsOdds;
        } else if (scoreType == ScoreType.NULL_MODEL) {
            emissions = this.emissionsNull;
        } else {
            throw new BioError("Unknown ScoreType object: " + scoreType);
        }
        double[] em = (double[])var3_3.get(sym);
        if (em == null) {
            int dsi = this.getDotStatesIndex();
            em = new double[dsi];
            State[] states = this.getStates();
            em[0] = sym == AlphabetManager.getGapSymbol() ? 0.0 : Double.NEGATIVE_INFINITY;
            for (int i = 1; i < dsi; ++i) {
                EmissionState es = (EmissionState)states[i];
                Distribution dis = es.getDistribution();
                double emS = scoreType.calculateScore(dis, sym);
                em[i] = emS > 0.0 ? Math.log(emS) : Double.NEGATIVE_INFINITY;
            }
            var3_3.put(sym, em);
        }
        return em;
    }

    public double forward(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SmallCursor dpCursor = new SmallCursor(this.getStates(), seq[0], seq[0].iterator());
        double score = this.forward(dpCursor, scoreType);
        this.unlockModel();
        return score;
    }

    public double backward(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SmallCursor dpCursor = new SmallCursor(this.getStates(), seq[0], new DP.ReverseIterator(seq[0]));
        double score = this.backward(dpCursor, scoreType);
        this.unlockModel();
        return score;
    }

    public DPMatrix forwardMatrix(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix matrix = new SingleDPMatrix(this, seq[0]);
        MatrixCursor dpCursor = new MatrixCursor(matrix, seq[0].iterator(), 1);
        matrix.setScore(this.forward(dpCursor, scoreType));
        this.unlockModel();
        return matrix;
    }

    public DPMatrix backwardMatrix(SymbolList[] seq, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix matrix = new SingleDPMatrix(this, seq[0]);
        MatrixCursor dpCursor = new MatrixCursor(matrix, new DP.ReverseIterator(seq[0]), -1);
        matrix.setScore(this.backward(dpCursor, scoreType));
        this.unlockModel();
        return matrix;
    }

    public DPMatrix forwardMatrix(SymbolList[] seq, DPMatrix matrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix sm = (SingleDPMatrix)matrix;
        MatrixCursor dpCursor = new MatrixCursor(sm, seq[0].iterator(), 1);
        sm.setScore(this.forward(dpCursor, scoreType));
        this.unlockModel();
        return sm;
    }

    public DPMatrix backwardMatrix(SymbolList[] seq, DPMatrix matrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (seq.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + seq.length);
        }
        this.lockModel();
        SingleDPMatrix sm = (SingleDPMatrix)matrix;
        MatrixCursor dpCursor = new MatrixCursor(sm, new DP.ReverseIterator(seq[0]), -1);
        sm.setScore(this.backward(dpCursor, scoreType));
        this.unlockModel();
        return sm;
    }

    protected double forward(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        this.forward_initialize(dpCursor, scoreType);
        this.forward_recurse(dpCursor, scoreType);
        return this.forward_termination(dpCursor, scoreType);
    }

    protected double backward(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        this.backward_initialize(dpCursor, scoreType);
        this.backward_recurse(dpCursor, scoreType);
        return this.backward_termination(dpCursor, scoreType);
    }

    protected void forward_initialize(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] v = dpCursor.currentCol();
        State[] states = this.getStates();
        for (int l = 0; l < this.getDotStatesIndex(); ++l) {
            v[l] = states[l] == this.getModel().magicalState() ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        int[][] transitions = this.getForwardTransitions();
        double[][] transitionScore = this.getForwardTransitionScores(scoreType);
        double[] currentCol = dpCursor.currentCol();
        for (int l = this.getDotStatesIndex(); l < states.length; ++l) {
            int ci;
            double score = 0.0;
            int[] tr = transitions[l];
            double[] trs = transitionScore[l];
            for (ci = 0; ci < tr.length && (currentCol[tr[ci]] == Double.NEGATIVE_INFINITY || currentCol[tr[ci]] == Double.NaN || currentCol[tr[ci]] == Double.POSITIVE_INFINITY); ++ci) {
            }
            double constant = ci < tr.length ? currentCol[tr[ci]] : 0.0;
            for (int kc = 0; kc < tr.length; ++kc) {
                int k = tr[kc];
                if (currentCol[k] == Double.NEGATIVE_INFINITY || currentCol[k] == Double.NaN || currentCol[k] == Double.POSITIVE_INFINITY) continue;
                double t = trs[kc];
                score += Math.exp(t + (currentCol[k] - constant));
            }
            currentCol[l] = Math.log(score) + constant;
        }
    }

    protected void backward_initialize(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] v = dpCursor.currentCol();
        State[] states = this.getStates();
        for (int l = 0; l < states.length; ++l) {
            v[l] = states[l] == this.getModel().magicalState() ? 0.0 : Double.NEGATIVE_INFINITY;
        }
    }

    protected void forward_recurse(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        State[] states = this.getStates();
        int stateCount = states.length;
        int[][] transitions = this.getForwardTransitions();
        double[][] transitionScore = this.getForwardTransitionScores(scoreType);
        while (dpCursor.canAdvance()) {
            int l;
            dpCursor.advance();
            Symbol sym = dpCursor.currentRes();
            double[] emissions = this.getEmission(sym, scoreType);
            double[] currentCol = dpCursor.currentCol();
            double[] lastCol = dpCursor.lastCol();
            for (l = 0; l < this.getDotStatesIndex(); ++l) {
                int ci;
                double weight = emissions[l];
                if (weight == Double.NEGATIVE_INFINITY) {
                    currentCol[l] = Double.NEGATIVE_INFINITY;
                    continue;
                }
                double score = 0.0;
                int[] tr = transitions[l];
                double[] trs = transitionScore[l];
                for (ci = 0; ci < tr.length && (lastCol[tr[ci]] == Double.NEGATIVE_INFINITY || lastCol[tr[ci]] == Double.NaN || lastCol[tr[ci]] == Double.POSITIVE_INFINITY); ++ci) {
                }
                double constant = ci < tr.length ? lastCol[tr[ci]] : 0.0;
                for (int kc = 0; kc < tr.length; ++kc) {
                    int k = tr[kc];
                    if (lastCol[k] != Double.NEGATIVE_INFINITY && lastCol[k] != Double.NaN) {
                        double t = trs[kc];
                        score += Math.exp(t + (lastCol[k] - constant));
                        continue;
                    }
                    if (lastCol[k] != Double.NaN) continue;
                    System.out.println("k=" + states[k].getName() + "->l=" + states[l].getName());
                    System.out.println("-");
                }
                currentCol[l] = weight + Math.log(score) + constant;
                if (!new Double(currentCol[l]).isNaN()) continue;
                System.out.println("currentCol[" + states[l].getName() + "]=" + currentCol[l]);
                System.out.println("weight=" + weight + ", score=" + score + ", constant=" + constant);
                currentCol[l] = Double.NEGATIVE_INFINITY;
            }
            for (l = this.getDotStatesIndex(); l < states.length; ++l) {
                int ci;
                double score = 0.0;
                int[] tr = transitions[l];
                double[] trs = transitionScore[l];
                for (ci = 0; ci < tr.length && (currentCol[tr[ci]] == Double.NEGATIVE_INFINITY || currentCol[tr[ci]] == Double.NaN || currentCol[tr[ci]] == Double.POSITIVE_INFINITY); ++ci) {
                }
                double constant = ci < tr.length ? currentCol[tr[ci]] : 0.0;
                for (int kc = 0; kc < tr.length; ++kc) {
                    int k = tr[kc];
                    if (currentCol[k] != Double.NEGATIVE_INFINITY && currentCol[k] != Double.NaN && currentCol[k] != Double.POSITIVE_INFINITY) {
                        double t = trs[kc];
                        score += Math.exp(t + (currentCol[k] - constant));
                        continue;
                    }
                    if (currentCol[k] != Double.NaN) continue;
                    System.out.println("k=" + states[k].getName() + "->l=" + states[l].getName());
                }
                currentCol[l] = score >= 0.0 && score != Double.NaN ? Math.log(score) + constant : Double.NEGATIVE_INFINITY;
            }
        }
    }

    protected void backward_recurse(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        State[] states = this.getStates();
        int stateCount = states.length;
        int[][] transitions = this.getBackwardTransitions();
        double[][] transitionScore = this.getBackwardTransitionScores(scoreType);
        double[] prevScores = new double[this.getDotStatesIndex()];
        while (dpCursor.canAdvance()) {
            int k;
            dpCursor.advance();
            Symbol sym = dpCursor.lastRes();
            double[] emissions = this.getEmission(sym, scoreType);
            double[] currentCol = dpCursor.currentCol();
            double[] lastCol = dpCursor.lastCol();
            for (k = this.getDotStatesIndex() - 1; k >= 0; --k) {
                prevScores[k] = emissions[k];
            }
            for (k = stateCount - 1; k >= 0; --k) {
                int l;
                int lc;
                int ci;
                int[] tr = transitions[k];
                double[] trs = transitionScore[k];
                double score = 0.0;
                for (ci = 0; ci < tr.length && lastCol[tr[ci]] == Double.NEGATIVE_INFINITY; ++ci) {
                }
                double constant = ci < tr.length ? lastCol[tr[ci]] : 0.0;
                for (lc = tr.length - 1; lc >= 0; --lc) {
                    l = tr[lc];
                    if (l >= this.getDotStatesIndex()) continue;
                    double weight = prevScores[l];
                    if (lastCol[l] == Double.NEGATIVE_INFINITY || weight == Double.NEGATIVE_INFINITY) continue;
                    double t = trs[lc];
                    score += Math.exp(t + weight + (lastCol[l] - constant));
                }
                for (lc = tr.length - 1; lc >= 0 && (l = tr[lc]) >= this.getDotStatesIndex() && l > k; --lc) {
                    if (currentCol[l] == Double.NEGATIVE_INFINITY) continue;
                    score += Math.exp(trs[lc] + (currentCol[l] - constant));
                }
                currentCol[k] = Math.log(score) + constant;
            }
        }
    }

    protected double forward_termination(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] scores = dpCursor.currentCol();
        State[] states = this.getStates();
        int l = 0;
        while (states[l] != this.getModel().magicalState()) {
            ++l;
        }
        return scores[l];
    }

    protected double backward_termination(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        double[] scores = dpCursor.currentCol();
        State[] states = this.getStates();
        int l = 0;
        while (states[l] != this.getModel().magicalState()) {
            ++l;
        }
        return scores[l];
    }

    public StatePath viterbi(SymbolList[] symList, ScoreType scoreType) throws IllegalSymbolException {
        SymbolList r = symList[0];
        SmallCursor dpCursor = new SmallCursor(this.getStates(), r, r.iterator());
        return this.viterbi(dpCursor, scoreType);
    }

    protected StatePath viterbi(DPCursor dpCursor, ScoreType scoreType) throws IllegalSymbolException {
        int l;
        this.lockModel();
        int seqLength = dpCursor.length();
        State[] states = this.getStates();
        int[][] transitions = this.getForwardTransitions();
        double[][] transitionScore = this.getForwardTransitionScores(scoreType);
        int stateCount = states.length;
        BackPointer[] oldPointers = new BackPointer[stateCount];
        BackPointer[] newPointers = new BackPointer[stateCount];
        double[] vc = dpCursor.currentCol();
        double[] vl = dpCursor.lastCol();
        for (l = 0; l < this.getDotStatesIndex(); ++l) {
            if (states[l] == this.getModel().magicalState()) {
                vl[l] = 0.0;
                vc[l] = 0.0;
                oldPointers[l] = newPointers[l] = new BackPointer(states[l]);
                continue;
            }
            vl[l] = Double.NEGATIVE_INFINITY;
            vc[l] = Double.NEGATIVE_INFINITY;
        }
        for (l = this.getDotStatesIndex(); l < stateCount; ++l) {
            int[] tr = transitions[l];
            double[] trs = transitionScore[l];
            double transProb = Double.NEGATIVE_INFINITY;
            double trans = Double.NEGATIVE_INFINITY;
            int prev = -1;
            for (int kc = 0; kc < tr.length; ++kc) {
                double t = trs[kc];
                int k = tr[kc];
                double s = vc[k];
                double p = t + s;
                if (!(p > transProb)) continue;
                transProb = p;
                prev = k;
                trans = t;
            }
            if (prev != -1) {
                vc[l] = vl[l] = transProb;
                oldPointers[l] = newPointers[l] = new BackPointer(states[l], newPointers[prev], trans);
                continue;
            }
            vl[l] = Double.NEGATIVE_INFINITY;
            vc[l] = Double.NEGATIVE_INFINITY;
            newPointers[l] = null;
            oldPointers[l] = null;
        }
        while (dpCursor.canAdvance()) {
            dpCursor.advance();
            Symbol sym = dpCursor.currentRes();
            double[] emissions = this.getEmission(sym, scoreType);
            double[] currentCol = dpCursor.currentCol();
            double[] lastCol = dpCursor.lastCol();
            for (int l2 = 0; l2 < states.length; ++l2) {
                double emission = l2 < this.getDotStatesIndex() ? emissions[l2] : 0.0;
                int[] tr = transitions[l2];
                double[] trs = transitionScore[l2];
                if (emission == Double.NEGATIVE_INFINITY) {
                    currentCol[l2] = Double.NEGATIVE_INFINITY;
                    newPointers[l2] = null;
                    continue;
                }
                double transProb = Double.NEGATIVE_INFINITY;
                double trans = Double.NEGATIVE_INFINITY;
                int prev = -1;
                for (int kc = 0; kc < tr.length; ++kc) {
                    int k = tr[kc];
                    double t = trs[kc];
                    double s = l2 < this.getDotStatesIndex() ? lastCol[k] : currentCol[k];
                    double p = t + s;
                    if (!(p > transProb)) continue;
                    transProb = p;
                    prev = k;
                    trans = t;
                }
                if (prev != -1) {
                    currentCol[l2] = transProb + emission;
                    newPointers[l2] = new BackPointer(states[l2], l2 < this.getDotStatesIndex() ? oldPointers[prev] : newPointers[prev], trans + emission);
                    continue;
                }
                currentCol[l2] = Double.NEGATIVE_INFINITY;
                newPointers[l2] = null;
            }
            BackPointer[] bp = newPointers;
            newPointers = oldPointers;
            oldPointers = bp;
        }
        BackPointer best = null;
        double bestScore = Double.NaN;
        for (int l3 = 0; l3 < stateCount; ++l3) {
            if (states[l3] != this.getModel().magicalState()) continue;
            best = oldPointers[l3].back;
            bestScore = dpCursor.currentCol()[l3];
            break;
        }
        int len = 0;
        BackPointer b2 = best;
        int dotC = 0;
        int emC = 0;
        while (b2.back != b2) {
            ++len;
            if (b2.state instanceof EmissionState) {
                ++emC;
            } else {
                ++dotC;
            }
            b2 = b2.back;
        }
        HashMap<SymbolList, SymbolList> aMap = new HashMap<SymbolList, SymbolList>();
        aMap.put(dpCursor.symList(), dpCursor.symList());
        SimpleAlignment ali = new SimpleAlignment(aMap);
        SimpleGappedSymbolList symView = new SimpleGappedSymbolList(ali);
        double[] scores = new double[len];
        ArrayList<State> stateList = new ArrayList<State>(len);
        for (int j = 0; j < len; ++j) {
            stateList.add(null);
        }
        b2 = best;
        int ri = dpCursor.symList().length() + 1;
        int lc = len;
        int gaps = 0;
        while (b2.back != b2) {
            --lc;
            if (b2.state instanceof MagicalState) {
                b2 = b2.back;
                continue;
            }
            stateList.set(lc, b2.state);
            if (b2.state instanceof DotState) {
                symView.addGapInSource(ri);
                ++gaps;
            } else {
                --ri;
            }
            scores[lc] = b2.score;
            b2 = b2.back;
        }
        this.unlockModel();
        return new SimpleStatePath(bestScore, symView, new SimpleSymbolList(this.getModel().stateAlphabet(), stateList), DoubleAlphabet.fromArray(scores));
    }
}

