/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.molbio;

import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.MotifTools;
import org.biojava.bio.symbol.SymbolList;

public class RestrictionEnzyme
implements Serializable {
    public static final int CUT_SIMPLE = 0;
    public static final int CUT_COMPOUND = 1;
    public static final int OVERHANG_5PRIME = 0;
    public static final int OVERHANG_3PRIME = 1;
    public static final int BLUNT = 2;
    protected String name;
    protected SymbolList site;
    protected int cutType;
    protected int[] dsCutPositions;
    protected int[] usCutPositions;
    protected String forwardRegex;
    protected String reverseRegex;
    private String summary;

    public RestrictionEnzyme(String name, SymbolList site, int dsForward, int dsReverse) throws IllegalAlphabetException {
        this(name, site, null, new int[]{dsForward, dsReverse});
        this.cutType = 0;
    }

    public RestrictionEnzyme(String name, SymbolList site, int usForward, int usReverse, int dsForward, int dsReverse) throws IllegalAlphabetException {
        this(name, site, new int[]{usForward, usReverse}, new int[]{dsForward, dsReverse});
        this.cutType = 1;
    }

    private RestrictionEnzyme(String name, SymbolList site, int[] usCutPositions, int[] dsCutPositions) throws IllegalAlphabetException {
        if (site.getAlphabet() != DNATools.getDNA()) {
            throw new IllegalAlphabetException("RestrictionEnzyme site can only be a DNA SymbolList. A SymbolList using the " + site.getAlphabet().getName() + " was supplied");
        }
        this.name = name;
        this.site = site;
        this.usCutPositions = usCutPositions;
        this.dsCutPositions = dsCutPositions;
        this.forwardRegex = MotifTools.createRegex(site);
        try {
            this.reverseRegex = MotifTools.createRegex(DNATools.reverseComplement(site));
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError(iae, "RestrictionEnzyme site was not composed of a complementable Alphabet");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append(" ");
        if (usCutPositions != null) {
            sb.append("(");
            sb.append(usCutPositions[0]);
            sb.append("/");
            sb.append(usCutPositions[1]);
            sb.append(") ");
        }
        try {
            for (int i = 1; i <= site.length(); ++i) {
                sb.append(Character.toUpperCase(DNATools.dnaToken(site.symbolAt(i))));
            }
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "RestrictionEnzyme site contained non-DNA Symbol");
        }
        sb.append(" (");
        sb.append(dsCutPositions[0]);
        sb.append("/");
        sb.append(dsCutPositions[1]);
        sb.append(")");
        this.summary = sb.substring(0);
    }

    public String getName() {
        return this.name;
    }

    public SymbolList getRecognitionSite() {
        return this.site;
    }

    public String getForwardRegex() {
        return this.forwardRegex;
    }

    public String getReverseRegex() {
        return this.reverseRegex;
    }

    public boolean isPalindromic() {
        return this.forwardRegex.equals(this.reverseRegex);
    }

    public int getCutType() {
        return this.cutType;
    }

    public int[] getDownstreamCut() {
        return this.dsCutPositions;
    }

    public int[] getUpstreamCut() throws BioException {
        if (this.cutType == 0) {
            throw new BioException(this.name + " does not cut upstream of the recognition site");
        }
        return this.usCutPositions;
    }

    public int getDownstreamEndType() {
        if (this.dsCutPositions[0] > this.dsCutPositions[1]) {
            return 0;
        }
        if (this.dsCutPositions[0] < this.dsCutPositions[1]) {
            return 1;
        }
        return 2;
    }

    public int getUpstreamEndType() throws BioException {
        if (this.cutType == 0) {
            throw new BioException(this.name + " does not cut upstream of the recognition site");
        }
        if (this.usCutPositions[0] > this.usCutPositions[1]) {
            return 0;
        }
        if (this.usCutPositions[0] < this.usCutPositions[1]) {
            return 1;
        }
        return 2;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.forwardRegex.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RestrictionEnzyme && this.name.equals(((RestrictionEnzyme)o).getName());
    }

    public String toString() {
        return this.summary;
    }
}

