/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

class DASComponentFeature
extends Unchangeable
implements ComponentFeature {
    private final DASSequence parent;
    private FeatureHolder projectedFeatures;
    private final Location location;
    private final StrandedFeature.Strand strand;
    private final String type;
    private final String source;
    private final Annotation annotation;
    private String componentID;
    private DASSequence componentSequence;
    private Location componentLocation;
    private final FeatureFilter membershipFilter;

    public DASComponentFeature(DASSequence parent, ComponentFeature.Template temp) throws BioException {
        if (this.locationContent(temp.location) != this.locationContent(temp.componentLocation)) {
            throw new BioException("Component and container locations must contain an equal number of symbols.");
        }
        if (!temp.location.isContiguous() || !temp.componentLocation.isContiguous()) {
            throw new BioException("Can only include contiguous segments in an assembly");
        }
        this.parent = parent;
        this.location = temp.location;
        this.componentLocation = temp.componentLocation;
        this.strand = temp.strand;
        this.type = temp.type;
        this.source = temp.source;
        this.annotation = temp.annotation;
        this.membershipFilter = new FeatureFilter.ContainedByLocation(this.location);
        if (temp.componentSequence != null) {
            this.componentSequence = (DASSequence)temp.componentSequence;
            this.componentID = this.componentSequence.getName();
        } else {
            this.componentID = temp.componentSequenceName;
            if (this.componentID == null) {
                try {
                    this.componentID = (String)temp.annotation.getProperty("sequence.id");
                }
                catch (NoSuchElementException ex) {
                    throw new BioRuntimeException("No sequence.id property");
                }
            }
        }
        if (this.strand != StrandedFeature.NEGATIVE && this.strand != StrandedFeature.POSITIVE) {
            throw new BioException("Strand must be specified when creating a ComponentFeature");
        }
    }

    private int locationContent(Location l) {
        if (l.isContiguous()) {
            return l.getMax() - l.getMin() + 1;
        }
        int content = 0;
        Iterator i = l.blockIterator();
        while (i.hasNext()) {
            Location sl = (Location)i.next();
            content += sl.getMax() - sl.getMin() + 1;
        }
        return content;
    }

    public boolean isComponentResolvable() {
        return true;
    }

    public String getComponentSequenceName() {
        return this.componentID;
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location loc) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, Feature.LOCATION, loc, this.location), "Can't change location as it is immutable");
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    public Sequence getSequence() {
        return this.parent;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, Feature.TYPE, source, this.source), "Can't change source as it is immutable");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, Feature.TYPE, type, this.type), "Can't change type as it is immutable");
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public SymbolList getSymbols() {
        SymbolList syms = this.componentLocation.symbols(this.getComponentSequence());
        return syms;
    }

    DASSequence getSequenceLazy() {
        return this.componentSequence;
    }

    public Sequence getComponentSequence() {
        return this._getComponentSequence();
    }

    private DASSequence _getComponentSequence() {
        if (this.componentSequence == null) {
            try {
                this.componentSequence = this.parent.getParentDB()._getSequence(this.componentID, this.parent.dataSourceURLs());
            }
            catch (Exception ex) {
                throw new BioRuntimeException(ex, "Couldn't create child DAS sequence");
            }
        }
        return this.componentSequence;
    }

    public Location getComponentLocation() {
        return this.componentLocation;
    }

    /*
     * WARNING - void declaration
     */
    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            void var2_2;
            void var1_1;
            boolean flip;
            int translation;
            if (this.strand == StrandedFeature.NEGATIVE) {
                translation = this.location.getMax() + this.componentLocation.getMin();
                flip = true;
            } else if (this.strand == StrandedFeature.POSITIVE) {
                translation = this.location.getMin() - this.componentLocation.getMin();
                flip = false;
            } else {
                throw new BioError("No strand -- erk!");
            }
            this.projectedFeatures = new ProjectedFeatureHolder(this.getComponentSequence(), this, (int)var1_1, (boolean)var2_2);
        }
        return this.projectedFeatures;
    }

    public int countFeatures() {
        return this.getComponentSequence().countFeatures();
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public boolean containsFeature(Feature f) {
        return this.getProjectedFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (FilterUtils.areDisjoint(ff, this.membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        if (FilterUtils.areDisjoint(ff, this.membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff);
    }

    public Feature createFeature(Feature.Template temp) throws BioException {
        throw new BioException("Can't create features in a ComponentFeature (yet?)");
    }

    public void removeFeature(Feature f) {
        throw new UnsupportedOperationException("Can't remove features from a ComponentFeature.");
    }

    public Feature.Template makeTemplate() {
        ComponentFeature.Template temp = new ComponentFeature.Template();
        temp.type = this.getType();
        temp.source = this.getSource();
        temp.location = this.getLocation();
        temp.annotation = this.getAnnotation();
        temp.strand = this.getStrand();
        temp.componentLocation = this.getComponentLocation();
        temp.componentSequenceName = this.componentID;
        return temp;
    }

    public FeatureFilter getSchema() {
        return new FeatureFilter.ByParent(new FeatureFilter.ByFeature(this));
    }
}

