/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.biojava.bio.AbstractAnnotation;
import org.biojava.bio.BioError;
import org.biojava.utils.Commitable;

class PropertiesAnnotation
extends AbstractAnnotation
implements Commitable {
    private Properties props;
    private File propsFile;

    public PropertiesAnnotation(File propsFile) {
        this.propsFile = propsFile;
        this.props = new Properties();
        if (propsFile.exists()) {
            try {
                this.props.load(new FileInputStream(propsFile));
            }
            catch (IOException ioe) {
                throw new BioError(ioe, "Assertion Failure: could not load properties");
            }
        }
    }

    public void commit() {
        try {
            this.props.store(new FileOutputStream(this.propsFile), "Meta-Data");
        }
        catch (IOException ioe) {
            try {
                this.rollback();
            }
            catch (BioError be) {
                throw new BioError(be, "Catastrophic failure: could not roll back after failed commit");
            }
            throw new BioError("Could not commit");
        }
    }

    public void rollback() {
        if (this.propsFile.exists()) {
            try {
                this.props.load(new FileInputStream(this.propsFile));
            }
            catch (IOException ioe) {
                throw new BioError("Could not roll back");
            }
        } else {
            this.props.clear();
        }
    }

    protected Map getProperties() {
        return this.props;
    }

    protected boolean propertiesAllocated() {
        return true;
    }
}

