/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.program.ssaha.SearchListener;

public class HitMerger
implements SearchListener {
    private List hitList = new ArrayList();
    private int minLength;
    private SearchListener delegate;

    public HitMerger(SearchListener delegate, int minLength) {
        this.delegate = delegate;
        this.minLength = minLength;
    }

    public void startSearch(String seqID) {
        this.hitList.clear();
        this.delegate.startSearch(seqID);
    }

    public void hit(int hitID, int queryOffset, int hitOffset, int hitLength) {
        this.hitList.add(new Record(hitID, queryOffset, hitOffset, hitLength));
    }

    public void endSearch(String seqID) {
        if (!this.hitList.isEmpty()) {
            Collections.sort(this.hitList);
            Iterator i = this.hitList.iterator();
            Record last = (Record)i.next();
            while (i.hasNext()) {
                Record current = (Record)i.next();
                if (current.hitID == last.hitID && current.queryOffset <= last.queryOffset + last.hitLength && current.hitOffset <= last.hitOffset + last.hitLength && current.hitOffset - last.hitOffset == current.queryOffset - last.queryOffset) {
                    last.hitLength = current.hitOffset + current.hitLength - last.hitOffset;
                    continue;
                }
                if (last.hitLength >= this.minLength) {
                    this.delegate.hit(last.hitID, last.queryOffset, last.hitOffset, last.hitLength);
                }
                last = current;
            }
            if (last.hitLength >= this.minLength) {
                this.delegate.hit(last.hitID, last.queryOffset, last.hitOffset, last.hitLength);
            }
        }
        this.delegate.endSearch(seqID);
    }

    private static class Record
    implements Comparable {
        public int hitID;
        public int queryOffset;
        public int hitOffset;
        public int hitLength;

        public Record(int hitID, int queryOffset, int hitOffset, int hitLength) {
            this.hitID = hitID;
            this.queryOffset = queryOffset;
            this.hitOffset = hitOffset;
            this.hitLength = hitLength;
        }

        public boolean equals(Object o) {
            if (o instanceof Record) {
                Record r = (Record)o;
                return this.hitID == r.hitID && this.queryOffset == r.queryOffset && this.hitOffset == r.hitOffset && this.hitLength == r.hitLength;
            }
            return false;
        }

        public int compareTo(Object o) {
            Record r = (Record)o;
            if (this.hitID > r.hitID) {
                return 1;
            }
            if (this.hitID < r.hitID) {
                return -1;
            }
            int relDist = this.queryOffset + this.hitOffset - (r.queryOffset + r.hitOffset);
            if (relDist > 0) {
                return 1;
            }
            if (relDist < 0) {
                return -1;
            }
            if (this.hitOffset > r.hitOffset) {
                return 1;
            }
            if (this.hitOffset < r.hitOffset) {
                return -1;
            }
            if (this.hitLength > r.hitLength) {
                return 1;
            }
            if (this.hitLength < r.hitLength) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.hitID + " " + this.queryOffset + " " + this.hitOffset + " " + this.hitLength;
        }
    }
}

