/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.unigene;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Statement;
import org.biojava.bio.BioException;
import org.biojava.bio.program.unigene.SQLUnigeneDB;
import org.biojava.bio.program.unigene.UnigeneDB;
import org.biojava.bio.program.unigene.UnigeneFactory;
import org.biojava.utils.JDBCConnectionPool;

public class SQLUnigeneFactory
implements UnigeneFactory {
    private static String CREATE_DB_STATEMENT;
    static /* synthetic */ Class class$org$biojava$bio$program$unigene$SQLUnigeneFactory;

    private static String getCreateDBStatement() {
        if (CREATE_DB_STATEMENT == null) {
            StringBuffer stmt = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$org$biojava$bio$program$unigene$SQLUnigeneFactory == null ? (class$org$biojava$bio$program$unigene$SQLUnigeneFactory = SQLUnigeneFactory.class$("org.biojava.bio.program.unigene.SQLUnigeneFactory")) : class$org$biojava$bio$program$unigene$SQLUnigeneFactory).getClassLoader().getResourceAsStream("/org/biojava/bio/program/unigene/createUnigene.sql")));
        }
        return CREATE_DB_STATEMENT;
    }

    public boolean canAccept(URL dbURL) {
        return dbURL.getProtocol().equals("jdbc");
    }

    public UnigeneDB loadUnigene(URL dbURL) throws BioException {
        if (!this.canAccept(dbURL)) {
            throw new BioException("Can't resolve url to an sql unigene db: " + dbURL);
        }
        JDBCConnectionPool conPool = new JDBCConnectionPool(dbURL.toString());
        return new SQLUnigeneDB(conPool);
    }

    public UnigeneDB createUnigene(URL dbURL) throws BioException {
        String dbString = dbURL.toString();
        int lastSlash = dbString.lastIndexOf("/");
        String rootURL = dbString.substring(0, lastSlash);
        String dbName = dbString.substring(lastSlash + 1);
        JDBCConnectionPool connPool = new JDBCConnectionPool(rootURL);
        Statement stmt = null;
        try {
            stmt = connPool.takeStatement();
            stmt.execute("create database " + dbName);
            stmt.execute("use " + dbName);
            stmt.execute(SQLUnigeneFactory.getCreateDBStatement());
        }
        catch (SQLException se) {
            throw new BioException(se, "Could not create database");
        }
        finally {
            try {
                connPool.putStatement(stmt);
            }
            catch (SQLException se) {}
        }
        return new SQLUnigeneDB(connPool);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

