/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.xff;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.program.xff.ElementRecognizer;
import org.biojava.bio.program.xff.FeatureHandler;
import org.biojava.bio.program.xff.PropDetailHandler;
import org.biojava.bio.program.xff.StrandedFeatureHandler;
import org.biojava.bio.program.xff.XFFPartHandlerFactory;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XFFFeatureSetHandler
extends StAXContentHandlerBase {
    public static final String PROPERTY_XFF_ID = "org.biojava.bio.program.xff.id";
    private List featureHandlers = new ArrayList();
    private List detailHandlers = new ArrayList();
    private SeqIOListener featureListener;
    private boolean inFeatureSet = false;

    public XFFFeatureSetHandler() {
        this.addFeatureHandler(ElementRecognizer.ALL, FeatureHandler.FEATURE_HANDLER_FACTORY);
        this.addFeatureHandler(new ElementRecognizer.HasAttribute("strand"), StrandedFeatureHandler.STRANDEDFEATURE_HANDLER_FACTORY);
        this.addDetailHandler(new ElementRecognizer.ByLocalName("prop"), PropDetailHandler.PROPDETAIL_HANDLER_FACTORY);
    }

    public void setFeatureListener(SeqIOListener siol) {
        this.featureListener = siol;
    }

    public SeqIOListener getFeatureListener() {
        return this.featureListener;
    }

    public void addFeatureHandler(ElementRecognizer rec, XFFPartHandlerFactory handler) {
        this.featureHandlers.add(new Binding(rec, handler));
    }

    public void addDetailHandler(ElementRecognizer rec, XFFPartHandlerFactory handler) {
        this.detailHandlers.add(new Binding(rec, handler));
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        if (localName.equals("featureSet")) {
            this.inFeatureSet = true;
            return;
        }
        for (int i = this.featureHandlers.size() - 1; i >= 0; --i) {
            Binding b = (Binding)this.featureHandlers.get(i);
            if (!b.recognizer.filterStartElement(nsURI, localName, qName, attrs)) continue;
            dm.delegate(b.handlerFactory.getPartHandler(this));
            return;
        }
        throw new SAXException("Couldn't handle element " + localName + " in namespace " + nsURI);
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) {
        if (localName.equals("featureSet")) {
            this.inFeatureSet = false;
        }
    }

    public StAXContentHandlerBase getDetailsHandler() {
        return new XFFDetailsHandler();
    }

    private class XFFDetailsHandler
    extends StAXContentHandlerBase {
        private boolean inDetails;

        private XFFDetailsHandler() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (localName.equals("details")) {
                this.inDetails = true;
                return;
            }
            for (int i = XFFFeatureSetHandler.this.detailHandlers.size() - 1; i >= 0; --i) {
                Binding b = (Binding)XFFFeatureSetHandler.this.detailHandlers.get(i);
                if (!b.recognizer.filterStartElement(nsURI, localName, qName, attrs)) continue;
                dm.delegate(b.handlerFactory.getPartHandler(XFFFeatureSetHandler.this));
                return;
            }
        }

        public void endElement(String nsURI, String localName, String qName) {
            if (localName.equals("details")) {
                this.inDetails = false;
            }
        }
    }

    class Binding {
        final ElementRecognizer recognizer;
        final XFFPartHandlerFactory handlerFactory;

        Binding(ElementRecognizer er, XFFPartHandlerFactory hf) {
            this.recognizer = er;
            this.handlerFactory = hf;
        }
    }
}

