/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.xff;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.xerces.parsers.SAXParser;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.xff.PropertyWriter;
import org.biojava.bio.program.xff.XFFFeatureSetHandler;
import org.biojava.bio.program.xff.XFFWriter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SequenceBuilderBase;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.DummySymbolList;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XFFTools {
    public static void annotateXFF(File xffFile, Sequence sequence) throws IOException, SAXException, BioException {
        SequenceBuilderBase sb = new SequenceBuilderBase(sequence){
            private final /* synthetic */ Sequence val$sequence;
            {
                this.seq = this.val$sequence = val$sequence;
            }

            public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) {
            }
        };
        XFFFeatureSetHandler xffHandler = new XFFFeatureSetHandler();
        xffHandler.setFeatureListener(sb);
        SAX2StAXAdaptor saxHandler = new SAX2StAXAdaptor(xffHandler);
        SAXParser parser = new SAXParser();
        parser.setContentHandler((ContentHandler)saxHandler);
        InputSource is = new InputSource(new FileReader(xffFile));
        parser.parse(is);
        sb.makeSequence();
    }

    public static Sequence readXFF(File xffFile, String seqID, FiniteAlphabet alpha) throws IOException, SAXException, BioException {
        DummySymbolList dummy = new DummySymbolList(alpha, Integer.MAX_VALUE);
        SimpleSequence ourSeq = new SimpleSequence(dummy, seqID, seqID, new SmallAnnotation());
        XFFTools.annotateXFF(xffFile, ourSeq);
        return ourSeq;
    }

    public static void writeXFF(File xffFile, FeatureHolder features) throws IOException {
        PrintWriter xffPR = new PrintWriter(new FileWriter(xffFile));
        XFFTools.writeXFF(xffPR, features);
    }

    public static void writeXFF(PrintWriter xffPR, FeatureHolder features) throws IOException {
        PrettyXMLWriter xmlWriter = new PrettyXMLWriter(xffPR);
        XFFWriter xffWriter = new XFFWriter(new PropertyWriter());
        xffWriter.writeFeatureSet(features, xmlWriter);
        xffPR.flush();
        xffPR.close();
    }
}

