/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.ArrayList;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.CircularView;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public final class KnuthMorrisPrattSearch {
    private int[] kmpNext;
    private SymbolList pattern;

    public KnuthMorrisPrattSearch(SymbolList pattern) {
        Alphabet alpha = pattern.getAlphabet();
        ArrayList<Symbol> rList = new ArrayList<Symbol>(pattern.toList());
        rList.add(alpha.getGapSymbol());
        try {
            this.pattern = new SimpleSymbolList(alpha, rList);
        }
        catch (Exception e) {
            throw new BioError(e, "Couldn't make KMP pattern");
        }
        this.kmpNext = new int[this.pattern.length()];
        this.compilePattern();
    }

    private void compilePattern() {
        int k = this.pattern.length() - 1;
        int i = 0;
        this.kmpNext[0] = -1;
        int j = -1;
        while (i < k) {
            while (j > -1 && this.pattern.symbolAt(i + 1) != this.pattern.symbolAt(j + 1)) {
                j = this.kmpNext[j];
            }
            if (this.pattern.symbolAt(++i + 1) == this.pattern.symbolAt(++j + 1)) {
                this.kmpNext[i] = this.kmpNext[j];
                continue;
            }
            this.kmpNext[i] = j;
        }
    }

    public int[] findMatches(SymbolList text) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        int i = 0;
        int m = this.pattern.length() - 1;
        int n = text instanceof CircularView ? text.length() + this.pattern.length() - 1 : text.length();
        for (int j = 0; j < n; ++j) {
            Symbol sym = text.symbolAt(j + 1);
            while (i > -1 && this.pattern.symbolAt(i + 1) != sym) {
                i = this.kmpNext[i];
            }
            if (++i < m) continue;
            matches.add(new Integer(j - i + 1));
            i = this.kmpNext[i];
        }
        int[] mat = new int[matches.size()];
        for (int x = 0; x < mat.length; ++x) {
            mat[x] = (Integer)matches.get(x);
        }
        return mat;
    }

    protected int[] getKmpNextTable() {
        return this.kmpNext;
    }

    public SymbolList getPattern() {
        return this.pattern;
    }

    public static void main(String[] args) throws Exception {
        int i;
        SymbolList pattern = DNATools.createDNA("gcagagag");
        SymbolList pattern2 = DNATools.createDNA("agag");
        SymbolList text = DNATools.createDNA("gcatcgcagagagtatacagtacg");
        KnuthMorrisPrattSearch kmp1 = new KnuthMorrisPrattSearch(pattern);
        int[] table = kmp1.getKmpNextTable();
        System.out.println(pattern.seqString());
        for (i = 0; i < table.length; ++i) {
            System.out.print(table[i] + " ");
        }
        System.out.println("");
        int[] matches = kmp1.findMatches(text);
        System.out.print("Matches at: ");
        for (i = 0; i < matches.length; ++i) {
            System.out.print(matches[i] + " ");
        }
        System.out.println("\n");
        kmp1 = new KnuthMorrisPrattSearch(pattern2);
        table = kmp1.getKmpNextTable();
        System.out.println(pattern2.seqString());
        for (i = 0; i < table.length; ++i) {
            System.out.print(table[i] + " ");
        }
        System.out.println("");
        matches = kmp1.findMatches(text);
        System.out.print("Matches at: ");
        for (i = 0; i < matches.length; ++i) {
            System.out.print(matches[i] + " ");
        }
        System.out.println("\n");
    }
}

