/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.AnnotationTools;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.seq.AcceptAllFilter;
import org.biojava.bio.seq.AcceptNoneFilter;
import org.biojava.bio.seq.ByHierarchy;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Down;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.IsLeaf;
import org.biojava.bio.seq.IsTopLevel;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.Up;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;

public interface FeatureFilter
extends Serializable {
    public static final FeatureFilter all = new AcceptAllFilter();
    public static final FeatureFilter none = new AcceptNoneFilter();
    public static final FeatureFilter top_level = new IsTopLevel();
    public static final FeatureFilter leaf = new IsLeaf();

    public boolean accept(Feature var1);

    static class 1 {
        static /* synthetic */ Class class$org$biojava$bio$seq$Feature;
        static /* synthetic */ Class class$org$biojava$bio$seq$ComponentFeature;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class ByFeature
    implements OptimizableFilter {
        private final Feature feature;

        public ByFeature(Feature f) {
            this.feature = f;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public boolean accept(Feature f) {
            return f.equals(this.feature);
        }

        public boolean isProperSubset(FeatureFilter ff) {
            return ff.accept(this.feature);
        }

        public boolean isDisjoint(FeatureFilter ff) {
            return !ff.accept(this.feature);
        }

        public int hashCode() {
            return this.feature.hashCode() + 65;
        }

        public boolean equals(Object o) {
            if (o instanceof ByFeature) {
                return ((ByFeature)o).getFeature().equals(this.feature);
            }
            return false;
        }
    }

    public static final class ByComponentName
    implements OptimizableFilter {
        private String cname;

        public ByComponentName(String cname) {
            this.cname = cname;
        }

        public boolean accept(Feature f) {
            if (f instanceof ComponentFeature) {
                return this.cname.equals(((ComponentFeature)f).getComponentSequenceName());
            }
            return false;
        }

        public String getComponentName() {
            return this.cname;
        }

        public boolean equals(Object o) {
            return o instanceof ByComponentName && ((ByComponentName)o).getComponentName().equals(this.cname);
        }

        public int hashCode() {
            return this.getComponentName().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ByComponentName) {
                return this.equals(sup);
            }
            if (sup instanceof ByClass) {
                return ((ByClass)sup).getTestClass().isAssignableFrom(1.class$org$biojava$bio$seq$ComponentFeature == null ? (1.class$org$biojava$bio$seq$ComponentFeature = 1.class$("org.biojava.bio.seq.ComponentFeature")) : 1.class$org$biojava$bio$seq$ComponentFeature);
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter feat) {
            if (feat instanceof ByComponentName) {
                return !this.equals(feat);
            }
            if (feat instanceof ByClass) {
                Class featC = ((ByClass)feat).getTestClass();
                return !featC.isAssignableFrom(1.class$org$biojava$bio$seq$ComponentFeature == null ? (1.class$org$biojava$bio$seq$ComponentFeature = 1.class$("org.biojava.bio.seq.ComponentFeature")) : 1.class$org$biojava$bio$seq$ComponentFeature);
            }
            return feat instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "ByComponentName(" + this.cname + ")";
        }
    }

    public static final class ByPairwiseScore
    implements OptimizableFilter {
        private double minScore;
        private double maxScore;
        private double score;
        private int hashCode;

        public ByPairwiseScore(double minScore, double maxScore) {
            if (minScore > maxScore) {
                throw new IllegalArgumentException("Filter minimum score must be less than maximum score");
            }
            this.minScore = minScore;
            this.maxScore = maxScore;
            this.hashCode = (int)((long)this.hashCode + (minScore == 0.0 ? 0L : Double.doubleToLongBits(minScore)));
            this.hashCode = (int)((long)this.hashCode + (maxScore == 0.0 ? 0L : Double.doubleToLongBits(maxScore)));
        }

        public boolean accept(Feature f) {
            if (!(f instanceof SimilarityPairFeature)) {
                return false;
            }
            this.score = ((SimilarityPairFeature)f).getScore();
            return this.score >= this.minScore && this.score <= this.maxScore;
        }

        public double getMinScore() {
            return this.minScore;
        }

        public double getMaxScore() {
            return this.maxScore;
        }

        public boolean equals(Object o) {
            ByPairwiseScore psf;
            return o instanceof ByPairwiseScore && (psf = (ByPairwiseScore)o).getMinScore() == this.minScore && psf.getMaxScore() == this.maxScore;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ByPairwiseScore) {
                ByPairwiseScore psf = (ByPairwiseScore)sup;
                return psf.getMinScore() <= this.minScore && psf.getMaxScore() >= this.maxScore;
            }
            return false;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof AcceptNoneFilter) {
                return true;
            }
            if (filt instanceof ByPairwiseScore) {
                ByPairwiseScore psf = (ByPairwiseScore)filt;
                return psf.getMaxScore() < this.minScore || psf.getMinScore() > this.maxScore;
            }
            return false;
        }

        public String toString() {
            return this.minScore + " >= score <= " + this.maxScore;
        }
    }

    public static final class FrameFilter
    implements OptimizableFilter {
        private FramedFeature.ReadingFrame frame;

        public FrameFilter(FramedFeature.ReadingFrame frame) {
            this.frame = frame;
        }

        public FramedFeature.ReadingFrame getFrame() {
            return this.frame;
        }

        public boolean accept(Feature f) {
            if (f instanceof FramedFeature) {
                FramedFeature ff = (FramedFeature)f;
                return ff.getReadingFrame() == this.frame;
            }
            return false;
        }

        public int hashCode() {
            return this.frame.getFrame() + 99;
        }

        public boolean equals(Object o) {
            return o instanceof FrameFilter && ((FrameFilter)o).getFrame() == this.getFrame();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof FrameFilter && ((FrameFilter)filt).getFrame() == this.getFrame();
        }
    }

    public static class ByDescendant
    implements OptimizableFilter,
    Down {
        private FeatureFilter filter;

        public ByDescendant(FeatureFilter ff) {
            this.filter = ff;
        }

        public FeatureFilter getFilter() {
            return this.filter;
        }

        public boolean accept(Feature f) {
            FeatureHolder fh;
            while ((fh = f.getParent()) instanceof Feature) {
                f = (Feature)fh;
                if (!this.filter.accept(f)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.filter.hashCode() + 186;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByDescendant)) {
                return false;
            }
            ByDescendant ffba = (ByDescendant)o;
            return ffba.getFilter().equals(this.filter);
        }

        public boolean isProperSubset(FeatureFilter ff) {
            FeatureFilter ancFilter = null;
            if (ff instanceof ByDescendant) {
                ancFilter = ((ByDescendant)ff).getFilter();
            }
            if (ancFilter != null) {
                return FilterUtils.areProperSubset(ancFilter, this.filter);
            }
            return false;
        }

        public boolean isDisjoint(FeatureFilter ff) {
            if (ff instanceof IsLeaf) {
                return true;
            }
            if (ff instanceof OnlyDescendants) {
                return FilterUtils.areDisjoint(this.getFilter(), ((OnlyDescendants)ff).getFilter());
            }
            return false;
        }
    }

    public static class ByChild
    implements OptimizableFilter,
    Down {
        private FeatureFilter filter;

        public ByChild(FeatureFilter ff) {
            this.filter = ff;
        }

        public FeatureFilter getFilter() {
            return this.filter;
        }

        public boolean accept(Feature f) {
            Iterator i = f.features();
            while (i.hasNext()) {
                if (!this.filter.accept((Feature)i.next())) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.filter.hashCode() + 173;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByChild)) {
                return false;
            }
            ByChild ffbc = (ByChild)o;
            return ffbc.getFilter().equals(this.filter);
        }

        public boolean isProperSubset(FeatureFilter ff) {
            FeatureFilter descFilter = null;
            if (ff instanceof ByChild) {
                descFilter = ((ByChild)ff).getFilter();
            } else if (ff instanceof ByDescendant) {
                descFilter = ((ByDescendant)ff).getFilter();
            }
            if (descFilter != null) {
                return FilterUtils.areProperSubset(descFilter, this.filter);
            }
            return false;
        }

        public boolean isDisjoint(FeatureFilter ff) {
            if (ff instanceof IsLeaf) {
                return true;
            }
            if (ff instanceof OnlyChildren) {
                return FilterUtils.areDisjoint(this.getFilter(), ((OnlyChildren)ff).getFilter());
            }
            if (ff instanceof OnlyDescendants) {
                return FilterUtils.areDisjoint(this.getFilter(), ((OnlyDescendants)ff).getFilter());
            }
            return false;
        }
    }

    public static class OnlyDescendants
    implements OptimizableFilter,
    ByHierarchy {
        private FeatureFilter filter;

        public OnlyDescendants(FeatureFilter ff) {
            this.filter = ff;
        }

        public FeatureFilter getFilter() {
            return this.filter;
        }

        public boolean accept(Feature f) {
            return f.filter(all).countFeatures() == f.filter(this.filter).countFeatures();
        }

        public int hashCode() {
            return this.filter.hashCode() + 763;
        }

        public boolean equals(Object o) {
            if (!(o instanceof OnlyDescendants)) {
                return false;
            }
            OnlyDescendants ffoc = (OnlyDescendants)o;
            return ffoc.getFilter().equals(this.filter);
        }

        public boolean isProperSubset(FeatureFilter ff) {
            if (ff == all) {
                return true;
            }
            if (ff instanceof OnlyDescendants) {
                return FilterUtils.areProperSubset(this.getFilter(), ((OnlyDescendants)ff).getFilter());
            }
            return false;
        }

        public boolean isDisjoint(FeatureFilter ff) {
            if (ff instanceof ByChild) {
                return FilterUtils.areDisjoint(this.getFilter(), ((ByChild)ff).getFilter());
            }
            if (ff instanceof ByDescendant) {
                return FilterUtils.areDisjoint(this.getFilter(), ((ByDescendant)ff).getFilter());
            }
            return false;
        }
    }

    public static class OnlyChildren
    implements OptimizableFilter,
    ByHierarchy {
        private FeatureFilter filter;

        public OnlyChildren(FeatureFilter ff) {
            this.filter = ff;
        }

        public FeatureFilter getFilter() {
            return this.filter;
        }

        public boolean accept(Feature f) {
            Iterator i = f.features();
            while (i.hasNext()) {
                if (this.filter.accept((Feature)i.next())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.filter.hashCode() + 762;
        }

        public boolean equals(Object o) {
            if (!(o instanceof OnlyChildren)) {
                return false;
            }
            OnlyChildren ffoc = (OnlyChildren)o;
            return ffoc.getFilter().equals(this.filter);
        }

        public boolean isProperSubset(FeatureFilter ff) {
            if (ff == all) {
                return true;
            }
            if (ff instanceof OnlyChildren) {
                return FilterUtils.areProperSubset(this.getFilter(), ((OnlyChildren)ff).getFilter());
            }
            if (ff instanceof OnlyDescendants) {
                return FilterUtils.areProperSubset(this.getFilter(), ((OnlyDescendants)ff).getFilter());
            }
            return false;
        }

        public boolean isDisjoint(FeatureFilter ff) {
            if (ff instanceof ByChild) {
                return FilterUtils.areDisjoint(this.getFilter(), ((ByChild)ff).getFilter());
            }
            return false;
        }

        public String toString() {
            return "OnlyChildren(" + this.filter.toString() + ")";
        }
    }

    public static class ByAncestor
    implements OptimizableFilter,
    Up {
        private FeatureFilter filter;

        public ByAncestor(FeatureFilter ff) {
            this.filter = ff;
        }

        public FeatureFilter getFilter() {
            return this.filter;
        }

        public boolean accept(Feature f) {
            FeatureHolder fh;
            while ((fh = f.getParent()) instanceof Feature) {
                f = (Feature)fh;
                if (!this.filter.accept(f)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.filter.hashCode() + 186;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByAncestor)) {
                return false;
            }
            ByAncestor ffba = (ByAncestor)o;
            return ffba.getFilter().equals(this.filter);
        }

        public boolean isProperSubset(FeatureFilter ff) {
            FeatureFilter ancFilter = null;
            if (ff instanceof ByAncestor) {
                ancFilter = ((ByAncestor)ff).getFilter();
            }
            if (ancFilter != null) {
                return FilterUtils.areProperSubset(ancFilter, this.filter);
            }
            return false;
        }

        public boolean isDisjoint(FeatureFilter ff) {
            if (ff instanceof IsTopLevel) {
                return true;
            }
            if (ff instanceof ByParent) {
                return FilterUtils.areDisjoint(((ByParent)ff).getFilter(), this.getFilter());
            }
            if (ff instanceof ByAncestor) {
                return FilterUtils.areDisjoint(((ByAncestor)ff).getFilter(), this.getFilter());
            }
            FeatureFilter descFilter = FilterUtils.getOnlyDescendantsFilter(this.getFilter());
            if (descFilter != null) {
                return FilterUtils.areDisjoint(descFilter, ff);
            }
            FeatureFilter childFilter = FilterUtils.getOnlyChildrenFilter(this.getFilter());
            if (childFilter != null) {
                if (FilterUtils.areProperSubset(childFilter, leaf)) {
                    return FilterUtils.areDisjoint(childFilter, ff);
                }
                return FilterUtils.areDisjoint(new Or(childFilter, new ByAncestor(childFilter)), ff);
            }
            return false;
        }

        public String toString() {
            return "ByAncestor(" + this.getFilter().toString() + ")";
        }
    }

    public static class ByParent
    implements OptimizableFilter,
    Up {
        private FeatureFilter filter;

        public ByParent(FeatureFilter ff) {
            this.filter = ff;
        }

        public FeatureFilter getFilter() {
            return this.filter;
        }

        public boolean accept(Feature f) {
            FeatureHolder fh = f.getParent();
            if (fh instanceof Feature) {
                return this.filter.accept((Feature)fh);
            }
            return false;
        }

        public int hashCode() {
            return this.filter.hashCode() + 173;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByParent)) {
                return false;
            }
            ByParent ffbp = (ByParent)o;
            return ffbp.getFilter().equals(this.filter);
        }

        public boolean isProperSubset(FeatureFilter ff) {
            FeatureFilter ancFilter = null;
            if (ff instanceof ByParent) {
                ancFilter = ((ByParent)ff).getFilter();
            } else if (ff instanceof ByAncestor) {
                ancFilter = ((ByAncestor)ff).getFilter();
            }
            if (ancFilter != null) {
                return FilterUtils.areProperSubset(ancFilter, this.filter);
            }
            return false;
        }

        public boolean isDisjoint(FeatureFilter ff) {
            if (ff instanceof IsTopLevel) {
                return true;
            }
            if (ff instanceof ByParent) {
                return FilterUtils.areDisjoint(((ByParent)ff).getFilter(), this.getFilter());
            }
            if (ff instanceof ByAncestor) {
                return FilterUtils.areDisjoint(((ByAncestor)ff).getFilter(), this.getFilter());
            }
            FeatureFilter childFilter = FilterUtils.getOnlyChildrenFilter(this.getFilter());
            if (childFilter != null) {
                return FilterUtils.areDisjoint(childFilter, ff);
            }
            return false;
        }
    }

    public static final class HasAnnotation
    extends ByAnnotationType {
        private Object key;

        public HasAnnotation(Object key) {
            this.key = key;
            AnnotationType.Impl type = new AnnotationType.Impl();
            type.setConstraints(key, PropertyConstraint.ANY, CardinalityConstraint.ONE_OR_MORE);
            this.setType(type);
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static final class AnnotationContains
    extends ByAnnotationType {
        private Object key;
        private Object value;

        public AnnotationContains(Object key, Object value) {
            this.key = key;
            this.value = value;
            AnnotationType.Impl type = new AnnotationType.Impl();
            type.setConstraint(key, new CollectionConstraint.Contains(new PropertyConstraint.ExactValue(value), CardinalityConstraint.ONE));
            this.setType(type);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static final class ByAnnotation
    extends ByAnnotationType {
        private Object key;
        private Object value;

        public ByAnnotation(Object key, Object value) {
            this.key = key;
            this.value = value;
            AnnotationType.Impl type = new AnnotationType.Impl();
            type.setConstraints(key, new PropertyConstraint.ExactValue(value), CardinalityConstraint.ONE);
            this.setType(type);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class ByAnnotationType
    implements OptimizableFilter {
        private AnnotationType type;

        protected ByAnnotationType() {
            this(AnnotationType.ANY);
        }

        public ByAnnotationType(AnnotationType type) {
            this.type = type;
        }

        public AnnotationType getType() {
            return this.type;
        }

        protected void setType(AnnotationType type) {
            this.type = type;
        }

        public boolean accept(Feature f) {
            return this.type.instanceOf(f.getAnnotation());
        }

        public boolean equals(Object o) {
            if (o instanceof ByAnnotationType) {
                ByAnnotationType that = (ByAnnotationType)o;
                return this.getType() == that.getType();
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode();
        }

        public boolean isDisjoint(FeatureFilter filter) {
            if (filter instanceof AcceptNoneFilter) {
                return true;
            }
            if (filter instanceof ByAnnotationType) {
                ByAnnotationType that = (ByAnnotationType)filter;
                Set props = that.getType().getProperties();
                Set ourProps = this.getType().getProperties();
                HashSet allProps = new HashSet(props);
                allProps.addAll(ourProps);
                Iterator i = allProps.iterator();
                while (i.hasNext()) {
                    CollectionConstraint thatC;
                    Object prop = i.next();
                    CollectionConstraint thisC = this.getType().getConstraint(prop);
                    if (AnnotationTools.intersection(thisC, thatC = that.getType().getConstraint(prop)) != CollectionConstraint.NONE) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isProperSubset(FeatureFilter filter) {
            if (filter instanceof ByAnnotationType) {
                ByAnnotationType that = (ByAnnotationType)filter;
                Set thisProps = this.getType().getProperties();
                Set thatProps = that.getType().getProperties();
                Iterator i = that.getType().getProperties().iterator();
                while (i.hasNext()) {
                    Object prop = i.next();
                    if (!thisProps.contains(prop)) {
                        return false;
                    }
                    CollectionConstraint thisP = this.getType().getConstraint(prop);
                    CollectionConstraint thatP = that.getType().getConstraint(prop);
                    if (thatP.subConstraintOf(thisP)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "ByAnnotationType {" + this.type + "}";
        }
    }

    public static final class ShadowContainedByLocation
    implements OptimizableFilter {
        private Location loc;

        public Location getLocation() {
            return this.loc;
        }

        public ShadowContainedByLocation(Location loc) {
            if (loc == null) {
                throw new NullPointerException("Loc may not be null");
            }
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            Location floc = f.getLocation();
            if (!floc.isContiguous()) {
                floc = new RangeLocation(floc.getMin(), floc.getMax());
            }
            return this.loc.contains(floc);
        }

        public boolean equals(Object o) {
            return o instanceof ShadowContainedByLocation && ((Object)((ShadowContainedByLocation)o).getLocation()).equals(this.getLocation());
        }

        public int hashCode() {
            return this.getLocation().hashCode() + 88;
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ShadowContainedByLocation) {
                Location supL = ((ShadowContainedByLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            if (sup instanceof ShadowOverlapsLocation) {
                Location supL = ((ShadowOverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof ContainedByLocation) {
                Location filtL = ((ShadowContainedByLocation)filt).getLocation();
                return filtL.getMax() < this.loc.getMin() || filtL.getMin() > this.loc.getMax();
            }
            if (filt instanceof ShadowContainedByLocation) {
                Location loc = ((ShadowContainedByLocation)filt).getLocation();
                return !this.getLocation().overlaps(loc);
            }
            if (filt instanceof OverlapsLocation) {
                Location filtL = ((OverlapsLocation)filt).getLocation();
                return filtL.getMax() < this.loc.getMin() || filtL.getMin() > this.loc.getMax();
            }
            if (filt instanceof ShadowOverlapsLocation) {
                Location filtL = ((ShadowOverlapsLocation)filt).getLocation();
                return !filtL.overlaps(this.getLocation());
            }
            return filt instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "ShadowContainedBy(" + this.loc + ")";
        }
    }

    public static final class ShadowOverlapsLocation
    implements OptimizableFilter {
        private Location loc;

        public Location getLocation() {
            return this.loc;
        }

        public ShadowOverlapsLocation(Location loc) {
            if (loc == null) {
                throw new NullPointerException("Loc may not be null");
            }
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            Location floc = f.getLocation();
            if (!floc.isContiguous()) {
                floc = new RangeLocation(floc.getMin(), floc.getMax());
            }
            return this.loc.overlaps(floc);
        }

        public boolean equals(Object o) {
            return o instanceof ShadowOverlapsLocation && ((Object)((ShadowOverlapsLocation)o).getLocation()).equals(this.getLocation());
        }

        public int hashCode() {
            return this.getLocation().hashCode() + 77;
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ShadowOverlapsLocation) {
                Location supL = ((ShadowOverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof ShadowContainedByLocation) {
                Location loc = ((ShadowContainedByLocation)filt).getLocation();
                return !this.getLocation().overlaps(loc);
            }
            if (filt instanceof ContainedByLocation) {
                Location loc = ((ContainedByLocation)filt).getLocation();
                return loc.getMax() < this.getLocation().getMin() || loc.getMin() > this.getLocation().getMax();
            }
            return filt instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "ShadowOverlaps(" + this.loc + ")";
        }
    }

    public static final class OverlapsLocation
    implements OptimizableFilter {
        private Location loc;

        public Location getLocation() {
            return this.loc;
        }

        public OverlapsLocation(Location loc) {
            if (loc == null) {
                throw new NullPointerException("Loc may not be null");
            }
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            return this.loc.overlaps(f.getLocation());
        }

        public boolean equals(Object o) {
            return o instanceof OverlapsLocation && ((Object)((OverlapsLocation)o).getLocation()).equals(this.getLocation());
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof OverlapsLocation) {
                Location supL = ((OverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            if (sup instanceof ShadowOverlapsLocation) {
                Location supL = ((ShadowOverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof ContainedByLocation) {
                Location loc = ((ContainedByLocation)filt).getLocation();
                return !this.getLocation().overlaps(loc);
            }
            if (filt instanceof ShadowContainedByLocation) {
                Location loc = ((ShadowContainedByLocation)filt).getLocation();
                return this.getLocation().getMax() < loc.getMin() || this.getLocation().getMin() > loc.getMax();
            }
            return filt instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "Overlaps(" + this.loc + ")";
        }
    }

    public static final class ContainedByLocation
    implements OptimizableFilter {
        private Location loc;

        public Location getLocation() {
            return this.loc;
        }

        public ContainedByLocation(Location loc) {
            if (loc == null) {
                throw new NullPointerException("Loc may not be null");
            }
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            return this.loc.contains(f.getLocation());
        }

        public boolean equals(Object o) {
            return o instanceof ContainedByLocation && ((Object)((ContainedByLocation)o).getLocation()).equals(this.getLocation());
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ContainedByLocation) {
                Location supL = ((ContainedByLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            if (sup instanceof OverlapsLocation) {
                Location supL = ((OverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            if (sup instanceof ShadowOverlapsLocation) {
                Location supL = ((ShadowOverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            if (sup instanceof ShadowContainedByLocation) {
                Location supL = ((ShadowContainedByLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof ContainedByLocation) {
                Location loc = ((ContainedByLocation)filt).getLocation();
                return !this.getLocation().overlaps(loc);
            }
            if (filt instanceof OverlapsLocation) {
                Location filtL = ((OverlapsLocation)filt).getLocation();
                return !filtL.overlaps(this.getLocation());
            }
            if (filt instanceof ShadowOverlapsLocation) {
                Location filtL = ((ShadowOverlapsLocation)filt).getLocation();
                return filtL.getMax() < this.loc.getMin() || filtL.getMin() > this.loc.getMax();
            }
            if (filt instanceof ShadowContainedByLocation) {
                Location filtL = ((ShadowContainedByLocation)filt).getLocation();
                return filtL.getMax() < this.loc.getMin() || filtL.getMin() > this.loc.getMax();
            }
            return filt instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "ContainedBy(" + this.loc + ")";
        }
    }

    public static final class BySequenceName
    implements OptimizableFilter {
        private String seqName;

        public BySequenceName(String seqName) {
            this.seqName = seqName;
        }

        public String getSequenceName() {
            return this.seqName;
        }

        public boolean accept(Feature f) {
            return f.getSequence().getName().equals(this.seqName);
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof BySequenceName) {
                return !this.equals(this);
            }
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof BySequenceName && ((BySequenceName)o).getSequenceName().equals(this.seqName);
        }

        public int hashCode() {
            return this.seqName.hashCode();
        }
    }

    public static final class StrandFilter
    implements OptimizableFilter {
        private StrandedFeature.Strand strand;

        public StrandFilter(StrandedFeature.Strand strand) {
            this.strand = strand;
        }

        public StrandedFeature.Strand getStrand() {
            return this.strand;
        }

        public boolean accept(Feature f) {
            if (f instanceof StrandedFeature) {
                StrandedFeature sf = (StrandedFeature)f;
                return sf.getStrand() == this.strand;
            }
            return this.strand == StrandedFeature.UNKNOWN;
        }

        public boolean equals(Object o) {
            return o instanceof StrandFilter && ((StrandFilter)o).getStrand() == this.getStrand();
        }

        public int hashCode() {
            return this.getStrand().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof StrandFilter && ((StrandFilter)filt).getStrand() == this.getStrand();
        }
    }

    public static final class ByClass
    implements OptimizableFilter {
        private Class clazz;

        public ByClass(Class clazz) {
            if (clazz == null) {
                throw new NullPointerException("Clazz may not be null");
            }
            if (!(1.class$org$biojava$bio$seq$Feature == null ? (1.class$org$biojava$bio$seq$Feature = 1.class$("org.biojava.bio.seq.Feature")) : 1.class$org$biojava$bio$seq$Feature).isAssignableFrom(clazz)) {
                throw new ClassCastException("Filters by class must be over Feature classes: " + clazz);
            }
            this.clazz = clazz;
        }

        public boolean accept(Feature f) {
            return this.clazz.isInstance(f);
        }

        public Class getTestClass() {
            return this.clazz;
        }

        public boolean equals(Object o) {
            return o instanceof ByClass && ((ByClass)o).getTestClass() == this.getTestClass();
        }

        public int hashCode() {
            return this.getTestClass().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ByClass) {
                Class supC = ((ByClass)sup).getTestClass();
                return supC.isAssignableFrom(this.getTestClass());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter feat) {
            if (feat instanceof ByClass) {
                Class featC = ((ByClass)feat).getTestClass();
                return !featC.isAssignableFrom(this.getTestClass()) && !this.getTestClass().isAssignableFrom(featC);
            }
            if (feat instanceof ByComponentName) {
                return !this.getTestClass().isAssignableFrom(1.class$org$biojava$bio$seq$ComponentFeature == null ? (1.class$org$biojava$bio$seq$ComponentFeature = 1.class$("org.biojava.bio.seq.ComponentFeature")) : 1.class$org$biojava$bio$seq$ComponentFeature);
            }
            return feat instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "ByClass(" + this.clazz.getName() + ")";
        }
    }

    public static final class BySource
    implements OptimizableFilter {
        private String source;

        public String getSource() {
            return this.source;
        }

        public BySource(String source) {
            if (source == null) {
                throw new NullPointerException("Source may not be null");
            }
            this.source = source;
        }

        public boolean accept(Feature f) {
            return this.source.equals(f.getSource());
        }

        public boolean equals(Object o) {
            return o instanceof BySource && ((BySource)o).getSource().equals(this.getSource());
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup) || sup instanceof AcceptAllFilter;
        }

        public int hashCode() {
            return this.getSource().hashCode();
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof BySource && !this.getSource().equals(((BySource)filt).getSource());
        }

        public String toString() {
            return "BySource(" + this.source + ")";
        }
    }

    public static final class ByType
    implements OptimizableFilter {
        private String type;

        public String getType() {
            return this.type;
        }

        public ByType(String type) {
            if (type == null) {
                throw new NullPointerException("Type may not be null");
            }
            this.type = type;
        }

        public boolean accept(Feature f) {
            return this.type.equals(f.getType());
        }

        public boolean equals(Object o) {
            return o instanceof ByType && ((ByType)o).getType().equals(this.getType());
        }

        public int hashCode() {
            return this.getType().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup) || sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof ByType && !this.getType().equals(((ByType)filt).getType());
        }

        public String toString() {
            return "ByType(" + this.type + ")";
        }
    }

    public static final class Or
    implements FeatureFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }

        public Or(FeatureFilter c1, FeatureFilter c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean accept(Feature f) {
            return this.c1.accept(f) || this.c2.accept(f);
        }

        public boolean equals(Object o) {
            if (o instanceof FeatureFilter) {
                return FilterUtils.areEqual(this, (FeatureFilter)o);
            }
            return false;
        }

        public int hashCode() {
            return this.getChild1().hashCode() ^ this.getChild2().hashCode();
        }

        public String toString() {
            return "Or(" + this.c1 + " , " + this.c2 + ")";
        }
    }

    public static final class And
    implements FeatureFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }

        public And(FeatureFilter c1, FeatureFilter c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean accept(Feature f) {
            return this.c1.accept(f) && this.c2.accept(f);
        }

        public boolean equals(Object o) {
            if (o instanceof FeatureFilter) {
                return FilterUtils.areEqual(this, (FeatureFilter)o);
            }
            return false;
        }

        public int hashCode() {
            return this.getChild1().hashCode() ^ this.getChild2().hashCode();
        }

        public String toString() {
            return "And(" + this.c1 + " , " + this.c2 + ")";
        }
    }

    public static final class Not
    implements FeatureFilter {
        FeatureFilter child;

        public FeatureFilter getChild() {
            return this.child;
        }

        public Not(FeatureFilter child) {
            this.child = child;
        }

        public boolean accept(Feature f) {
            return !this.child.accept(f);
        }

        public boolean equals(Object o) {
            return o instanceof Not && ((Not)o).getChild().equals(this.getChild());
        }

        public int hashCode() {
            return this.getChild().hashCode();
        }

        public String toString() {
            return "Not(" + this.child + ")";
        }
    }
}

