/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SimpleSymbolPropertyTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProteinTools {
    private static final FiniteAlphabet proteinAlpha;
    private static final FiniteAlphabet proteinTAlpha;
    private static final Map propertyTableMap;
    static /* synthetic */ Class class$org$biojava$bio$seq$ProteinTools;

    public static final FiniteAlphabet getAlphabet() {
        return proteinAlpha;
    }

    public static final FiniteAlphabet getTAlphabet() {
        return proteinTAlpha;
    }

    public static final SymbolPropertyTable getSymbolPropertyTable(String name) {
        return (SymbolPropertyTable)propertyTableMap.get(name);
    }

    public static SymbolList createProtein(String theProtein) throws IllegalSymbolException {
        try {
            SymbolTokenization p = ProteinTools.getTAlphabet().getTokenization("token");
            return new SimpleSymbolList(p, theProtein);
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with Protein");
        }
    }

    public static GappedSequence createGappedProteinSequence(String theProtein, String name) throws IllegalSymbolException {
        String theProtein1 = theProtein;
        if (theProtein1.indexOf(45) >= 0) {
            StringBuffer sb = new StringBuffer();
            for (int pos = 0; pos < theProtein1.length(); ++pos) {
                char c = theProtein1.charAt(pos);
                if (c == '-') continue;
                sb.append(c);
            }
            theProtein1 = sb.toString();
        }
        Sequence protein = ProteinTools.createProteinSequence(theProtein1, name);
        SimpleGappedSequence protein1 = new SimpleGappedSequence(protein);
        int pos = theProtein.indexOf(45, 0);
        while (pos != -1) {
            protein1.addGapInView(pos + 1);
            pos = theProtein.indexOf(45, pos + 1);
        }
        return protein1;
    }

    public static Sequence createProteinSequence(String protein, String name) throws IllegalSymbolException {
        try {
            return new SimpleSequenceFactory().createSequence(ProteinTools.createProtein(protein), "", name, new SimpleAnnotation());
        }
        catch (BioException se) {
            throw new BioError(se, "Something has gone badly wrong with ProteinTAlpha");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        propertyTableMap = new HashMap();
        try {
            proteinAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN");
            proteinTAlpha = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN-TERM");
        }
        catch (Exception e) {
            throw new BioError(e, " Could not initialize ProteinTools");
        }
        Document doc = null;
        try {
            InputStream tablesStream = (class$org$biojava$bio$seq$ProteinTools == null ? (class$org$biojava$bio$seq$ProteinTools = ProteinTools.class$("org.biojava.bio.seq.ProteinTools")) : class$org$biojava$bio$seq$ProteinTools).getClassLoader().getResourceAsStream("org/biojava/bio/symbol/ResidueProperties.xml");
            if (tablesStream == null) {
                throw new BioError("Couldn't locate ResidueProperties.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(is);
        }
        catch (MissingResourceException mre) {
            System.err.println(mre.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SimpleSymbolPropertyTable monoMassPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "monoMass");
            SimpleSymbolPropertyTable avgMassPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "avgMass");
            SimpleSymbolPropertyTable pKPropertyTable = new SimpleSymbolPropertyTable(ProteinTools.getAlphabet(), "pK");
            SymbolTokenization tokens = ProteinTools.getAlphabet().getTokenization("token");
            NodeList children = doc.getDocumentElement().getChildNodes();
            block7: for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                Node cnode = children.item(i);
                if (!(cnode instanceof Element) || !(child = (Element)cnode).getNodeName().equals("residue")) continue;
                String token = child.getAttribute("token");
                Symbol s = tokens.parseToken(token);
                NodeList properyNodes = child.getChildNodes();
                for (int j = 0; j < properyNodes.getLength(); ++j) {
                    String value;
                    cnode = properyNodes.item(j);
                    if (!(cnode instanceof Element)) continue;
                    Element el = (Element)cnode;
                    String name = el.getAttribute("name");
                    if (name.equals("monoMass")) {
                        value = el.getAttribute("value");
                        monoMassPropertyTable.setDoubleProperty(s, value);
                        continue;
                    }
                    if (name.equals("avgMass")) {
                        value = el.getAttribute("value");
                        avgMassPropertyTable.setDoubleProperty(s, value);
                        continue;
                    }
                    if (!name.equals("pK")) continue;
                    value = el.getAttribute("value");
                    pKPropertyTable.setDoubleProperty(s, value);
                    continue block7;
                }
            }
            propertyTableMap.put("monoMass", monoMassPropertyTable);
            propertyTableMap.put("avgMass", avgMassPropertyTable);
            propertyTableMap.put("pK", pKPropertyTable);
        }
        catch (Exception e) {
            throw new BioError(e, " Could not initialize ProteinTools");
        }
    }
}

