/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.RemoteFeature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.LazyFilterFeatureHolder;
import org.biojava.bio.seq.impl.SimpleRemoteFeature;
import org.biojava.bio.seq.projection.Projection;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SubSequence
implements Sequence {
    private Sequence parent;
    private SymbolList symbols;
    private String name;
    private String uri;
    private Annotation annotation;
    private int start;
    private int end;
    private transient SubProjectedFeatureHolder features;
    private final FeatureFilter projectff;
    private final boolean recurse;
    private transient ChangeSupport changeSupport;
    private transient ChangeListener seqListener;
    protected transient Annotatable.AnnotationForwarder annotationForwarder;
    static /* synthetic */ Class class$org$biojava$bio$seq$RemoteFeature;

    private void allocChangeSupport() {
        if (this.seqListener == null) {
            this.installSeqListener();
        }
        this.changeSupport = new ChangeSupport();
    }

    private void installSeqListener() {
        this.seqListener = new ChangeListener(){

            public void preChange(ChangeEvent cev) throws ChangeVetoException {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePreChangeEvent(this.makeChainedEvent(cev));
                }
            }

            public void postChange(ChangeEvent cev) {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePostChangeEvent(this.makeChainedEvent(cev));
                }
            }

            private ChangeEvent makeChainedEvent(ChangeEvent cev) {
                return new ChangeEvent(SubSequence.this, FeatureHolder.FEATURES, null, null, cev);
            }
        };
        this.parent.addChangeListener(this.seqListener, FeatureHolder.FEATURES);
    }

    public SubSequence(Sequence seq, int start, int end) {
        this(seq, start, end, null, false);
    }

    public SubSequence(Sequence seq, int start, int end, String name) {
        this(seq, start, end, null, false, name);
    }

    public SubSequence(Sequence seq, int start, int end, FeatureFilter ff, boolean recurse) {
        this(seq, start, end, ff, recurse, seq.getName() + " (" + start + " - " + end + ")");
    }

    public SubSequence(Sequence seq, int start, int end, FeatureFilter ff, boolean recurse, String name) {
        this.parent = seq;
        this.start = start;
        this.end = end;
        this.symbols = seq.subList(start, end);
        this.name = name;
        this.uri = seq.getURN() + "?start=" + start + ";end=" + end;
        this.annotation = seq.getAnnotation();
        FeatureFilter.OverlapsLocation locFilter = new FeatureFilter.OverlapsLocation(new RangeLocation(start, end));
        this.projectff = ff == null ? locFilter : new FeatureFilter.And(ff, locFilter);
        this.recurse = recurse;
    }

    public Symbol symbolAt(int pos) {
        return this.symbols.symbolAt(pos);
    }

    public Alphabet getAlphabet() {
        return this.symbols.getAlphabet();
    }

    public SymbolList subList(int start, int end) {
        return this.symbols.subList(start, end);
    }

    public String seqString() {
        return this.symbols.seqString();
    }

    public String subStr(int start, int end) {
        return this.symbols.subStr(start, end);
    }

    public List toList() {
        return this.symbols.toList();
    }

    public int length() {
        return this.symbols.length();
    }

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit SubSequences");
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatures().filter(ff, recurse);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatures().filter(ff);
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public Feature createFeature(Feature.Template templ) throws BioException, ChangeVetoException {
        return this.createFeatureTranslated(this.parent, templ);
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        this.removeProjectedFeature(this.parent, f);
    }

    public FeatureFilter getSchema() {
        return this.getFeatures().getSchema();
    }

    protected SubProjectedFeatureHolder getFeatures() {
        if (this.features == null) {
            this.features = new SubProjectedFeatureHolder(this);
        }
        return this.features;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.uri;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Sequence getSequence() {
        return this.parent;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Feature createFeatureTranslated(FeatureHolder creatrix, Feature.Template templ) throws BioException, ChangeVetoException {
        Location oldLoc = templ.location;
        templ.location = templ.location.translate(this.start - 1);
        try {
            Feature feature = this.getFeatures().projectFeature(creatrix.createFeature(templ));
            return feature;
        }
        finally {
            templ.location = oldLoc;
        }
    }

    private void removeProjectedFeature(FeatureHolder parentFH, Feature f) throws ChangeVetoException {
        if (!(f instanceof Projection)) {
            throw new ChangeVetoException("Can't remove feature -- doesn't appear to be an appropriate projection");
        }
        parentFH.removeFeature(((Projection)((Object)f)).getViewedFeature());
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.allocChangeSupport();
        }
        if (this.annotationForwarder == null && ct == Annotatable.ANNOTATION) {
            this.annotationForwarder = new Annotatable.AnnotationForwarder(this, this.changeSupport);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        this.changeSupport.addChangeListener(cl, ct);
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public boolean isUnchanging(ChangeType ct) {
        return this.parent.isUnchanging(ct);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SSRemoteFeature
    extends SimpleRemoteFeature
    implements RemoteFeature {
        private FeatureHolder childFeatures;

        private SSRemoteFeature(Sequence seq, SubProjectedFeatureHolder spfh, FeatureHolder parent, RemoteFeature.Template templ, Feature f) {
            super(seq, parent, templ);
            this.childFeatures = spfh.makeProjectionSet(f);
        }

        public int countFeatures() {
            return this.getFeatures().countFeatures();
        }

        public Iterator features() {
            return this.getFeatures().features();
        }

        public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
            return this.getFeatures().filter(ff, recurse);
        }

        public boolean containsFeature(Feature f) {
            return this.getFeatures().containsFeature(f);
        }

        public Feature createFeature(Feature.Template templ) throws BioException, ChangeVetoException {
            throw new ChangeVetoException("Can't create features on SubSequence");
        }

        public void removeFeature(Feature f) throws ChangeVetoException {
            throw new ChangeVetoException("Can't remove features from SubSequence");
        }

        protected FeatureHolder getFeatures() {
            return this.childFeatures;
        }
    }

    private static class SubProjectedFeatureHolder
    extends ProjectedFeatureHolder {
        private Location parentLocation;
        private SubSequence ssthis;
        private static final FeatureFilter remoteFilter = new FeatureFilter.ByClass(class$org$biojava$bio$seq$RemoteFeature == null ? (class$org$biojava$bio$seq$RemoteFeature = SubSequence.class$("org.biojava.bio.seq.RemoteFeature")) : class$org$biojava$bio$seq$RemoteFeature);

        protected FeatureFilter untransformFilter(FeatureFilter ff) {
            return FilterUtils.transformFilter(super.untransformFilter(new FeatureFilter.And(ff, new FeatureFilter.OverlapsLocation(new RangeLocation(1, this.ssthis.length())))), new FilterUtils.FilterTransformer(this){
                private final /* synthetic */ SubProjectedFeatureHolder this$0;
                {
                    this.this$0 = this$0;
                }

                public FeatureFilter transform(FeatureFilter ff) {
                    if (ff.equals(SubProjectedFeatureHolder.access$100())) {
                        return new FeatureFilter.Not(new FeatureFilter.ContainedByLocation(SubProjectedFeatureHolder.access$200(this.this$0)));
                    }
                    return ff;
                }
            });
        }

        SubProjectedFeatureHolder(SubSequence ssthis) {
            super(ssthis.getSequence(), ssthis, 1 - ssthis.getStart(), false);
            this.ssthis = ssthis;
            this.parentLocation = new RangeLocation(ssthis.getStart(), ssthis.getEnd());
        }

        public Feature projectFeature(Feature f) {
            if (this.parentLocation.contains(f.getLocation())) {
                return super.projectFeature(f);
            }
            RemoteFeature.Template rft = new RemoteFeature.Template();
            rft.type = f.getType();
            rft.source = f.getSource();
            rft.annotation = f.getAnnotation();
            rft.location = LocationTools.intersection(f.getLocation().translate(1 - this.ssthis.getStart()), new RangeLocation(1, this.ssthis.getEnd() - this.ssthis.getStart() + 1));
            rft.strand = f instanceof StrandedFeature ? ((StrandedFeature)f).getStrand() : StrandedFeature.UNKNOWN;
            rft.resolver = new RemoteFeature.Resolver(this, f){
                private final /* synthetic */ Feature val$f;
                private final /* synthetic */ SubProjectedFeatureHolder this$0;
                {
                    this.this$0 = this$0;
                    this.val$f = val$f;
                }

                public Feature resolve(RemoteFeature rFeat) {
                    return this.val$f;
                }
            };
            rft.regions = Collections.nCopies(1, new RemoteFeature.Region(f.getLocation(), f.getSequence().getName(), true));
            SubSequence subSequence = this.ssthis;
            subSequence.getClass();
            return subSequence.new SSRemoteFeature(this.ssthis, this, this.getParent(f), rft, f);
        }

        public FeatureHolder makeProjectionSet(FeatureHolder fh) {
            LazyFilterFeatureHolder toProject = new LazyFilterFeatureHolder(fh, new FeatureFilter.OverlapsLocation(new RangeLocation(this.ssthis.getStart(), this.ssthis.getEnd())));
            return super.makeProjectionSet(toProject);
        }

        public Feature createFeature(Feature f, Feature.Template templ) throws BioException, ChangeVetoException {
            return this.ssthis.createFeatureTranslated(f, templ);
        }

        public void removeFeature(Feature f, Feature victim) throws ChangeVetoException {
            this.ssthis.removeProjectedFeature(f, victim);
        }

        static /* synthetic */ FeatureFilter access$100() {
            return remoteFilter;
        }

        static /* synthetic */ Location access$200(SubProjectedFeatureHolder x0) {
            return x0.parentLocation;
        }
    }
}

