/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.db.emblcd.DivisionLkpReader;
import org.biojava.bio.seq.db.emblcd.EmblCDROMIndexReader;
import org.biojava.bio.seq.db.emblcd.EmblCDROMRandomAccess;
import org.biojava.bio.seq.db.emblcd.EntryNamIdxReader;
import org.biojava.bio.seq.db.emblcd.EntryNamRandomAccess;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;

public class EmblCDROMIndexStore
implements IndexStore {
    private File divisionLkp;
    private File entryNamIdx;
    private File pathPrefix;
    private SequenceFormat format;
    private SequenceBuilderFactory factory;
    private SymbolTokenization parser;
    private Map seqFiles;
    private Set fileSet;
    private Set seqIds;
    private String name;
    private int divRecordLength;
    private long divRecordCount;
    private int entryRecordLength;
    private long entryRecordCount;
    private EmblCDROMRandomAccess entryRandomAccess;

    public EmblCDROMIndexStore(File divisionLkp, File entryNamIdx, SequenceFormat format, SequenceBuilderFactory factory, SymbolTokenization parser) throws IOException {
        this(new File(""), divisionLkp, entryNamIdx, format, factory, parser);
    }

    public EmblCDROMIndexStore(File pathPrefix, File divisionLkp, File entryNamIdx, SequenceFormat format, SequenceBuilderFactory factory, SymbolTokenization parser) throws IOException {
        this.divisionLkp = divisionLkp;
        this.entryNamIdx = entryNamIdx;
        this.format = format;
        this.factory = factory;
        this.parser = parser;
        this.pathPrefix = pathPrefix;
        this.initialise();
    }

    public File getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(File pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getName() {
        return this.name;
    }

    public void store(Index index) throws IllegalIDException, BioException {
        throw new BioException("Failed to add Index: store is read-only. To add sequences use the dbi programs supplied in EMBOSS");
    }

    public void commit() throws BioException {
        throw new BioException("Failed to commit: store is read-only. To add sequences use the dbi programs supplied in EMBOSS");
    }

    public void rollback() {
    }

    public Index fetch(String id) throws IllegalIDException, BioException {
        SimpleIndex index = null;
        try {
            Object[] enRecord = this.entryRandomAccess.findRecord(id);
            if (enRecord.length == 0) {
                throw new IllegalIDException("Failed to find ID: " + id);
            }
            index = new SimpleIndex(new File(this.pathPrefix, (String)this.seqFiles.get((Integer)enRecord[3])), (Long)enRecord[1], this.entryRecordLength, id);
        }
        catch (IOException ioe) {
            throw new BioException("Failed to retrieve index for ID: " + id);
        }
        return index;
    }

    public Set getIDs() {
        if (this.seqIds == null) {
            this.seqIds = new HashSet((int)this.entryRecordCount);
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(new FileInputStream(this.entryNamIdx));
                EntryNamIdxReader ent = new EntryNamIdxReader(bis);
                for (long i = 0L; i < this.entryRecordCount; ++i) {
                    Object[] enRecord = ((EmblCDROMIndexReader)ent).readRecord();
                    this.seqIds.add((String)enRecord[0]);
                }
                bis.close();
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Failed to find file " + this.entryNamIdx.getName());
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                try {
                    bis.close();
                }
                catch (IOException ioe2) {
                    System.err.println("Failed to close input stream from file " + this.entryNamIdx.getName());
                }
                System.err.println("Failed to read file " + this.entryNamIdx.getName());
                ioe.printStackTrace();
            }
        }
        return Collections.unmodifiableSet(this.seqIds);
    }

    public Set getFiles() {
        return Collections.unmodifiableSet(this.fileSet);
    }

    public SequenceFormat getFormat() {
        return this.format;
    }

    public SequenceBuilderFactory getSBFactory() {
        return this.factory;
    }

    public SymbolTokenization getSymbolParser() {
        return this.parser;
    }

    public void close() throws IOException {
        this.entryRandomAccess.close();
    }

    private void initialise() throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(this.divisionLkp));
            DivisionLkpReader div = new DivisionLkpReader(bis);
            this.divRecordLength = div.readRecordLength();
            this.divRecordCount = div.readRecordCount();
            this.name = div.readDBName();
            this.seqFiles = new HashMap((int)this.divRecordCount);
            long i = this.divRecordCount;
            while (--i >= 0L) {
                Object[] divRecord = ((EmblCDROMIndexReader)div).readRecord();
                Integer fileNumber = (Integer)divRecord[0];
                String fileName = (String)divRecord[1];
                this.seqFiles.put(fileNumber, fileName);
            }
            this.fileSet = new HashSet((int)this.divRecordCount);
            this.fileSet.addAll(this.seqFiles.values());
            bis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Failed to find file " + this.divisionLkp.getName());
            throw fnfe;
        }
        catch (IOException ioe) {
            try {
                bis.close();
            }
            catch (IOException ioe2) {
                System.err.println("Failed to close input stream from file " + this.divisionLkp.getName());
            }
            System.err.println("Failed to read full set of sequence IDs file " + this.divisionLkp.getName());
            throw ioe;
        }
        try {
            bis = new BufferedInputStream(new FileInputStream(this.entryNamIdx));
            EntryNamIdxReader ent = new EntryNamIdxReader(bis);
            this.entryRecordLength = ent.readRecordLength();
            this.entryRecordCount = ent.readRecordCount();
            bis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Failed to find file " + this.entryNamIdx.getName());
            throw fnfe;
        }
        catch (IOException ioe) {
            try {
                bis.close();
            }
            catch (IOException ioe2) {
                System.err.println("Failed to close input stream from file " + this.entryNamIdx.getName());
            }
            System.err.println("Failed to read file " + this.entryNamIdx.getName());
            throw ioe;
        }
        try {
            this.entryRandomAccess = new EntryNamRandomAccess(this.entryNamIdx, 300, this.entryRecordLength, this.entryRecordCount);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Failed to find file " + this.entryNamIdx.getName());
            throw fnfe;
        }
        catch (IOException ioe) {
            try {
                bis.close();
            }
            catch (IOException ioe2) {
                System.err.println("Failed to close random access file " + this.entryNamIdx.getName());
            }
            System.err.println("Failed to read random access file " + this.entryNamIdx.getName());
            throw ioe;
        }
    }
}

