/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.FetchURL;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;

public class GenpeptSequenceDB {
    private static SequenceFormat format;
    private static String DBName;
    private boolean IOExceptionFound = false;
    private boolean ExceptionFound = false;

    protected SequenceFormat getSequenceFormat() {
        return format;
    }

    protected Alphabet getAlphabet() {
        return ProteinTools.getTAlphabet();
    }

    protected URL getAddress(String id) throws MalformedURLException {
        String defaultReturnFormat = "text";
        FetchURL seqURL = new FetchURL(DBName, defaultReturnFormat);
        String baseurl = seqURL.getbaseURL();
        String db = seqURL.getDB();
        String returnFormat = seqURL.getReturnFormat();
        String url = baseurl + db + "&id=" + id;
        return new URL(url);
    }

    protected URL getAddress(String id, String format) throws MalformedURLException {
        FetchURL seqURL = new FetchURL(DBName, format);
        String baseurl = seqURL.getbaseURL();
        if (!baseurl.equalsIgnoreCase("")) {
            baseurl = seqURL.getbaseURL();
        }
        String db = seqURL.getDB();
        String url = baseurl + db + "&id=" + id;
        return new URL(url);
    }

    public String getName() {
        return DBName;
    }

    public Sequence getSequence(String id) throws BioException {
        try {
            this.IOExceptionFound = false;
            this.ExceptionFound = false;
            URL queryURL = this.getAddress(id);
            SequenceFormat sFormat = this.getSequenceFormat();
            SimpleSequenceBuilder sbuilder = new SimpleSequenceBuilder();
            GenbankProcessor.Factory sFact = new GenbankProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            Alphabet alpha = this.getAlphabet();
            SymbolTokenization rParser = alpha.getTokenization("token");
            System.err.println("got data from " + queryURL);
            DataInputStream in = new DataInputStream(queryURL.openStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            SequenceIterator seqI = SeqIOTools.readGenpept(reader);
            return seqI.nextSequence();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            this.IOExceptionFound = true;
            this.ExceptionFound = true;
            return null;
        }
    }

    public boolean checkIOException() {
        return this.IOExceptionFound;
    }

    public boolean checkException() {
        return this.ExceptionFound;
    }

    static {
        DBName = "Genpept";
        GenbankFormat genbankFormat = new GenbankFormat();
    }
}

