/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biofetch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

public class BioFetchSequenceDB
extends Unchangeable
implements SequenceDBLite {
    private final String location;
    private final String dbName;

    public BioFetchSequenceDB(String location, String dbName) {
        this.location = location;
        this.dbName = dbName;
    }

    public String getName() {
        return this.dbName;
    }

    public void addSequence(Sequence seq) throws ChangeVetoException {
        throw new ChangeVetoException("Failed to add sequence. Sequences may not be added to a biofetch database");
    }

    public void removeSequence(String id) throws ChangeVetoException {
        throw new ChangeVetoException("Failed to add sequence. Sequences may not be removed from a biofetch database");
    }

    public Sequence getSequence(String id) throws BioException, IllegalIDException {
        String format = "";
        if (this.dbName.equals("embl")) {
            format = "embl";
        }
        if (this.dbName.equals("genbank")) {
            format = "genbank";
        } else if (this.dbName.equals("swiss")) {
            format = "swissprot";
        } else if (this.dbName.equals("refseq")) {
            throw new BioException("Sequence database " + this.dbName + " is not supported");
        }
        StringBuffer uri = new StringBuffer(this.location);
        uri.append('?');
        uri.append("style=raw;");
        uri.append("format=");
        uri.append(format);
        uri.append(";db=");
        uri.append(this.dbName);
        uri.append(";id=");
        uri.append(id);
        try {
            StringTokenizer toke;
            String first;
            HttpURLConnection huc = (HttpURLConnection)new URL(uri.substring(0)).openConnection();
            huc.connect();
            BufferedReader data = new BufferedReader(new InputStreamReader(huc.getInputStream()));
            data.mark(1000);
            String firstLine = data.readLine();
            if (firstLine.startsWith("Content-")) {
                data.readLine();
                firstLine = data.readLine();
            }
            if ("ERROR".equals(first = (toke = new StringTokenizer(firstLine)).nextToken())) {
                int errorCode = Integer.parseInt(toke.nextToken());
                if (errorCode == 4) {
                    throw new IllegalIDException("No such ID " + id + " in database " + this.getName());
                }
                throw new BioException("Error fetching from BioFetch:" + firstLine);
            }
            data.reset();
            SequenceIterator si = SeqIOTools.readEmbl(data);
            if (this.dbName.equals("embl")) {
                si = SeqIOTools.readEmbl(data);
            } else if (this.dbName.equals("genbank")) {
                si = SeqIOTools.readGenbank(data);
            } else if (this.dbName.equals("swiss")) {
                si = SeqIOTools.readSwissprot(data);
            }
            return si.nextSequence();
        }
        catch (IOException ex) {
            throw new BioException(ex, "Error reading data from BioFetch");
        }
    }
}

