/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotatable;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLChangeHub {
    private final Map entryAnnotationListeners = new HashMap();
    private final Map featureAnnotationListeners = new HashMap();
    private final Map featureListeners = new HashMap();
    private final Map entryListeners = new HashMap();
    private final List databaseListeners = new ArrayList();
    private final ReferenceQueue queue = new ReferenceQueue();
    private final BioSQLSequenceDB seqDB;

    BioSQLChangeHub(BioSQLSequenceDB seqDB) {
        this.seqDB = seqDB;
    }

    private void diddleQueue() {
        Reference ref;
        block0: while ((ref = this.queue.poll()) != null) {
            ListenerMemento lm;
            Iterator i;
            List listenerList;
            if (ref instanceof FeatureListenerReference) {
                listenerList = (List)this.featureListeners.get(((FeatureListenerReference)ref).getKey());
                if (listenerList == null) continue;
                i = listenerList.iterator();
                while (i.hasNext()) {
                    lm = (ListenerMemento)i.next();
                    if (lm.listener != ref) continue;
                    i.remove();
                    continue block0;
                }
                continue;
            }
            if (ref instanceof EntryListenerReference) {
                listenerList = (List)this.entryListeners.get(((EntryListenerReference)ref).getKey());
                if (listenerList == null) continue;
                i = listenerList.iterator();
                while (i.hasNext()) {
                    lm = (ListenerMemento)i.next();
                    if (lm.listener != ref) continue;
                    i.remove();
                    continue block0;
                }
                continue;
            }
            if (ref instanceof FeatureAnnotationListenerReference) {
                listenerList = (List)this.featureAnnotationListeners.get(((FeatureAnnotationListenerReference)ref).getKey());
                if (listenerList == null) continue;
                i = listenerList.iterator();
                while (i.hasNext()) {
                    lm = (ListenerMemento)i.next();
                    if (lm.listener != ref) continue;
                    i.remove();
                    continue block0;
                }
                continue;
            }
            if (ref instanceof EntryAnnotationListenerReference) {
                listenerList = (List)this.entryAnnotationListeners.get(((EntryAnnotationListenerReference)ref).getKey());
                if (listenerList == null) continue;
                i = listenerList.iterator();
                while (i.hasNext()) {
                    lm = (ListenerMemento)i.next();
                    if (lm.listener != ref) continue;
                    i.remove();
                    continue block0;
                }
                continue;
            }
            Iterator i2 = this.databaseListeners.iterator();
            while (i2.hasNext()) {
                ListenerMemento lm2 = (ListenerMemento)i2.next();
                if (lm2.listener != ref) continue;
                i2.remove();
                continue block0;
            }
        }
    }

    public synchronized void addEntryAnnotationListener(int bioentry_id, ChangeListener listener, ChangeType ct) {
        this.diddleQueue();
        Integer id = new Integer(bioentry_id);
        ArrayList<ListenerMemento> listenerList = (ArrayList<ListenerMemento>)this.entryAnnotationListeners.get(id);
        if (listenerList == null) {
            listenerList = new ArrayList<ListenerMemento>();
            this.featureListeners.put(id, listenerList);
        }
        listenerList.add(new ListenerMemento(ct, new EntryAnnotationListenerReference(id, listener, this.queue)));
    }

    public synchronized void removeEntryAnnotationListener(int bioentry_id, ChangeListener listener, ChangeType ct) {
        Integer id = new Integer(bioentry_id);
        List listenerList = (List)this.entryAnnotationListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ListenerMemento lm = (ListenerMemento)i.next();
                if (ct != lm.type || !listener.equals(lm.listener.get())) continue;
                lm.listener.clear();
                i.remove();
                return;
            }
        }
    }

    public void fireEntryAnnotationPreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLSequenceAnnotation source = (BioSQLSequenceAnnotation)cev.getSource();
        Integer id = new Integer(source.getBioentryID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.entryAnnotationListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.preChange(cev);
            }
        }
        try {
            Sequence seq = this.seqDB.getSequence(null, id);
            ChangeEvent pcev = new ChangeEvent(seq, Annotatable.ANNOTATION, null, null, cev);
            this.fireEntryPreChange(pcev);
        }
        catch (BioException ex) {
            throw new BioRuntimeException("Sequence has gone missing");
        }
    }

    public void fireEntryAnnotationPostChange(ChangeEvent cev) {
        BioSQLSequenceAnnotation source = (BioSQLSequenceAnnotation)cev.getSource();
        Integer id = new Integer(source.getBioentryID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.entryAnnotationListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.postChange(cev);
            }
        }
        try {
            Sequence seq = this.seqDB.getSequence(null, id);
            ChangeEvent pcev = new ChangeEvent(seq, Annotatable.ANNOTATION, null, null, cev);
            this.fireEntryPostChange(pcev);
        }
        catch (BioException ex) {
            throw new BioRuntimeException("Sequence has gone missing");
        }
    }

    public synchronized void addFeatureAnnotationListener(int feature_id, ChangeListener listener, ChangeType ct) {
        this.diddleQueue();
        Integer id = new Integer(feature_id);
        ArrayList<ListenerMemento> listenerList = (ArrayList<ListenerMemento>)this.featureAnnotationListeners.get(id);
        if (listenerList == null) {
            listenerList = new ArrayList<ListenerMemento>();
            this.featureListeners.put(id, listenerList);
        }
        listenerList.add(new ListenerMemento(ct, new FeatureAnnotationListenerReference(id, listener, this.queue)));
    }

    public synchronized void removeFeatureAnnotationListener(int feature_id, ChangeListener listener, ChangeType ct) {
        Integer id = new Integer(feature_id);
        List listenerList = (List)this.featureAnnotationListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ListenerMemento lm = (ListenerMemento)i.next();
                if (ct != lm.type || !listener.equals(lm.listener.get())) continue;
                lm.listener.clear();
                i.remove();
                return;
            }
        }
    }

    public void fireFeatureAnnotationPreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLFeatureAnnotation source = (BioSQLFeatureAnnotation)cev.getSource();
        Integer id = new Integer(source.getFeatureID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.featureAnnotationListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.preChange(cev);
            }
        }
        BioSQLFeature parent = this.seqDB.getFeatureByID(id);
        ChangeEvent pcev = new ChangeEvent(parent, Annotatable.ANNOTATION, null, null, cev);
        this.fireFeaturePreChange(pcev);
    }

    public void fireFeatureAnnotationPostChange(ChangeEvent cev) {
        BioSQLFeatureAnnotation source = (BioSQLFeatureAnnotation)cev.getSource();
        Integer id = new Integer(source.getFeatureID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.featureAnnotationListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.postChange(cev);
            }
        }
        BioSQLFeature parent = this.seqDB.getFeatureByID(id);
        ChangeEvent pcev = new ChangeEvent(parent, Annotatable.ANNOTATION, null, null, cev);
        this.fireFeaturePostChange(pcev);
    }

    public synchronized void addFeatureListener(int feature_id, ChangeListener listener, ChangeType ct) {
        this.diddleQueue();
        Integer id = new Integer(feature_id);
        ArrayList<ListenerMemento> listenerList = (ArrayList<ListenerMemento>)this.featureListeners.get(id);
        if (listenerList == null) {
            listenerList = new ArrayList<ListenerMemento>();
            this.featureListeners.put(id, listenerList);
        }
        listenerList.add(new ListenerMemento(ct, new FeatureListenerReference(id, listener, this.queue)));
    }

    public synchronized void removeFeatureListener(int feature_id, ChangeListener listener, ChangeType ct) {
        Integer id = new Integer(feature_id);
        List listenerList = (List)this.featureListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ListenerMemento lm = (ListenerMemento)i.next();
                if (ct != lm.type || !listener.equals(lm.listener.get())) continue;
                lm.listener.clear();
                i.remove();
                return;
            }
        }
    }

    public void fireFeaturePreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLFeature source = (BioSQLFeature)cev.getSource();
        Integer id = new Integer(source._getInternalID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.featureListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.preChange(cev);
            }
        }
        FeatureHolder parent = source.getParent();
        ChangeEvent pcev = new ChangeEvent(parent, FeatureHolder.FEATURES, null, null, cev);
        if (parent instanceof Feature) {
            this.fireFeaturePreChange(pcev);
        } else {
            this.fireEntryPreChange(pcev);
        }
    }

    public void fireFeaturePostChange(ChangeEvent cev) {
        BioSQLFeature source = (BioSQLFeature)cev.getSource();
        Integer id = new Integer(source._getInternalID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.featureListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.postChange(cev);
            }
        }
        FeatureHolder parent = source.getParent();
        ChangeEvent pcev = new ChangeEvent(parent, FeatureHolder.FEATURES, null, null, cev);
        if (parent instanceof Feature) {
            this.fireFeaturePostChange(pcev);
        } else {
            this.fireEntryPostChange(pcev);
        }
    }

    public synchronized void addEntryListener(int entry_id, ChangeListener listener, ChangeType ct) {
        this.diddleQueue();
        Integer id = new Integer(entry_id);
        ArrayList<ListenerMemento> listenerList = (ArrayList<ListenerMemento>)this.entryListeners.get(id);
        if (listenerList == null) {
            listenerList = new ArrayList<ListenerMemento>();
            this.entryListeners.put(id, listenerList);
        }
        listenerList.add(new ListenerMemento(ct, new EntryListenerReference(id, listener, this.queue)));
    }

    public synchronized void removeEntryListener(int entry_id, ChangeListener listener, ChangeType ct) {
        Integer id = new Integer(entry_id);
        List listenerList = (List)this.entryListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ListenerMemento lm = (ListenerMemento)i.next();
                if (ct != lm.type || !listener.equals(lm.listener.get())) continue;
                lm.listener.clear();
                i.remove();
                return;
            }
        }
    }

    public void fireEntryPreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLSequenceI source = (BioSQLSequenceI)cev.getSource();
        Integer id = new Integer(source.getBioEntryID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.entryListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.preChange(cev);
            }
        }
        ChangeEvent pcev = new ChangeEvent(this.seqDB, SequenceDBLite.SEQUENCES, null, null, cev);
        this.fireDatabasePreChange(pcev);
    }

    public void fireEntryPostChange(ChangeEvent cev) {
        BioSQLSequenceI source = (BioSQLSequenceI)cev.getSource();
        Integer id = new Integer(source.getBioEntryID());
        ChangeType ct = cev.getType();
        List listenerList = (List)this.entryListeners.get(id);
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.postChange(cev);
            }
        }
        ChangeEvent pcev = new ChangeEvent(this.seqDB, SequenceDBLite.SEQUENCES, null, null, cev);
        this.fireDatabasePostChange(pcev);
    }

    public synchronized void addDatabaseListener(ChangeListener listener, ChangeType ct) {
        this.diddleQueue();
        this.databaseListeners.add(new ListenerMemento(ct, new WeakReference<ChangeListener>(listener, this.queue)));
    }

    public synchronized void removeDatabaseListener(ChangeListener listener, ChangeType ct) {
        Iterator i = this.databaseListeners.iterator();
        while (i.hasNext()) {
            ListenerMemento lm = (ListenerMemento)i.next();
            if (ct != lm.type || !listener.equals(lm.listener.get())) continue;
            lm.listener.clear();
            i.remove();
            return;
        }
    }

    public void fireDatabasePreChange(ChangeEvent cev) throws ChangeVetoException {
        ChangeType ct = cev.getType();
        List listenerList = this.databaseListeners;
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.preChange(cev);
            }
        }
    }

    public void fireDatabasePostChange(ChangeEvent cev) {
        ChangeType ct = cev.getType();
        List listenerList = this.databaseListeners;
        if (listenerList != null) {
            Iterator i = listenerList.iterator();
            while (i.hasNext()) {
                ChangeListener cl;
                ListenerMemento lm = (ListenerMemento)i.next();
                if (!ct.isMatchingType(lm.type) || (cl = (ChangeListener)lm.listener.get()) == null) continue;
                cl.postChange(cev);
            }
        }
    }

    private class ListenerMemento {
        public final ChangeType type;
        public final Reference listener;

        public ListenerMemento(ChangeType type, Reference listener) {
            this.type = type;
            this.listener = listener;
        }
    }

    private class EntryListenerReference
    extends WeakReference {
        private Object key;

        public EntryListenerReference(Object key, Object ref) {
            super(ref);
            this.key = key;
        }

        public EntryListenerReference(Object key, Object ref, ReferenceQueue queue) {
            super(ref, queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    private class FeatureListenerReference
    extends WeakReference {
        private Object key;

        public FeatureListenerReference(Object key, Object ref) {
            super(ref);
            this.key = key;
        }

        public FeatureListenerReference(Object key, Object ref, ReferenceQueue queue) {
            super(ref, queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    private class EntryAnnotationListenerReference
    extends WeakReference {
        private Object key;

        public EntryAnnotationListenerReference(Object key, Object ref) {
            super(ref);
            this.key = key;
        }

        public EntryAnnotationListenerReference(Object key, Object ref, ReferenceQueue queue) {
            super(ref, queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    private class FeatureAnnotationListenerReference
    extends WeakReference {
        private Object key;

        public FeatureAnnotationListenerReference(Object key, Object ref) {
            super(ref);
            this.key = key;
        }

        public FeatureAnnotationListenerReference(Object key, Object ref, ReferenceQueue queue) {
            super(ref, queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

