/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

class BioSQLComponentFeature
extends Unchangeable
implements ComponentFeature {
    private BioSQLSequenceDB seqDB;
    private Sequence parent;
    private Sequence componentSequence = null;
    private SymbolList contigedSymbols = null;
    private Location location;
    private Location componentLocation;
    private String componentName;
    private FeatureHolder projectedFeatures;
    private StrandedFeature.Strand strand;
    private int assemblyFragmentID;
    private String type;
    private String source;
    private boolean triedResolve = false;
    static /* synthetic */ Class class$org$biojava$bio$seq$ComponentFeature;

    BioSQLComponentFeature(BioSQLSequenceDB seqDB, Sequence parent, ComponentFeature.Template temp, int assemblyFragmentID) {
        this.seqDB = seqDB;
        this.parent = parent;
        this.location = temp.location;
        this.componentLocation = temp.componentLocation;
        this.componentName = temp.componentSequenceName;
        this.type = temp.type;
        this.source = temp.source;
        this.strand = temp.strand;
    }

    public Sequence getSequence() {
        return this.parent;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public SymbolList getSymbols() {
        if (this.contigedSymbols == null) {
            try {
                this.contigedSymbols = this.getComponentSequence().subList(this.componentLocation.getMin(), this.componentLocation.getMax());
            }
            catch (Exception ex) {
                throw new BioError(ex);
            }
        }
        return this.contigedSymbols;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location loc) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, Feature.LOCATION, loc, this.location), "Can't change location as it is immutable");
    }

    public Location getComponentLocation() {
        return this.componentLocation;
    }

    public boolean isComponentResolvable() {
        return this.getComponentSequence() != null;
    }

    public String getComponentSequenceName() {
        return this.componentName;
    }

    public Sequence getComponentSequence() {
        if (!this.triedResolve) {
            try {
                this.componentSequence = this.seqDB.getSequence(this.componentName);
            }
            catch (IllegalIDException ex) {
            }
            catch (BioException ex) {
                throw new BioRuntimeException(ex, "Error fetching component sequence");
            }
        }
        return this.componentSequence;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, Feature.TYPE, type, this.type), "Can't change type as it is immutable");
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, Feature.TYPE, source, this.source), "Can't change source as it is immutable");
    }

    public Feature.Template makeTemplate() {
        throw new BioError("FIXME");
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public int countFeatures() {
        return this.getProjectedFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getProjectedFeatures().containsFeature(f);
    }

    public Feature createFeature(Feature.Template temp) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on components -- edit the underlying sequence instead");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from components -- edit the underlying sequence instead");
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (FilterUtils.areDisjoint(ff, new FeatureFilter.ByParent(new FeatureFilter.ByClass(class$org$biojava$bio$seq$ComponentFeature == null ? (class$org$biojava$bio$seq$ComponentFeature = BioSQLComponentFeature.class$("org.biojava.bio.seq.ComponentFeature")) : class$org$biojava$bio$seq$ComponentFeature)))) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        FeatureFilter.And childFilter = new FeatureFilter.And(new FeatureFilter.ByParent(new FeatureFilter.ByClass(class$org$biojava$bio$seq$ComponentFeature == null ? (class$org$biojava$bio$seq$ComponentFeature = BioSQLComponentFeature.class$("org.biojava.bio.seq.ComponentFeature")) : class$org$biojava$bio$seq$ComponentFeature)), new FeatureFilter.Not(FeatureFilter.top_level));
        if (FilterUtils.areDisjoint(ff, childFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff);
    }

    public FeatureFilter getSchema() {
        return new FeatureFilter.ByParent(new FeatureFilter.ByFeature(this));
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    /*
     * WARNING - void declaration
     */
    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            void var2_2;
            void var1_1;
            boolean flip;
            int translation;
            if (this.strand == StrandedFeature.NEGATIVE) {
                translation = this.location.getMax() + this.componentLocation.getMin();
                flip = true;
            } else if (this.strand == StrandedFeature.POSITIVE) {
                translation = this.location.getMin() - this.componentLocation.getMin();
                flip = false;
            } else {
                throw new BioError("No strand -- erk!");
            }
            Sequence child = this.getComponentSequence();
            this.projectedFeatures = child != null ? new ProjectedFeatureHolder(this.getComponentSequence(), this, (int)var1_1, (boolean)var2_2) : FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.projectedFeatures;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

