/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.biojava.bio.seq.io.SubArraySymbolList;
import org.biojava.bio.seq.io.SymbolReader;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;

class ChunkedSymbolList
extends AbstractSymbolList
implements Serializable {
    private Symbol[][] chunks;
    private final int chunkSize;
    private Alphabet alpha;
    private int length;
    private static final int CHUNK_SIZE = 16384;

    protected void finalize() throws Throwable {
        super.finalize();
        this.alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public ChunkedSymbolList(Symbol[][] chunks, int chunkSize, int length, Alphabet alpha) {
        this.chunks = chunks;
        this.chunkSize = chunkSize;
        this.length = length;
        this.alpha = alpha;
        alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int length() {
        return this.length;
    }

    public Symbol symbolAt(int pos) {
        try {
            int chnk = --pos / this.chunkSize;
            int spos = pos % this.chunkSize;
            return this.chunks[chnk][spos];
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IndexOutOfBoundsException("Attempted to access symbol at " + ++pos + " of ChunkedSymbolList length " + this.length);
        }
    }

    public SymbolList subList(int start, int end) {
        if (start < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
        }
        int ato = end - 1;
        int afrom = start - 1;
        int cfrom = afrom / this.chunkSize;
        if (ato / this.chunkSize == cfrom) {
            return new SubArraySymbolList(this.chunks[cfrom], end - start + 1, afrom % this.chunkSize, this.getAlphabet());
        }
        return super.subList(start, end);
    }

    public static SymbolList make(SymbolReader sr) throws IOException, IllegalSymbolException {
        ArrayList<Symbol[]> chunkL = new ArrayList<Symbol[]>();
        Symbol[] headChunk = new Symbol[16384];
        int headChunkPos = 0;
        while (sr.hasMoreSymbols()) {
            if (headChunkPos == 16384) {
                chunkL.add(headChunk);
                headChunk = new Symbol[16384];
                headChunkPos = 0;
            }
            int read = sr.readSymbols(headChunk, headChunkPos, 16384 - headChunkPos);
            headChunkPos += read;
        }
        if (headChunkPos > 0) {
            if (headChunkPos < 16384) {
                Symbol[] oldChunk = headChunk;
                headChunk = new Symbol[headChunkPos];
                System.arraycopy(oldChunk, 0, headChunk, 0, headChunkPos);
            }
            chunkL.add(headChunk);
        }
        if (chunkL.size() == 1) {
            return new SubArraySymbolList((Symbol[])chunkL.get(0), headChunkPos, 0, sr.getAlphabet());
        }
        Symbol[][] chunks = new Symbol[chunkL.size()][];
        for (int cnum = 0; cnum < chunkL.size(); ++cnum) {
            chunks[cnum] = (Symbol[])chunkL.get(cnum);
        }
        int length = (chunkL.size() - 1) * 16384 + headChunkPos;
        return new ChunkedSymbolList(chunks, 16384, length, sr.getAlphabet());
    }
}

