/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.regexp.RE;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.AlignmentFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;

public class MSFAlignmentFormat
implements AlignmentFormat {
    private static final boolean DEBUGPRINT = false;
    private static final int DNA = 1;
    private static final int PROTEIN = 2;

    public static void main(String[] args) {
        String filename = args.length < 1 ? "SimpleMSF.msf" : args[0];
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            MSFAlignmentFormat MSFAlignmentFormat1 = new MSFAlignmentFormat();
            MSFAlignmentFormat1.read(reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Alignment read(BufferedReader reader) {
        Vector<String> sequenceNames = new Vector<String>();
        String sequenceName = null;
        String[] sequenceData = null;
        int startOfData = 0;
        int currSeqCount = 0;
        try {
            RE mtc = new RE("Name:\\s+(.*?)\\s+(oo|Len:)");
            RE removewhitespace = new RE("\\s");
            String line = reader.readLine();
            while (line.indexOf("Name:") == -1) {
                line = reader.readLine();
            }
            while (line.indexOf("//") == -1 && line.trim().length() != 0) {
                mtc.match(line);
                sequenceName = line.substring(mtc.getParenStart(1), mtc.getParenEnd(1)).trim();
                if (sequenceName == null || line.trim().length() == 0) break;
                sequenceNames.add(sequenceName);
                line = reader.readLine();
            }
            sequenceData = new String[sequenceNames.size()];
            for (int it = 0; it < sequenceNames.size(); ++it) {
                sequenceData[it] = new String();
            }
            while (line.indexOf((String)sequenceNames.get(0)) == -1) {
                line = reader.readLine();
            }
            while (line != null) {
                for (currSeqCount = 0; currSeqCount < sequenceNames.size() && line.indexOf((String)sequenceNames.get(currSeqCount)) != -1; ++currSeqCount) {
                    startOfData = line.indexOf((String)sequenceNames.get(currSeqCount)) + ((String)sequenceNames.get(currSeqCount)).length();
                    line = line.substring(startOfData);
                    line = removewhitespace.subst(line, "", 0);
                    sequenceData[currSeqCount] = sequenceData[currSeqCount].concat(line);
                    line = reader.readLine();
                    if (currSeqCount < sequenceNames.size() - 1 && line.trim().length() == 0) break;
                }
                while (line != null && line.indexOf((String)sequenceNames.get(0)) == -1) {
                    line = reader.readLine();
                }
            }
            StringBuffer testString = new StringBuffer();
            int agct = 0;
            for (currSeqCount = 0; currSeqCount < sequenceNames.size(); ++currSeqCount) {
                testString.append(sequenceData[currSeqCount]);
            }
            StringTokenizer st = null;
            st = new StringTokenizer(testString.toString().toLowerCase(), "a");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "g");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "c");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "t");
            agct += st.countTokens();
            st = new StringTokenizer(testString.toString().toLowerCase(), "u");
            agct += st.countTokens();
            HashMap<String, SimpleSymbolList> sequenceDataMap = new HashMap<String, SimpleSymbolList>();
            Object sym = null;
            FiniteAlphabet alph = null;
            for (int i = 0; i < testString.toString().length(); ++i) {
                if (Character.toUpperCase(testString.toString().charAt(i)) != 'F' && Character.toUpperCase(testString.toString().charAt(i)) != 'L' && Character.toUpperCase(testString.toString().charAt(i)) != 'I' && Character.toUpperCase(testString.toString().charAt(i)) != 'P' && Character.toUpperCase(testString.toString().charAt(i)) != 'Q' && Character.toUpperCase(testString.toString().charAt(i)) != 'E') continue;
                alph = ProteinTools.getTAlphabet();
            }
            if (alph == null) {
                alph = DNATools.getDNA();
            }
            SymbolTokenization parse = alph.getTokenization("token");
            for (currSeqCount = 0; currSeqCount < sequenceNames.size(); ++currSeqCount) {
                String sd = null;
                sd = sequenceData[currSeqCount].replace('~', '-');
                sd = sequenceData[currSeqCount].replace('.', '-');
                StringBuffer sb = new StringBuffer();
                Object sl = null;
                sequenceDataMap.put((String)sequenceNames.get(currSeqCount), new SimpleSymbolList(parse, sd));
            }
            return new SimpleAlignment(sequenceDataMap);
        }
        catch (Exception e) {
            System.err.println("MSFFormatReader " + e.getMessage());
            return null;
        }
    }

    public void write(OutputStream os, Alignment align, int fileType) throws BioException, IllegalSymbolException {
        int j;
        int i;
        PrintStream out = new PrintStream(os);
        Object[] labels = align.getLabels().toArray();
        int numSeqs = labels.length;
        Iterator[] seqIts = new Iterator[numSeqs];
        int maxLabelLength = 0;
        for (int i2 = 0; i2 < numSeqs; ++i2) {
            seqIts[i2] = align.symbolListForLabel(labels[i2]).iterator();
            if (((String)labels[i2]).length() <= maxLabelLength) continue;
            maxLabelLength = ((String)labels[i2]).length();
        }
        String nl = System.getProperty("line.separator");
        SymbolTokenization toke = null;
        if (fileType == 1) {
            out.println("!!NA_MULTIPLE_ALIGNMENT");
            out.println();
            out.print(" MSF: " + align.length() + "  Type: ");
            out.print("N");
            toke = DNATools.getDNA().getTokenization("token");
        } else if (fileType == 2) {
            out.println("!!AA_MULTIPLE_ALIGNMENT");
            out.println();
            out.print(" MSF: " + align.length() + "  Type: ");
            out.print("P");
            toke = ProteinTools.getTAlphabet().getTokenization("token");
        } else {
            System.out.println("MSFAlignment.write -- File type not recognized.");
            return;
        }
        out.print("  .." + nl);
        out.println();
        for (i = 0; i < numSeqs; ++i) {
            out.print(" Name: " + labels[i]);
            for (j = 0; j < maxLabelLength - ((String)labels[i]).length(); ++j) {
                out.print(" ");
            }
            out.print("  Len: " + align.length() + nl);
        }
        out.println("//");
        out.println();
        while (seqIts[0].hasNext()) {
            for (i = 0; i < numSeqs; ++i) {
                while (((String)labels[i]).length() < maxLabelLength + 1) {
                    labels[i] = " " + labels[i];
                }
                out.print(labels[i] + " ");
                block6: for (j = 0; j < 5; ++j) {
                    out.print(" ");
                    for (int k = 0; k < 10; ++k) {
                        if (!seqIts[i].hasNext()) break block6;
                        out.print(toke.tokenizeSymbol((Symbol)seqIts[i].next()));
                    }
                }
                out.print(nl);
            }
            out.print(nl);
        }
    }

    public void writeDna(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 1);
    }

    public void writeProtein(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 2);
    }
}

