/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.filterxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.BioError;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.seq.io.filterxml.QName;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLAnnotationTypeHandler
extends StAXContentHandlerBase {
    private Map handlerFactories = new HashMap();
    private Map collectionHandlerFactories = new HashMap();
    private AnnotationType annotationType = new AnnotationType.Impl();
    private int depth = 0;

    public AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    public void registerPropertyHandlerFactory(String nsURI, String localName, PropertyConstraintHandlerFactory factory) {
        this.handlerFactories.put(new QName(nsURI, localName), factory);
    }

    public void registerCollectionHandlerFactory(String nsURI, String localName, CollectionConstraintHandlerFactory factory) {
        this.collectionHandlerFactories.put(new QName(nsURI, localName), factory);
    }

    private PropertyConstraintHandler getHandler(String nsURI, String localName) throws SAXException {
        PropertyConstraintHandlerFactory factory = (PropertyConstraintHandlerFactory)this.handlerFactories.get(new QName(nsURI, localName));
        if (factory != null) {
            return factory.makeHandler(nsURI, localName);
        }
        throw new SAXException("Unrecognized element (property context) " + nsURI + ":" + localName);
    }

    private CollectionConstraintHandler getCollectionHandler(String nsURI, String localName) throws SAXException {
        CollectionConstraintHandlerFactory factory = (CollectionConstraintHandlerFactory)this.collectionHandlerFactories.get(new QName(nsURI, localName));
        if (factory != null) {
            return factory.makeHandler(nsURI, localName);
        }
        throw new SAXException("Unrecognized element (collection context) " + nsURI + ":" + localName);
    }

    public XMLAnnotationTypeHandler() {
        this.registerPropertyHandlerFactory("http://www.biojava.org/AnnotationType", "any", new CDATAHandlerFactory(){

            protected PropertyConstraint stringToConstraint(String s) {
                return PropertyConstraint.ANY;
            }
        });
        this.registerPropertyHandlerFactory("http://www.biojava.org/AnnotationType", "none", new CDATAHandlerFactory(){

            protected PropertyConstraint stringToConstraint(String s) {
                return PropertyConstraint.NONE;
            }
        });
        this.registerPropertyHandlerFactory("http://www.biojava.org/AnnotationType", "value", new CDATAHandlerFactory(){

            protected PropertyConstraint stringToConstraint(String s) {
                return new PropertyConstraint.ExactValue(s);
            }
        });
        this.registerPropertyHandlerFactory("http://www.biojava.org/AnnotationType", "byClass", new CDATAHandlerFactory(){

            protected PropertyConstraint stringToConstraint(String s) throws SAXException {
                try {
                    return new PropertyConstraint.ByClass(this.getClass().getClassLoader().loadClass(s));
                }
                catch (Exception ex) {
                    throw new SAXException("Couldn't find class " + s);
                }
            }
        });
        this.registerPropertyHandlerFactory("http://www.biojava.org/AnnotationType", "and", new ConstraintsHandlerFactory(){

            public PropertyConstraint constraintsToConstraint(List l) throws SAXException {
                PropertyConstraint pc = PropertyConstraint.ANY;
                Iterator i = l.iterator();
                pc = (PropertyConstraint)i.next();
                while (i.hasNext()) {
                    pc = new PropertyConstraint.And(pc, (PropertyConstraint)i.next());
                }
                return pc;
            }
        });
        this.registerPropertyHandlerFactory("http://www.biojava.org/AnnotationType", "or", new ConstraintsHandlerFactory(){

            public PropertyConstraint constraintsToConstraint(List l) throws SAXException {
                HashSet<Object> values;
                boolean notValue = false;
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    if (i.next() instanceof PropertyConstraint.ExactValue) continue;
                    notValue = true;
                }
                if (notValue) {
                    PropertyConstraint pc = PropertyConstraint.ANY;
                    Iterator i2 = l.iterator();
                    pc = (PropertyConstraint)i2.next();
                    while (i2.hasNext()) {
                        pc = new PropertyConstraint.Or(pc, (PropertyConstraint)i2.next());
                    }
                    return values;
                }
                values = new HashSet<Object>();
                Iterator i3 = l.iterator();
                while (i3.hasNext()) {
                    values.add(((PropertyConstraint.ExactValue)i3.next()).getValue());
                }
                return new PropertyConstraint.Enumeration(values);
            }
        });
        this.registerPropertyHandlerFactory("http://www.biojava.org/AnnotationType", "byAnnotationType", new ByAnnotationTypeHandlerFactory());
        this.registerCollectionHandlerFactory("http://www.biojava.org/AnnotationType", "any", new CDATACollectionHandlerFactory(){

            protected CollectionConstraint stringToConstraint(String s) {
                return CollectionConstraint.ANY;
            }
        });
        this.registerCollectionHandlerFactory("http://www.biojava.org/AnnotationType", "none", new CDATACollectionHandlerFactory(){

            protected CollectionConstraint stringToConstraint(String s) {
                return CollectionConstraint.NONE;
            }
        });
        this.registerCollectionHandlerFactory("http://www.biojava.org/AnnotationType", "empty", new CDATACollectionHandlerFactory(){

            protected CollectionConstraint stringToConstraint(String s) {
                return CollectionConstraint.EMPTY;
            }
        });
        this.registerCollectionHandlerFactory("http://www.biojava.org/AnnotationType", "and", new ConstraintsCollectionHandlerFactory(){

            public CollectionConstraint constraintsToConstraint(List l) throws SAXException {
                CollectionConstraint pc = CollectionConstraint.ANY;
                Iterator i = l.iterator();
                pc = (CollectionConstraint)i.next();
                while (i.hasNext()) {
                    pc = new CollectionConstraint.And(pc, (CollectionConstraint)i.next());
                }
                return pc;
            }
        });
        this.registerCollectionHandlerFactory("http://www.biojava.org/AnnotationType", "or", new ConstraintsCollectionHandlerFactory(){

            public CollectionConstraint constraintsToConstraint(List l) throws SAXException {
                CollectionConstraint pc = CollectionConstraint.ANY;
                Iterator i = l.iterator();
                pc = (CollectionConstraint)i.next();
                while (i.hasNext()) {
                    pc = new CollectionConstraint.Or(pc, (CollectionConstraint)i.next());
                }
                return pc;
            }
        });
        this.registerCollectionHandlerFactory("http://www.biojava.org/AnnotationType", "allValuesIn", new PropCardCollectionHandlerFactory(){

            public CollectionConstraint constraintsToConstraint(Location card, PropertyConstraint pc) throws SAXException {
                return new CollectionConstraint.AllValuesIn(pc, card);
            }
        });
        this.registerCollectionHandlerFactory("http://www.biojava.org/AnnotationType", "contains", new PropCardCollectionHandlerFactory(){

            public CollectionConstraint constraintsToConstraint(Location card, PropertyConstraint pc) throws SAXException {
                return new CollectionConstraint.Contains(pc, card);
            }
        });
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        if (this.depth == 1) {
            if (localName.equals("propertyDefault")) {
                dm.delegate(new PropertyHandler(){

                    protected void setConstraint(CollectionConstraint cc) throws ChangeVetoException {
                        XMLAnnotationTypeHandler.this.annotationType.setDefaultConstraint(cc);
                    }
                });
            } else if (localName.equals("property")) {
                final String propName = attrs.getValue("http://www.biojava.org/AnnotationType", "name");
                dm.delegate(new PropertyHandler(){

                    protected void setConstraint(CollectionConstraint cc) throws ChangeVetoException {
                        XMLAnnotationTypeHandler.this.annotationType.setConstraint(propName, cc);
                    }
                });
            } else {
                throw new SAXException("Unexpected element " + nsURI + ":" + localName);
            }
        }
        ++this.depth;
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
        --this.depth;
    }

    private abstract class PropCardCollectionHandlerFactory
    implements CollectionConstraintHandlerFactory {
        private PropCardCollectionHandlerFactory() {
        }

        protected abstract CollectionConstraint constraintsToConstraint(Location var1, PropertyConstraint var2) throws SAXException;

        public CollectionConstraintHandler makeHandler(String nsURI, String localName) {
            return new PropCardHandler();
        }

        private class PropCardHandler
        extends StAXContentHandlerBase
        implements CollectionConstraintHandler {
            private Location cardinality;
            private PropertyConstraint pc;
            private int depth = 0;

            private PropCardHandler() {
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (this.depth == 1) {
                    if ("cardinalityAny".equals(localName)) {
                        this.cardinality = CardinalityConstraint.ANY;
                    } else if ("cardinalityZero".equals(localName)) {
                        this.cardinality = CardinalityConstraint.ZERO;
                    } else if ("cardinalityOne".equals(localName)) {
                        this.cardinality = CardinalityConstraint.ONE;
                    } else if ("cardinalityNone".equals(localName)) {
                        this.cardinality = CardinalityConstraint.NONE;
                    } else if ("cardinality".equals(localName)) {
                        dm.delegate(new CardinalityHandler());
                    } else {
                        dm.delegate(XMLAnnotationTypeHandler.this.getHandler(nsURI, localName));
                    }
                }
                ++this.depth;
            }

            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof CardinalityHandler) {
                    this.cardinality = ((CardinalityHandler)delegate).getCardinality();
                } else if (delegate instanceof PropertyConstraintHandler) {
                    this.pc = ((PropertyConstraintHandler)delegate).getPropertyConstraint();
                }
                --this.depth;
            }

            public CollectionConstraint getCollectionConstraint() throws SAXException {
                return PropCardCollectionHandlerFactory.this.constraintsToConstraint(this.cardinality, this.pc);
            }
        }
    }

    private abstract class ConstraintsCollectionHandlerFactory
    implements CollectionConstraintHandlerFactory {
        private ConstraintsCollectionHandlerFactory() {
        }

        protected abstract CollectionConstraint constraintsToConstraint(List var1) throws SAXException;

        public CollectionConstraintHandler makeHandler(String nsURI, String localName) {
            return new ConstraintsHandler();
        }

        private class ConstraintsHandler
        extends StAXContentHandlerBase
        implements CollectionConstraintHandler {
            private List constraintChildren = new ArrayList();
            private int depth = 0;

            private ConstraintsHandler() {
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (this.depth == 1) {
                    CollectionConstraintHandler childHandler = XMLAnnotationTypeHandler.this.getCollectionHandler(nsURI, localName);
                    dm.delegate(childHandler);
                }
                ++this.depth;
            }

            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof CollectionConstraintHandler) {
                    this.constraintChildren.add(((CollectionConstraintHandler)delegate).getCollectionConstraint());
                }
                --this.depth;
            }

            public CollectionConstraint getCollectionConstraint() throws SAXException {
                return ConstraintsCollectionHandlerFactory.this.constraintsToConstraint(this.constraintChildren);
            }
        }
    }

    private abstract class CDATACollectionHandlerFactory
    implements CollectionConstraintHandlerFactory {
        private CDATACollectionHandlerFactory() {
        }

        protected abstract CollectionConstraint stringToConstraint(String var1) throws SAXException;

        public CollectionConstraintHandler makeHandler(String nsURI, String localName) {
            return new CDATAHandler();
        }

        private class CDATAHandler
        extends StringElementHandlerBase
        implements CollectionConstraintHandler {
            private CollectionConstraint cons;

            private CDATAHandler() {
            }

            public CollectionConstraint getCollectionConstraint() {
                return this.cons;
            }

            protected void setStringValue(String s) throws SAXException {
                this.cons = CDATACollectionHandlerFactory.this.stringToConstraint(s);
            }
        }
    }

    private class ByAnnotationTypeHandlerFactory
    implements PropertyConstraintHandlerFactory {
        private ByAnnotationTypeHandlerFactory() {
        }

        public PropertyConstraintHandler makeHandler(String nsURI, String localName) {
            return new ByAnnotationTypeHandler();
        }

        private class ByAnnotationTypeHandler
        extends StAXContentHandlerBase
        implements PropertyConstraintHandler {
            private int depth = 0;
            private AnnotationType annoType;

            private ByAnnotationTypeHandler() {
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (this.depth == 1) {
                    dm.delegate(new XMLAnnotationTypeHandler());
                }
                ++this.depth;
            }

            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof XMLAnnotationTypeHandler) {
                    this.annoType = ((XMLAnnotationTypeHandler)delegate).getAnnotationType();
                }
                --this.depth;
            }

            public PropertyConstraint getPropertyConstraint() throws SAXException {
                return new PropertyConstraint.ByAnnotationType(this.annoType);
            }
        }
    }

    private abstract class ConstraintsHandlerFactory
    implements PropertyConstraintHandlerFactory {
        private ConstraintsHandlerFactory() {
        }

        protected abstract PropertyConstraint constraintsToConstraint(List var1) throws SAXException;

        public PropertyConstraintHandler makeHandler(String nsURI, String localName) {
            return new ConstraintsHandler();
        }

        private class ConstraintsHandler
        extends StAXContentHandlerBase
        implements PropertyConstraintHandler {
            private List constraintChildren = new ArrayList();
            private int depth = 0;

            private ConstraintsHandler() {
            }

            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (this.depth == 1) {
                    PropertyConstraintHandler childHandler = XMLAnnotationTypeHandler.this.getHandler(nsURI, localName);
                    dm.delegate(childHandler);
                }
                ++this.depth;
            }

            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof PropertyConstraintHandler) {
                    this.constraintChildren.add(((PropertyConstraintHandler)delegate).getPropertyConstraint());
                }
                --this.depth;
            }

            public PropertyConstraint getPropertyConstraint() throws SAXException {
                return ConstraintsHandlerFactory.this.constraintsToConstraint(this.constraintChildren);
            }
        }
    }

    private abstract class CDATAHandlerFactory
    implements PropertyConstraintHandlerFactory {
        private CDATAHandlerFactory() {
        }

        protected abstract PropertyConstraint stringToConstraint(String var1) throws SAXException;

        public PropertyConstraintHandler makeHandler(String nsURI, String localName) {
            return new CDATAHandler();
        }

        private class CDATAHandler
        extends StringElementHandlerBase
        implements PropertyConstraintHandler {
            private PropertyConstraint cons;

            private CDATAHandler() {
            }

            public PropertyConstraint getPropertyConstraint() {
                return this.cons;
            }

            protected void setStringValue(String s) throws SAXException {
                this.cons = CDATAHandlerFactory.this.stringToConstraint(s);
            }
        }
    }

    private class CardinalityHandler
    extends StAXContentHandlerBase {
        private List spans = new ArrayList();

        private CardinalityHandler() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if ("span".equals(localName)) {
                int start = Integer.parseInt(attrs.getValue("start"));
                String stops = attrs.getValue("stop");
                int stop = stops.equals("infinity") ? Integer.MAX_VALUE : Integer.parseInt(stops);
                this.spans.add(new RangeLocation(start, stop));
            }
        }

        public Location getCardinality() {
            return LocationTools.union(this.spans);
        }
    }

    private abstract class PropertyHandler
    extends StAXContentHandlerBase {
        private CollectionConstraint cons;
        private int depth = 0;

        private PropertyHandler() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (this.depth == 1) {
                dm.delegate(XMLAnnotationTypeHandler.this.getCollectionHandler(nsURI, localName));
            }
            ++this.depth;
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
            --this.depth;
            if (delegate instanceof CollectionConstraintHandler) {
                this.cons = ((CollectionConstraintHandler)delegate).getCollectionConstraint();
            }
        }

        public void endTree() {
            try {
                this.setConstraint(this.cons);
            }
            catch (ChangeVetoException ex) {
                throw new BioError(ex, "Assertion failed: couldn't modify AnnotationType");
            }
        }

        protected abstract void setConstraint(CollectionConstraint var1) throws ChangeVetoException;
    }

    public static interface CollectionConstraintHandlerFactory {
        public CollectionConstraintHandler makeHandler(String var1, String var2) throws SAXException;
    }

    public static interface CollectionConstraintHandler
    extends StAXContentHandler {
        public CollectionConstraint getCollectionConstraint() throws SAXException;
    }

    public static interface PropertyConstraintHandlerFactory {
        public PropertyConstraintHandler makeHandler(String var1, String var2) throws SAXException;
    }

    public static interface PropertyConstraintHandler
    extends StAXContentHandler {
        public PropertyConstraint getPropertyConstraint() throws SAXException;
    }
}

