/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ragbag.RagbagAbstractSequence;
import org.biojava.bio.seq.ragbag.RagbagComponentDirectory;
import org.biojava.bio.seq.ragbag.RagbagSequenceFactory;
import org.biojava.bio.seq.ragbag.RagbagSequenceItf;
import org.biojava.bio.seq.ragbag.RagbagVirtualSequenceBuilder;
import org.biojava.utils.ChangeVetoException;
import org.xml.sax.SAXException;

public class RagbagAssembly
extends RagbagAbstractSequence {
    private RagbagSequenceFactory seqFactory;
    private String name;
    private String urn;

    public RagbagAssembly(String name, String urn, File thisDir, RagbagSequenceFactory seqFactory, RagbagComponentDirectory compDir) throws BioException, FileNotFoundException, ChangeVetoException, IOException, SAXException {
        this.seqFactory = seqFactory;
        this.name = name;
        this.urn = urn;
        if (!thisDir.exists() || !thisDir.isDirectory()) {
            throw new BioException("RagbagAssembly: the reference is not to a directory.");
        }
        File mapFile = new File(thisDir, "Map");
        if (mapFile.exists()) {
            RagbagVirtualSequenceBuilder seqBuilder = new RagbagVirtualSequenceBuilder(thisDir.getName(), "", mapFile, seqFactory, compDir);
            File[] dirList = thisDir.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                File currFile = dirList[i];
                if (currFile.getName().equals("Map") || currFile.getName().equals("Annotation")) continue;
                seqBuilder.addSequence(currFile);
            }
            File annotDir = new File(thisDir, "Annotation");
            if (annotDir.exists() && annotDir.isDirectory() && annotDir.getName().equals("Annotation")) {
                File[] annotDirList = annotDir.listFiles();
                for (int i = 0; i < annotDirList.length; ++i) {
                    if (!annotDirList[i].isFile()) continue;
                    seqBuilder.addFeatures(annotDirList[i]);
                }
            }
            System.out.println("return built virtual sequence");
            this.sequence = seqBuilder.makeSequence();
        } else {
            File[] dirList = thisDir.listFiles();
            if (dirList == null || dirList.length == 0) {
                throw new BioException("RagbagAssembly: directory is empty");
            }
            File seqFile = null;
            int seqFileCount = 0;
            boolean hasAnnotation = false;
            File annotDir = null;
            for (int i = 0; i < dirList.length; ++i) {
                if (dirList[i].isFile()) {
                    ++seqFileCount;
                    seqFile = dirList[i];
                    continue;
                }
                if (!dirList[i].isDirectory() || !dirList[i].getName().equals("Annotation")) continue;
                annotDir = dirList[i];
                hasAnnotation = true;
            }
            if (seqFileCount == 0 || seqFileCount > 1) {
                throw new BioException("RagbagAssembly: an unmapped directory MUST have ONE sequence file.");
            }
            RagbagSequenceItf currSequence = seqFactory.getSequenceObject(name, urn);
            currSequence.addSequenceFile(seqFile);
            File[] annotDirList = annotDir.listFiles();
            for (int i = 0; i < annotDirList.length; ++i) {
                if (!annotDirList[i].isFile()) continue;
                currSequence.addFeatureFile(annotDirList[i]);
            }
            currSequence.makeSequence();
            this.sequence = currSequence;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.urn;
    }
}

