/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RagbagMap
extends StAXContentHandlerBase {
    private List map = new Vector();
    private Map refMap = new HashMap();
    private File mapFile;
    private boolean locked = false;
    private int dstLength = 0;
    private static int INIT = 0;
    private static int RAGBAGMAP = 1;
    private static int COMPONENT = 2;
    private static int MAPPING = 3;
    private int level = 0;
    private int previousState = INIT;
    private String componentFilename;
    private String componentRef;
    private String EMPTYSTRING = "";

    public RagbagMap(File mapFile) {
        this.mapFile = mapFile;
    }

    public void parse() throws FileNotFoundException, IOException, SAXException {
        if (this.locked) {
            throw new SAXException("Attempt to change an locked RagbagMap!");
        }
        XMLReader parser = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            parser = spf.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Couldn't create parser");
        }
        parser.setContentHandler(new SAX2StAXAdaptor(this));
        InputSource is = new InputSource(new FileReader(this.mapFile));
        parser.parse(is);
    }

    public String getRef(String filename) {
        String refString = (String)this.refMap.get(filename);
        if (refString == null) {
            System.err.println("RagbagMap.getRef lookup failed for " + filename);
            return "";
        }
        return refString;
    }

    public Enumeration getEnumeration(String filename) {
        return new MapEnum(filename);
    }

    public int getDstLength() {
        return this.dstLength;
    }

    public void endTree() {
        this.locked = true;
    }

    /*
     * WARNING - void declaration
     */
    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        ++this.level;
        switch (this.previousState) {
            case 0: {
                if (this.level == 1 && localName.equals("ragbag_map")) {
                    this.previousState = RAGBAGMAP;
                    break;
                }
                throw new SAXException("Ragbag map file does not start with a <ragbag_map> element");
            }
            case 1: {
                if (this.level == 2 && localName.equals("component")) {
                    this.previousState = COMPONENT;
                    this.componentFilename = attrs.getValue("source");
                    if (this.componentFilename == null) {
                        throw new SAXException("source attribute is missing in <component>");
                    }
                    this.componentRef = attrs.getValue("ref");
                    if (this.componentRef == null) {
                        this.componentRef = this.EMPTYSTRING;
                    }
                    if (this.refMap.containsKey(this.componentFilename)) break;
                    this.refMap.put(this.componentFilename, this.componentRef);
                    break;
                }
                throw new SAXException("Illegal element " + localName + " encountered when expecting a <component>");
            }
            case 2: {
                if (this.level == 3 && localName.equals("mapping")) {
                    void var18_18;
                    StrandedFeature.Strand strand;
                    this.previousState = MAPPING;
                    String refStg = attrs.getValue("ref");
                    if (refStg == null) {
                        refStg = this.EMPTYSTRING;
                    }
                    String srcStartStg = attrs.getValue("src_start");
                    String srcEndStg = attrs.getValue("src_end");
                    String dstStartStg = attrs.getValue("dst_start");
                    String dstEndStg = attrs.getValue("dst_end");
                    String direction = attrs.getValue("sense");
                    if (srcStartStg == null || srcEndStg == null || dstStartStg == null || dstEndStg == null || direction == null) {
                        throw new SAXException("one or more attributes missing from <mapping>");
                    }
                    int srcStart = new Integer(srcStartStg);
                    int srcEnd = new Integer(srcEndStg);
                    int dstStart = new Integer(dstStartStg);
                    int dstEnd = new Integer(dstEndStg);
                    if (srcStart > srcEnd || dstStart > dstEnd) {
                        throw new SAXException("illegal sequence coordinates!");
                    }
                    RangeLocation srcLoc = new RangeLocation(srcStart, srcEnd);
                    RangeLocation dstLoc = new RangeLocation(dstStart, dstEnd);
                    this.dstLength = Math.max(this.dstLength, dstEnd);
                    if (direction.equals("SAME")) {
                        strand = StrandedFeature.POSITIVE;
                    } else if (direction.equals("REVERSED")) {
                        strand = StrandedFeature.NEGATIVE;
                    } else {
                        throw new SAXException("illegal value for direction attribute");
                    }
                    this.map.add(new MapElement(refStg.trim(), this.componentFilename, srcLoc, dstLoc, (StrandedFeature.Strand)var18_18));
                    break;
                }
                throw new SAXException("Illegal element " + localName + " encountered when expecting a <mapping>");
            }
            case 3: {
                throw new SAXException("Illegal attempt to nest element in <mapping>");
            }
            default: {
                throw new SAXException("Catastrophic parse failure!");
            }
        }
    }

    public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
        switch (this.previousState) {
            case 0: {
                if (this.level == 0) break;
                throw new SAXException("Parse error in endElement " + this.level + " " + localName);
            }
            case 1: {
                if (this.level != 1) {
                    throw new SAXException("Parse error in endElement " + this.level + " " + localName);
                }
                this.previousState = INIT;
                break;
            }
            case 2: {
                if (this.level != 2) {
                    throw new SAXException("Parse error in endElement " + this.level + " " + localName);
                }
                this.previousState = RAGBAGMAP;
                break;
            }
            case 3: {
                if (this.level != 3) {
                    throw new SAXException("Parse error in endElement " + this.level + " " + localName);
                }
                this.previousState = COMPONENT;
                break;
            }
            default: {
                throw new SAXException("Parse error in endElement");
            }
        }
        --this.level;
    }

    public class MapElement {
        private String ref;
        private String filename;
        private RangeLocation srcLoc;
        private RangeLocation dstLoc;
        private StrandedFeature.Strand strand;

        private MapElement(String ref, String filename, RangeLocation srcLoc, RangeLocation dstLoc, StrandedFeature.Strand strand) {
            this.filename = filename;
            this.srcLoc = srcLoc;
            this.dstLoc = dstLoc;
            this.strand = strand;
        }

        public String getRef() {
            return this.ref;
        }

        public String getFilename() {
            return this.filename;
        }

        public RangeLocation getSrcLocation() {
            return this.srcLoc;
        }

        public RangeLocation getDstLocation() {
            return this.dstLoc;
        }

        public StrandedFeature.Strand getStrand() {
            return this.strand;
        }
    }

    public class MapEnum
    implements Enumeration {
        MapElement mapElem = null;
        String filename;
        Iterator mapI;

        private MapEnum(String filename) {
            this.filename = filename;
            this.mapI = RagbagMap.this.map.iterator();
        }

        public boolean hasMoreElements() {
            if (this.mapElem == null) {
                while (this.mapI.hasNext()) {
                    MapElement thisMapElem = (MapElement)this.mapI.next();
                    if (!thisMapElem.filename.equals(this.filename)) continue;
                    this.mapElem = thisMapElem;
                    return true;
                }
                this.mapElem = null;
                return false;
            }
            return true;
        }

        public Object nextElement() {
            if (this.mapElem == null && !this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            MapElement returnElem = this.mapElem;
            this.mapElem = null;
            return returnElem;
        }
    }
}

