/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ragbag.RagbagEmblParser;
import org.biojava.bio.seq.ragbag.RagbagFileParser;
import org.biojava.bio.seq.ragbag.RagbagFileParserFactory;
import org.biojava.bio.seq.ragbag.RagbagGAMEParser;
import org.biojava.bio.seq.ragbag.RagbagGenbankParser;
import org.biojava.bio.seq.ragbag.RagbagXFFParser;

class RagbagParserFactory {
    static Map parserRegistry;
    static RagbagParserFactory FACTORY;

    RagbagParserFactory() {
        parserRegistry = new HashMap();
        RagbagParserFactory.registerParser("game", RagbagGAMEParser.FACTORY);
        RagbagParserFactory.registerParser("embl", RagbagEmblParser.FACTORY);
        RagbagParserFactory.registerParser("gb", RagbagGenbankParser.FACTORY);
        RagbagParserFactory.registerParser("xff", RagbagXFFParser.FACTORY);
    }

    public static void registerParser(String extension, RagbagFileParserFactory parserFactory) {
        parserRegistry.put(extension, parserFactory);
    }

    private String getExtension(File inputFile) {
        String name = inputFile.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public RagbagFileParser getParser(File inputFile) throws BioException {
        String currExt = this.getExtension(inputFile);
        if (parserRegistry.containsKey(currExt)) {
            return ((RagbagFileParserFactory)parserRegistry.get(currExt)).getParser(inputFile);
        }
        throw new BioException("no parser found for file " + inputFile.getName());
    }

    static {
        FACTORY = new RagbagParserFactory();
    }
}

