/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SimpleAssemblyBuilder;
import org.biojava.bio.seq.io.game.GAMEHandler;
import org.biojava.bio.seq.ragbag.RagbagAssembly;
import org.biojava.bio.seq.ragbag.RagbagComponentDirectory;
import org.biojava.bio.seq.ragbag.RagbagMap;
import org.biojava.bio.seq.ragbag.RagbagSequenceFactory;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class RagbagVirtualSequenceBuilder {
    private SimpleAssemblyBuilder sab = null;
    private RagbagMap map = null;
    private String seqName;
    private String uri;
    private RagbagSequenceFactory factory;
    private RagbagComponentDirectory compDir;

    protected RagbagVirtualSequenceBuilder(String seqName, String uri, File mapFile, RagbagSequenceFactory factory, RagbagComponentDirectory compDir) throws BioException, SAXException {
        this.seqName = seqName;
        this.uri = uri;
        this.factory = factory;
        this.compDir = compDir;
        this.map = new RagbagMap(mapFile);
        try {
            this.map.parse();
        }
        catch (FileNotFoundException fne) {
            throw new BioException("map file " + mapFile.getName() + " does not exist");
        }
        catch (IOException fne) {
            throw new BioException("IO Exception on file " + mapFile.getName());
        }
        System.out.println("creating SimpleAssembly");
        this.sab = new SimpleAssemblyBuilder();
        this.sab.setName(seqName);
        this.sab.setURI(uri);
    }

    public void addSequence(File seqfile) throws BioException, ChangeVetoException, IOException, SAXException {
        Enumeration mapEntries = this.map.getEnumeration(seqfile.getName());
        if (!mapEntries.hasMoreElements()) {
            System.err.println("RagbagVirtualSequenceBuilder.addSequence: no mapping for file " + seqfile.getName());
            return;
        }
        Sequence currSequence = null;
        if (seqfile.isFile()) {
            currSequence = this.factory.getSequenceObject(this.map.getRef(seqfile.getName()), "");
            currSequence.addSequenceFile(seqfile);
            currSequence.makeSequence();
        } else if (seqfile.isDirectory()) {
            try {
                currSequence = new RagbagAssembly(this.map.getRef(seqfile.getName()), "", seqfile, this.factory, this.compDir);
            }
            catch (FileNotFoundException fne) {
                throw new BioException("Directory " + seqfile.getName() + "could not be found.");
            }
        } else {
            throw new BioError(seqfile.getName() + " is not a file or directory!");
        }
        while (mapEntries.hasMoreElements()) {
            RagbagMap.MapElement mapping = (RagbagMap.MapElement)mapEntries.nextElement();
            ComponentFeature.Template cft = new ComponentFeature.Template();
            cft.annotation = new SimpleAnnotation();
            cft.location = mapping.getDstLocation();
            cft.source = "";
            cft.type = "Component";
            cft.strand = mapping.getStrand();
            cft.componentLocation = mapping.getSrcLocation();
            cft.componentSequence = currSequence;
            System.out.println("Adding features on " + seqfile.getName() + cft.componentLocation);
            try {
                ComponentFeature cf = this.sab.addComponentSequence(cft);
                if (this.compDir == RagbagComponentDirectory.UNLOGGED) continue;
                this.compDir.addComponentFeature(this.map.getRef(seqfile.getName()), cf);
            }
            catch (ChangeVetoException cve) {
                System.err.println("Can't add feature: change vetoed.");
            }
        }
    }

    public void addFeatures(File featureFile) throws BioException {
        if (!featureFile.exists() || !featureFile.isFile()) {
            throw new BioException("RagbagSequence: can't use the specified file");
        }
        GAMEHandler handler = new GAMEHandler();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader parser = spf.newSAXParser().getXMLReader();
            handler.setFeatureListener(this.sab);
            parser.setContentHandler(new SAX2StAXAdaptor(handler));
            InputSource is = new InputSource(new FileReader(featureFile));
            parser.parse(is);
        }
        catch (SAXException se) {
            throw new BioException(se);
        }
        catch (IOException io) {
            throw new BioException(io);
        }
        catch (ParserConfigurationException ex) {
            throw new BioException(ex);
        }
    }

    public Sequence makeSequence() {
        return this.sab.makeSequence();
    }
}

