/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class MotifTools {
    private static Symbol[] symProto = new Symbol[0];

    public static String createRegex(SymbolList motif) {
        if (motif.length() == 0) {
            throw new IllegalArgumentException("SymbolList was empty");
        }
        StringBuffer regex = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        try {
            SymbolTokenization sToke = motif.getAlphabet().getTokenization("token");
            if (sToke.getTokenType() != SymbolTokenization.CHARACTER) {
                throw new IllegalArgumentException("SymbolList alphabet did not have a character token type");
            }
            int motifLen = motif.length();
            Symbol gap = AlphabetManager.getGapSymbol();
            for (int i = 1; i <= motifLen; ++i) {
                StringBuffer sb = new StringBuffer();
                Symbol sym = motif.symbolAt(i);
                FiniteAlphabet ambiAlpha = (FiniteAlphabet)sym.getMatches();
                if (ambiAlpha.size() == 1) {
                    sb.append(sToke.tokenizeSymbol(sym));
                } else {
                    Set rawSyms = AlphabetManager.getAllSymbols(ambiAlpha);
                    ArrayList<Symbol> gapSyms = new ArrayList<Symbol>();
                    Iterator si = rawSyms.iterator();
                    while (si.hasNext()) {
                        Symbol rawSym = (Symbol)si.next();
                        if (((FiniteAlphabet)rawSym.getMatches()).size() != 0) continue;
                        gapSyms.add(rawSym);
                    }
                    rawSyms.removeAll(gapSyms);
                    Symbol[] ambiSyms = rawSyms.toArray(symProto);
                    char[] ambiChars = new char[ambiSyms.length];
                    for (int j = 0; j < ambiSyms.length; ++j) {
                        ambiChars[j] = sToke.tokenizeSymbol(ambiSyms[j]).charAt(0);
                    }
                    Arrays.sort(ambiChars);
                    sb.append(ambiChars);
                }
                String result = sb.substring(0);
                if (i == 1) {
                    stack.push(result);
                    continue;
                }
                if (i < motifLen) {
                    if (!stack.isEmpty() && stack.peek().equals(result)) {
                        stack.push(result);
                        continue;
                    }
                    regex = MotifTools.extendRegex(stack, regex);
                    stack.push(result);
                    continue;
                }
                if (!stack.isEmpty() && stack.peek().equals(result)) {
                    stack.push(result);
                    regex = MotifTools.extendRegex(stack, regex);
                    continue;
                }
                regex = MotifTools.extendRegex(stack, regex);
                stack.push(result);
                regex = MotifTools.extendRegex(stack, regex);
            }
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Internal error: failed to tokenize a Symbol from an existing SymbolList");
        }
        catch (BioException be) {
            throw new BioError(be, "Internal error: failed to get SymbolTokenization for SymbolList alphabet");
        }
        return regex.substring(0);
    }

    private static StringBuffer extendRegex(Stack stack, StringBuffer regex) {
        String component = (String)stack.peek();
        if (component.length() == 1) {
            regex.append(component);
            if (stack.size() > 1) {
                regex.append("{");
                regex.append(stack.size());
                regex.append("}");
            }
        } else {
            regex.append("[");
            regex.append(component);
            regex.append("]");
            if (stack.size() > 1) {
                regex.append("{");
                regex.append(stack.size());
                regex.append("}");
            }
        }
        stack.clear();
        return regex;
    }
}

