/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.StaticMemberPlaceHolder;
import org.biojava.utils.Unchangeable;

public interface SymbolList
extends Changeable {
    public static final ChangeType EDIT = new ChangeType("the SymbolList has been edited", "org.biojava.bio.symbol.SymbolList", "EDIT");
    public static final SymbolList EMPTY_LIST = new EmptySymbolList();

    public Alphabet getAlphabet();

    public int length();

    public Symbol symbolAt(int var1) throws IndexOutOfBoundsException;

    public List toList();

    public Iterator iterator();

    public SymbolList subList(int var1, int var2) throws IndexOutOfBoundsException;

    public String seqString();

    public String subStr(int var1, int var2) throws IndexOutOfBoundsException;

    public void edit(Edit var1) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException;

    static class 1 {
        static /* synthetic */ Class class$org$biojava$bio$symbol$SymbolList;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class EmptySymbolList
    extends Unchangeable
    implements SymbolList,
    Serializable {
        public Alphabet getAlphabet() {
            return Alphabet.EMPTY_ALPHABET;
        }

        public int length() {
            return 0;
        }

        public Symbol symbolAt(int index) throws IndexOutOfBoundsException {
            throw new IndexOutOfBoundsException("Attempted to retrieve symbol from empty list at " + index);
        }

        public List toList() {
            return Collections.EMPTY_LIST;
        }

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        public SymbolList subList(int start, int end) throws IndexOutOfBoundsException {
            Collections.EMPTY_LIST.subList(start - 1, end);
            return EMPTY_LIST;
        }

        public String seqString() {
            return "";
        }

        public String subStr(int start, int end) throws IndexOutOfBoundsException {
            throw new IndexOutOfBoundsException("You can not retrieve part of an empty symbol list");
        }

        public void edit(Edit edit) throws IndexOutOfBoundsException, ChangeVetoException {
            throw new ChangeVetoException("You can't edit the empty symbol list");
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((1.class$org$biojava$bio$symbol$SymbolList == null ? (1.class$org$biojava$bio$symbol$SymbolList = 1.class$("org.biojava.bio.symbol.SymbolList")) : 1.class$org$biojava$bio$symbol$SymbolList).getField("EMPTY_LIST"));
            }
            catch (NoSuchFieldException nsfe) {
                throw new NotSerializableException(nsfe.getMessage());
            }
        }
    }
}

