/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.OrderNSymbolList;
import org.biojava.bio.symbol.ReverseSymbolList;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.TranslatedSymbolList;
import org.biojava.bio.symbol.TranslationTable;
import org.biojava.bio.symbol.WindowedSymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

public final class SymbolListViews {
    private SymbolListViews() {
    }

    public static SymbolList orderNSymbolList(SymbolList source, int order) throws IllegalAlphabetException {
        if (order == 1) {
            return source;
        }
        return new OrderNSymbolList(source, order);
    }

    public static SymbolList windowedSymbolList(SymbolList source, int wsize) throws IllegalArgumentException {
        return new WindowedSymbolList(source, wsize);
    }

    public static SymbolList reverse(SymbolList symbols) {
        return new ReverseSymbolList(symbols);
    }

    public static SymbolList translate(SymbolList symbols, TranslationTable table) throws IllegalAlphabetException {
        return new TranslatedSymbolList(symbols, table);
    }

    public static Alignment alignment(Map labelToSymList) throws IllegalArgumentException {
        return new SimpleAlignment(labelToSymList);
    }

    public static Alignment alignment(List labels, SymbolList symList) throws IllegalArgumentException {
        return new SymListAsAlignment(labels, symList);
    }

    private static class IndexedSymbolList
    extends AbstractSymbolList {
        private final int indx;
        private final SymbolList symList;

        public IndexedSymbolList(SymbolList symList, int indx) throws IllegalArgumentException {
            if (indx >= symList.getAlphabet().getAlphabets().size()) {
                throw new IllegalArgumentException("index too high");
            }
            this.indx = indx;
            this.symList = symList;
        }

        public Alphabet getAlphabet() {
            return (Alphabet)this.symList.getAlphabet().getAlphabets().get(this.indx);
        }

        public int length() {
            return this.symList.length();
        }

        public Symbol symbolAt(int indx) throws IndexOutOfBoundsException {
            return (Symbol)((BasisSymbol)this.symList.symbolAt(indx)).getSymbols().get(this.indx);
        }
    }

    private static class SymListAsAlignment
    extends Unchangeable
    implements Alignment {
        private final SymbolList symList;
        private final List labels;

        public SymListAsAlignment(List labels, SymbolList symList) {
            if (labels.size() != symList.getAlphabet().getAlphabets().size()) {
                throw new IllegalArgumentException("There must be one label per symbol list");
            }
            this.labels = Collections.unmodifiableList(new ArrayList(labels));
            this.symList = symList;
        }

        public List getLabels() {
            return this.labels;
        }

        public SequenceIterator sequenceIterator() {
            throw new UnsupportedOperationException("This method sucks");
        }

        public Iterator symbolListIterator() {
            return new Alignment.SymbolListIterator(this);
        }

        public Symbol symbolAt(Object label, int column) {
            BasisSymbol sym = (BasisSymbol)this.symList.symbolAt(column);
            return (Symbol)sym.getSymbols().get(this.labels.indexOf(label));
        }

        public SymbolList symbolListForLabel(Object label) {
            return new IndexedSymbolList(this.symList, this.labels.indexOf(label));
        }

        public Alphabet getAlphabet() {
            return this.symList.getAlphabet();
        }

        public Iterator iterator() {
            return this.symList.iterator();
        }

        public int length() {
            return this.symList.length();
        }

        public String seqString() {
            return this.symList.seqString();
        }

        public SymbolList subList(int start, int end) throws IndexOutOfBoundsException {
            return this.symList.subList(start, end);
        }

        public String subStr(int start, int end) throws IndexOutOfBoundsException {
            return this.symList.subStr(start, end);
        }

        public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
            this.symList.edit(edit);
        }

        public List toList() {
            return this.symList.toList();
        }

        public Symbol symbolAt(int indx) throws IndexOutOfBoundsException {
            return this.symList.symbolAt(indx);
        }

        public Alignment subAlignment(Set labels, Location loc) {
            throw new UnsupportedOperationException("Fixme: this needs to be implemented");
        }
    }
}

