/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.utils.Commitable;
import org.biojava.utils.NestedError;
import org.biojava.utils.NestedException;

public abstract class FileAsList
extends AbstractList
implements Commitable {
    private static final int LEADER = 4;
    private RandomAccessFile mappedFile;
    private int commitedRecords;
    private int lastIndx = -1;
    private Object lastRec;
    private byte[] buffer;
    private int sizeCache = -1;

    public FileAsList(File mappedFile, int recordLength) throws IOException {
        int i;
        if (mappedFile.exists()) {
            throw new IOException("Can't create file as it already exists: " + mappedFile);
        }
        mappedFile.createNewFile();
        this.mappedFile = new RandomAccessFile(mappedFile, "rw");
        this.buffer = new byte[recordLength];
        this.mappedFile.seek(0L);
        byte[] rl = String.valueOf(recordLength).getBytes();
        if (rl.length > 4) {
            throw new IOException("Length of record too long");
        }
        for (i = 0; i < rl.length; ++i) {
            this.mappedFile.write(rl[i]);
        }
        for (i = rl.length; i < 4; ++i) {
            this.mappedFile.write(32);
        }
        this.mappedFile.close();
    }

    public FileAsList(File mappedFile, boolean mutable) throws IOException {
        if (!mappedFile.exists()) {
            throw new IOException("Can't load mapped list as the file does not exist: " + mappedFile);
        }
        this.mappedFile = mutable ? new RandomAccessFile(mappedFile, "rw") : new RandomAccessFile(mappedFile, "r");
        StringBuffer sbuff = new StringBuffer();
        this.mappedFile.seek(0L);
        int i = 0;
        while ((long)i < Math.min(4L, mappedFile.length())) {
            char c = (char)this.mappedFile.readByte();
            sbuff.append(c);
            ++i;
        }
        this.buffer = new byte[Integer.parseInt(sbuff.substring(0).trim())];
    }

    public byte[] rawGet(int indx) {
        if (indx < 0 || indx >= this.size()) {
            throw new IndexOutOfBoundsException("Can't access element: " + indx + " of " + this.size());
        }
        if (indx != this.lastIndx) {
            long offset = this.fixOffset(indx * this.buffer.length);
            try {
                this.mappedFile.seek(offset);
                this.mappedFile.readFully(this.buffer);
            }
            catch (IOException ioe) {
                throw new NestedError(ioe, "Failed to seek for record");
            }
        }
        return this.buffer;
    }

    public Object get(int indx) {
        if (indx == this.lastIndx) {
            return this.lastRec;
        }
        byte[] buffer = this.rawGet(indx);
        this.lastRec = this.parseRecord(buffer);
        this.lastIndx = indx;
        return this.lastRec;
    }

    public int size() {
        if (this.sizeCache < 0) {
            try {
                this.sizeCache = (int)(this.unFixOffset(this.mappedFile.length()) / (long)this.buffer.length);
            }
            catch (IOException ioe) {
                throw new NestedError(ioe, "Can't read file length");
            }
        }
        return this.sizeCache;
    }

    public boolean add(Object o) {
        this.sizeCache = -1;
        try {
            this.generateRecord(this.buffer, o);
        }
        catch (NestedException ne) {
            throw new NestedError(ne, "Failed to write index");
        }
        try {
            this.mappedFile.seek(this.mappedFile.length());
            this.mappedFile.write(this.buffer);
        }
        catch (IOException ioe) {
            throw new NestedError(ioe, "Failed to write index");
        }
        return true;
    }

    public Object set(int indx, Object o) {
        try {
            this.generateRecord(this.buffer, o);
        }
        catch (NestedException ne) {
            throw new NestedError(ne, "Failed to write index");
        }
        try {
            this.mappedFile.seek(this.fixOffset(indx * this.buffer.length));
            this.mappedFile.write(this.buffer);
        }
        catch (IOException ioe) {
            throw new NestedError(ioe, "Failed to write index");
        }
        return null;
    }

    public void clear() {
        try {
            this.mappedFile.setLength(this.fixOffset(0L));
        }
        catch (IOException ioe) {
            throw new NestedError(ioe, "Could not truncate list");
        }
        this.commitedRecords = 0;
    }

    public void commit() {
        this.commitedRecords = this.size();
    }

    public void rollback() {
        try {
            this.mappedFile.setLength(this.fixOffset((long)this.commitedRecords * (long)this.buffer.length));
        }
        catch (Throwable t) {
            throw new NestedError(t, "Could not roll back. The index store will be in an inconsistent state and should be discarded. File: " + this.mappedFile);
        }
    }

    private long fixOffset(long offset) {
        return offset + 4L;
    }

    private long unFixOffset(long offset) {
        return offset - 4L;
    }

    protected abstract Object parseRecord(byte[] var1);

    protected abstract void generateRecord(byte[] var1, Object var2) throws NestedException;

    public abstract Comparator getComparator();

    public Iterator iterator() {
        return new Iterator(){
            int i = 0;

            public Object next() {
                return FileAsList.this.get(this.i++);
            }

            public boolean hasNext() {
                return this.i < FileAsList.this.size();
            }

            public void remove() {
            }
        };
    }
}

