/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.anhmmfile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;

public class LabeledFastaFormat
extends FastaFormat {
    public static final String DEFAULT = "LABELEDFASTA";
    public static final String PROPERTY_LABELS = "labels";
    public static final long serialVersionUID = 234234L;

    public boolean readSequence(BufferedReader bufferedReader, SymbolTokenization symbolTokenization, SeqIOListener seqIOListener) throws IllegalSymbolException, IOException, ParseException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("Premature stream end");
        }
        while (string.length() == 0) {
            string = bufferedReader.readLine();
            if (string != null) continue;
            throw new IOException("Premature stream end");
        }
        if (!string.startsWith(">")) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + string);
        }
        seqIOListener.startSequence();
        String string2 = string.substring(1).trim();
        seqIOListener.addSequenceProperty((Object)"description_line", (Object)string2);
        String string3 = new StringTokenizer(string2).nextToken();
        seqIOListener.setName(string3);
        boolean bl = this.readSequenceData(bufferedReader, symbolTokenization, seqIOListener);
        seqIOListener.endSequence();
        return !bl;
    }

    private boolean readSequenceData(BufferedReader bufferedReader, SymbolTokenization symbolTokenization, SeqIOListener seqIOListener) throws IOException, IllegalSymbolException {
        char[] cArray = new char[512];
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        StreamParser streamParser = symbolTokenization.parseStream(seqIOListener);
        Hashtable hashtable = new Hashtable();
        while (!bl) {
            bufferedReader.mark(cArray.length + 1);
            int n = bufferedReader.read(cArray, 0, cArray.length);
            if (n < 0) {
                bl2 = true;
                bl = true;
                continue;
            }
            int n2 = 0;
            int n3 = 0;
            while (!bl && n2 < n && cArray[n2] != '>') {
                for (n3 = n2; n3 < n && cArray[n3] != '\n' && cArray[n3] != '\r'; ++n3) {
                }
                if (string != "" || cArray[n2] == '#' || cArray[n2] == '?') {
                    string = this.parseLabel(string, hashtable, cArray, n2, n3);
                } else {
                    for (int i = n2; i < n3; ++i) {
                        if (cArray[i] == ' ') continue;
                        streamParser.characters(cArray, i, 1);
                    }
                }
                for (n2 = n3 + 1; n2 < n && (cArray[n2] == '\n' || cArray[n2] == '\r'); ++n2) {
                }
            }
            if (n2 >= n || cArray[n2] != '>') continue;
            try {
                bufferedReader.reset();
            }
            catch (IOException iOException) {
                throw new IOException("Can't reset: " + iOException.getMessage() + " parseStart=" + n2 + " bytesRead=" + n);
            }
            if (bufferedReader.skip(n2) != (long)n2) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            bl = true;
            string = "";
        }
        try {
            seqIOListener.addSequenceProperty((Object)PROPERTY_LABELS, hashtable);
        }
        catch (ParseException parseException) {
            System.err.println("Could not set sequence property");
            parseException.printStackTrace();
        }
        streamParser.close();
        return bl2;
    }

    protected String parseLabel(String string, Hashtable hashtable, char[] cArray, int n, int n2) {
        int n3 = n;
        String string2 = "";
        if (string == "" || !hashtable.containsKey(string)) {
            while (cArray[n3] != ' ') {
                string = string + cArray[n3];
                if (++n3 < n2) continue;
                return string;
            }
        }
        while (n3 < n2) {
            if (cArray[n3] != ' ') {
                string2 = string2 + cArray[n3];
            }
            ++n3;
        }
        if (hashtable.containsKey(string)) {
            String string3 = (String)hashtable.get(string) + string2;
            hashtable.put(string, string3);
        } else {
            hashtable.put(string, string2);
        }
        return string;
    }

    public void writeSequence(Sequence sequence, PrintStream printStream) throws IOException {
        int n = sequence.length();
        SymbolTokenization symbolTokenization = null;
        try {
            symbolTokenization = ProteinTools.getAlphabet().getTokenization("token");
        }
        catch (BioException bioException) {
            // empty catch block
        }
        Hashtable hashtable = LabeledFastaFormat.getLabels(sequence);
        printStream.print(">");
        printStream.println(this.describeSequence(sequence));
        for (int i = 0; i <= n / this.lineWidth; ++i) {
            printStream.print("  ");
            try {
                for (int j = i * this.lineWidth; j < Math.min((i + 1) * this.lineWidth, n); ++j) {
                    if (j % 10 == 0) {
                        printStream.print(" ");
                    }
                    printStream.print(symbolTokenization.tokenizeSymbol(sequence.symbolAt(j + 1)));
                }
                printStream.println();
            }
            catch (IllegalSymbolException illegalSymbolException) {
                printStream.println();
            }
            if (hashtable != null && hashtable.size() > 0) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)hashtable.get(string);
                    while (string.length() < 2) {
                        string = string + ' ';
                    }
                    printStream.print(string);
                    for (int j = i * this.lineWidth; j < Math.min((i + 1) * this.lineWidth, n); ++j) {
                        if (j % 10 == 0) {
                            printStream.print(" ");
                        }
                        printStream.print(string2.charAt(j));
                    }
                    printStream.println();
                }
            }
            printStream.println();
        }
    }

    public static Hashtable getLabels(Sequence sequence) {
        Hashtable hashtable = null;
        Annotation annotation = sequence.getAnnotation();
        if (annotation.containsProperty((Object)PROPERTY_LABELS)) {
            hashtable = (Hashtable)annotation.getProperty((Object)PROPERTY_LABELS);
        }
        return hashtable;
    }

    public static void setLabels(Sequence sequence, Hashtable hashtable) throws Exception {
        Annotation annotation = sequence.getAnnotation();
        if (annotation.containsProperty((Object)PROPERTY_LABELS)) {
            annotation.setProperty((Object)PROPERTY_LABELS, (Object)hashtable);
        }
    }
}

