/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.hmmdecode;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import se.ki.cgb.anhmmfile.LabeledFastaFormat;
import se.ki.cgb.labeledhmm.OutputHandler;

public class MacsimOutputHandler
extends OutputHandler {
    public void printSequence(Sequence sequence) throws IOException {
        String string;
        int n = sequence.length();
        String string2 = this.tag("accession", sequence.getName()) + "\n";
        string2 = string2 + this.tag("nid", sequence.getName()) + "\n";
        string2 = string2 + this.tag("ec", "0.0.0.0") + "\n";
        string2 = string2 + this.tag("group", "0") + "\n";
        Hashtable hashtable = LabeledFastaFormat.getLabels(sequence);
        Enumeration enumeration = hashtable.keys();
        String string3 = "";
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (!string3.startsWith("?")) continue;
            string = (String)hashtable.get(string3);
            switch (string3.charAt(1)) {
                case 'V': {
                    string2 = string2 + this.tag("ftable", this.getPrediction(string, "VITERBI")) + "\n";
                    break;
                }
                case 'M': {
                    string2 = string2 + this.tag("ftable", this.getPrediction(string, "MAX PLP")) + "\n";
                    break;
                }
                case 'O': {
                    string2 = string2 + this.tag("ftable", this.getPrediction(string, "OPT ACCURACY")) + "\n";
                    break;
                }
                case '0': {
                    string2 = string2 + this.tag("ftable", this.getPrediction(string, "1-BEST")) + "\n";
                    break;
                }
                case '1': {
                    string2 = string2 + this.tag("ftable", this.getPrediction(string, "2-BEST")) + "\n";
                    break;
                }
            }
        }
        string2 = string2 + this.tag("length", String.valueOf(n)) + "\n";
        string2 = string2 + this.tag("weight", "100") + "\n";
        string = this.tag("seq-name", sequence.getName()) + "\n";
        string = string + this.tag("seq-info", string2) + "\n";
        SymbolTokenization symbolTokenization = null;
        try {
            symbolTokenization = ProteinTools.getAlphabet().getTokenization("token");
        }
        catch (BioException bioException) {
            // empty catch block
        }
        String string4 = "";
        try {
            for (int i = 0; i < n; ++i) {
                string4 = string4 + symbolTokenization.tokenizeSymbol(sequence.symbolAt(i + 1));
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            string4 = string4 + "-";
        }
        string = string + this.tag("seq-data", string4) + "\n";
        string = this.tag("sequence", string, "seq-type", "Protein");
        System.out.println(string);
    }

    public String getPrediction(String string, String string2) {
        string = string.replaceAll("-", "");
        String string3 = "";
        int n = 0;
        int n2 = 37;
        for (int i = 0; i <= string.length(); ++i) {
            int n3;
            int n4 = n3 = i < string.length() ? (int)string.charAt(i) : 37;
            if (n2 == n3) continue;
            if (n2 == 99) {
                string3 = string3 + this.tag("fitem", this.tag("ftype", string2) + this.tag("fstart", "1") + this.tag("fstop", String.valueOf(i)) + this.tag("fcolor", "3") + this.tag("fscore", "0") + this.tag("fnote", "SIGNAL PEPTIDE")) + "\n";
            } else if (n2 == 79 || n2 == 111) {
                string3 = string3 + this.tag("fitem", this.tag("ftype", string2) + this.tag("fstart", String.valueOf(n)) + this.tag("fstop", String.valueOf(i)) + this.tag("fcolor", "1") + this.tag("fscore", "0") + this.tag("fnote", "TRANSLOCATED LOOP")) + "\n";
            } else if (n2 == 105) {
                string3 = string3 + this.tag("fitem", this.tag("ftype", string2) + this.tag("fstart", String.valueOf(n)) + this.tag("fstop", String.valueOf(i)) + this.tag("fcolor", "2") + this.tag("fscore", "0") + this.tag("fnote", "CYTOPLASMIC LOOP")) + "\n";
            } else if (n2 == 77) {
                string3 = string3 + this.tag("fitem", this.tag("ftype", string2) + this.tag("fstart", String.valueOf(n)) + this.tag("fstop", String.valueOf(i)) + this.tag("fcolor", "0") + this.tag("fscore", "0") + this.tag("fnote", "TRANSMEMBRANE")) + "\n";
            }
            if (n2 != 67) {
                n = i + 1;
            }
            n2 = n3;
        }
        return string3;
    }

    public void printInit() {
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<!DOCTYPE macsim SYSTEM \"http://www-bio3d-igbmc.u-strasbg.fr/macsim.dtd\">");
        System.out.println("<macsim>");
        System.out.println("<alignment>");
        System.out.println(this.tag("aln-name", "Phobius Predictions"));
    }

    public void printTail() {
        System.out.println("</alignment>");
        System.out.println("</macsim>");
    }

    protected String tag(String string, String string2) {
        return "<" + string + ">" + string2 + "</" + string + ">";
    }

    protected String tag(String string, String string2, String string3, String string4) {
        return "<" + string + " " + string3 + "=\"" + string4 + "\">" + string2 + "</" + string + ">";
    }
}

