/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.hmmdecode;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.seq.Sequence;
import se.ki.cgb.anhmmfile.AnReader;
import se.ki.cgb.anhmmfile.FastaOutputHandler;
import se.ki.cgb.hmmdecode.LongOutputHandler;
import se.ki.cgb.hmmdecode.MacsimOutputHandler;
import se.ki.cgb.hmmdecode.Run;
import se.ki.cgb.hmmdecode.ShortOutputHandler;
import se.ki.cgb.labeledhmm.AlignedDP;
import se.ki.cgb.labeledhmm.Constraints;
import se.ki.cgb.labeledhmm.OutputHandler;

public class Phobius
extends Run {
    public static String PH_VER = "1.04";

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Phobius.printGreater();
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = null;
        URL uRL = null;
        String string2 = "";
        OutputHandler.setInstance(new LongOutputHandler());
        Constraints constraints = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h") || stringArray[i].equals("-?")) {
                Phobius.printUsage();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-f")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-v")) {
                bl6 = true;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-m")) {
                bl5 = true;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-o")) {
                bl4 = true;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-n")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-p") || stringArray[i].equals("-poly")) {
                bl = true;
                bl4 = true;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-s") || stringArray[i].equals("-short")) {
                OutputHandler.setInstance(new ShortOutputHandler());
                continue;
            }
            if (stringArray[i].equals("-l") || stringArray[i].equals("-long")) {
                OutputHandler.setInstance(new LongOutputHandler());
                continue;
            }
            if (stringArray[i].equals("-r") || stringArray[i].equals("-raw")) {
                OutputHandler.setInstance(new FastaOutputHandler());
                continue;
            }
            if (stringArray[i].equals("-x") || stringArray[i].equals("-xml")) {
                OutputHandler.setInstance(new MacsimOutputHandler());
                continue;
            }
            if (stringArray[i].equals("-c")) {
                if (constraints == null) {
                    constraints = new Constraints();
                }
                while (i + 1 < stringArray.length && constraints.setConstraint(stringArray[i + 1])) {
                    ++i;
                }
                continue;
            }
            if (n == 0) {
                string2 = stringArray[i];
            }
            ++n;
        }
        if (n > 1) {
            System.err.println("Too many arguments given");
            System.exit(-1);
        }
        bl3 |= bl2;
        if (string == null) {
            ClassLoader classLoader = Phobius.class.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if ((uRL = classLoader.getResource("phobius.model")) == null) {
                System.err.println("Could not locate phobius.model in the installation directory");
                System.err.println("Please copy you licenced version of the file to the same directory");
                System.err.println("the jphobius script.");
                System.exit(-1);
            }
        }
        MarkovModel markovModel = null;
        try {
            if (string == null) {
                object = new BufferedReader(new InputStreamReader(uRL.openStream()));
            } else {
                System.err.println("Read ANHMM File " + string);
                object = new BufferedReader(new FileReader(string));
            }
            markovModel = AnReader.getInstance().parseStream((BufferedReader)object);
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            System.err.println("Error ocured while reading the modelfile.");
            System.err.println("Got the following StackTrace:");
            exception.printStackTrace();
            System.exit(-1);
        }
        object = new AlignedDP(markovModel, constraints);
        Sequence[] sequenceArray = Phobius.readSequences(string2, bl);
        ((AlignedDP)((Object)object)).go(sequenceArray, bl, bl4, bl5, bl6, 0, bl3 ? 1 : 0);
        System.exit(0);
    }

    private static void printUsage() {
        System.err.println("usage:\t jphobius [-poly] [-l] [-s] [-r ] input");
        System.err.println("              cat input | jphobius [-poly] [-l] [-s] [-r ]");
        System.err.println("              jphobius -h");
        System.err.println();
        System.err.println("              where input is a fasta file");
        System.err.println();
        System.err.println("option\t-poly Prediction of a fasta alignment");
        System.err.println("option\t-l    Long output (default)");
        System.err.println("option\t-s    Short output");
        System.err.println("option\t-x    Macsim xml output");
        System.err.println("option\t-r    Raw output (anhmm style)");
        System.err.println("option\t-m    Maximum PLP prediction");
        System.err.println("option\t-o    Optimal accuracy prediction");
        System.err.println("option\t-v    Viterbi prediction");
        System.err.println("option\t-n    1-best prediction");
        System.err.println();
    }

    private static void printGreater() {
        System.err.println("jPhobius version " + PH_VER);
        System.err.println("based on Phobius (c) Lukas Kall, Anders Krogh and Erik Sonnhammer 2004");
        System.err.println("and HomologHMM ver " + HH_VER + " (c) Lukas Kall 2005");
    }
}

