/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.hmmdecode;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import se.ki.cgb.anhmmfile.AnReader;
import se.ki.cgb.anhmmfile.FastaOutputHandler;
import se.ki.cgb.anhmmfile.LabeledFastaFormat;
import se.ki.cgb.anhmmfile.LabeledFastaParser;
import se.ki.cgb.labeledhmm.AlignedDP;
import se.ki.cgb.labeledhmm.Constraints;
import se.ki.cgb.labeledhmm.OutputHandler;
import se.ki.cgb.labeledhmm.WeightScheme;

public class Run {
    protected static String HH_VER = "1.04";

    private static void printUsage() {
        System.err.println("usage:\t homologhmm [-a] [-v] [-m] [-w (f|c|g|u|i)] modelfile input");
        System.err.println("              cat input | homologhmm [-a] [-v] [-m] [-w (f|c|g|u|i)] modelfile");
        System.err.println("              homologhmm [-a] [-w (f|c|g|u|i)] -pw input");
        System.err.println("              homologhmm -h");
        System.err.println("option\t-a    Treat input file as an aligned fasta and do common prediction");
        System.err.println("option\t-m    Maximum PLP prediction");
        System.err.println("option\t-o    Optimal accuracy prediction (default)");
        System.err.println("option\t-v    Viterbi prediction");
        System.err.println("option\t-w f  Select flat weighting scheme");
        System.err.println("option\t-w c  Select Henikoff-Henikoff weighting scheme only taking (conserved) columns without gaps in account");
        System.err.println("option\t-w u  Select Henikoff-Henikoff weighting scheme ignoring gaps and columns where query sequence contain gap");
        System.err.println("option\t-w g  Select Henikoff-Henikoff weighting scheme counting gaps as an amino acid");
        System.err.println("option\t-w i  Select Henikoff-Henikoff weighting scheme ignoring gaps");
        System.err.println("option\t-w e  Select Henikoff-Henikoff weighting scheme ala HMMer ignoring gaps and scaling with true sequence length (default)");
        System.err.println("option\t-pw   Print Weights and exit");
        System.err.println("option\t-plp  Print posterior label probabilities in first sequence coordinates");
        System.err.println("option\t-aplp Print posterior label probabilities in alignment coordinates");
        System.err.println();
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Run.printGreater();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        int n2 = 0;
        Constraints constraints = null;
        int n3 = 0;
        String string = "";
        String string2 = "";
        String string3 = " ";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h") || stringArray[i].equals("-?")) {
                Run.printUsage();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-v")) {
                bl5 = true;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-m")) {
                bl4 = true;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-N")) {
                try {
                    n2 = Integer.parseInt(stringArray[i + 1]);
                    ++i;
                }
                catch (Exception exception) {
                    n2 = 1;
                }
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-o")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-a")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-w")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-plp")) {
                n = 1;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-aplp")) {
                n = 3;
                bl = true;
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("-pw")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i].equals("-c")) {
                if (constraints == null) {
                    constraints = new Constraints();
                }
                while (constraints.setConstraint(stringArray[i + 1])) {
                    ++i;
                }
                continue;
            }
            if (n3 == 0) {
                string = stringArray[i];
            }
            if (n3 == 1) {
                string2 = stringArray[i];
            }
            ++n3;
        }
        bl3 |= bl2;
        if (!bl6 && (n3 == 0 || n3 > 2) || bl6 && n3 > 1) {
            System.err.println("Wrong number of arguments: " + n3);
            Run.printUsage();
            System.exit(-1);
        }
        switch (Character.toUpperCase(string3.charAt(0))) {
            case 'F': {
                WeightScheme.selectScheme(0);
                break;
            }
            case 'U': {
                WeightScheme.selectScheme(2);
                break;
            }
            case 'G': {
                WeightScheme.selectScheme(1);
                break;
            }
            case 'C': {
                WeightScheme.selectScheme(3);
                break;
            }
            case 'E': {
                WeightScheme.selectScheme(4);
                break;
            }
            case 'I': {
                WeightScheme.selectScheme(5);
                break;
            }
            case ' ': {
                break;
            }
            default: {
                System.err.println("Wrong weighting scheme type: " + string3);
                Run.printUsage();
                System.exit(-1);
            }
        }
        if (bl6) {
            Sequence[] sequenceArray = Run.readSequences(string, true);
            Run.printWeights(sequenceArray);
            System.exit(0);
        }
        MarkovModel markovModel = null;
        try {
            object = new BufferedReader(new FileReader(string));
            System.err.println("Read ANHMM File " + string);
            markovModel = AnReader.getInstance().parseStream((BufferedReader)object);
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            System.err.println("Error ocured while reading the file: " + string);
            System.err.println("Got the following StackTrace:");
            exception.printStackTrace();
            System.exit(-1);
        }
        object = new AlignedDP(markovModel, constraints);
        Sequence[] sequenceArray = Run.readSequences(string2, bl);
        OutputHandler.setInstance(new FastaOutputHandler());
        ((AlignedDP)((Object)object)).go(sequenceArray, bl, bl3, bl4, bl5, n, n2);
        System.exit(0);
    }

    public static Sequence[] readSequences(String string, boolean bl) {
        LabeledFastaFormat labeledFastaFormat = new LabeledFastaFormat();
        Sequence[] sequenceArray = null;
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = string.length() == 0 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(string));
            LabeledFastaParser.Factory factory = new LabeledFastaParser.Factory(SimpleSequenceBuilder.FACTORY);
            SymbolTokenization symbolTokenization = ProteinTools.getAlphabet().getTokenization("token");
            StreamReader streamReader = new StreamReader(bufferedReader, (SequenceFormat)labeledFastaFormat, symbolTokenization, (SequenceBuilderFactory)factory);
            ArrayList<Sequence> arrayList = new ArrayList<Sequence>();
            while (streamReader.hasNext()) {
                arrayList.add(streamReader.nextSequence());
            }
            sequenceArray = new Sequence[arrayList.size()];
            arrayList.toArray(sequenceArray);
        }
        catch (Exception exception) {
            System.err.println("Error ocured while reading the file: " + string);
            System.err.println("Got the following StackTrace:");
            exception.printStackTrace();
            System.exit(-1);
        }
        if (bl && sequenceArray.length > 1) {
            for (int i = 1; i < sequenceArray.length; ++i) {
                if (sequenceArray[i].length() == sequenceArray[0].length()) continue;
                System.err.println("Error ocured while reading the file: " + string);
                System.err.println("Difference in length between 1st and " + i + "rd sequece in " + string);
                System.exit(-1);
            }
        }
        return sequenceArray;
    }

    private static void printGreater() {
        System.err.println("HomologHMM version " + HH_VER);
        System.err.println("(c) Lukas Kall 2005");
    }

    static void printWeights(Sequence[] sequenceArray) {
        double[] dArray = WeightScheme.getInstance().getWeights(sequenceArray);
        for (int i = 0; i < sequenceArray.length; ++i) {
            System.out.println(sequenceArray[i].getName() + " " + dArray[i] + " " + dArray[i]);
        }
    }
}

