/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.StatePath;
import org.biojava.bio.dp.onehead.SingleDP;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.dp.onehead.SmallCursor;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import se.ki.cgb.anhmmfile.LabeledFastaFormat;
import se.ki.cgb.labeledhmm.AlignedMatrixCursor;
import se.ki.cgb.labeledhmm.AlignmentCursor;
import se.ki.cgb.labeledhmm.Constraints;
import se.ki.cgb.labeledhmm.FBMatrix;
import se.ki.cgb.labeledhmm.Hypothesis;
import se.ki.cgb.labeledhmm.LabelProbMatrix;
import se.ki.cgb.labeledhmm.OutputHandler;
import se.ki.cgb.labeledhmm.WeightScheme;

public class AlignedDP
extends SingleDP {
    private static final Symbol gap = AlphabetManager.getGapSymbol();
    protected final HashMap rawEmissions = new HashMap();
    protected double[][] rawTransitionScores = null;
    char[] labels;
    int[][] labelIx2states;
    int[] state2labelIx;
    char[] state2label;
    Constraints constraints = null;
    public static final long serialVersionUID = 9439139L;

    protected void mapLabels(State[] stateArray) {
        Iterator<Integer> iterator;
        String string = "";
        HashMap<String, Iterator<Integer>> hashMap = new HashMap<String, Iterator<Integer>>();
        for (int i = 0; i < this.getDotStatesIndex(); ++i) {
            try {
                string = (String)stateArray[i].getAnnotation().getProperty((Object)"Label");
                if (!hashMap.containsKey(string)) {
                    iterator = new HashSet();
                    ((HashSet)((Object)iterator)).add(new Integer(i));
                    hashMap.put(string, iterator);
                    continue;
                }
                iterator = (HashSet)hashMap.get(string);
                ((HashSet)((Object)iterator)).add(new Integer(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.labels = new char[hashMap.size()];
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.labels[n++] = ((String)iterator.next()).charAt(0);
        }
        this.labelIx2states = new int[hashMap.size()][];
        for (n = 0; n < this.labels.length; ++n) {
            HashSet hashSet = (HashSet)hashMap.get("" + this.labels[n]);
            ArrayList arrayList2 = new ArrayList(hashSet);
            Collections.sort(arrayList2);
            iterator = arrayList2.iterator();
            this.labelIx2states[n] = new int[hashSet.size()];
            int n2 = 0;
            while (iterator.hasNext()) {
                this.labelIx2states[n][n2++] = (Integer)iterator.next();
            }
        }
        this.state2labelIx = new int[this.getDotStatesIndex()];
        this.state2label = new char[this.getDotStatesIndex()];
        for (int i = 0; i < this.labels.length; ++i) {
            for (int j = 0; j < this.labelIx2states[i].length; ++j) {
                this.state2labelIx[this.labelIx2states[i][j]] = i;
                this.state2label[this.labelIx2states[i][j]] = this.labels[i];
            }
        }
    }

    public String doHomologyViterbi(Sequence[] sequenceArray, double[] dArray) throws Exception {
        double d;
        int n;
        double d2;
        Object[] objectArray;
        int n2;
        this.lockModel();
        AlignmentCursor alignmentCursor = new AlignmentCursor(this.getStates(), sequenceArray, 1);
        State[] stateArray = this.getStates();
        int[][] nArray = this.getForwardTransitions();
        double[][] dArray2 = this.getForwardTransitionScores(ScoreType.PROBABILITY);
        int n3 = stateArray.length;
        Object[] objectArray2 = new BackPointer[n3];
        BackPointer[] backPointerArray = new BackPointer[n3];
        Object object = alignmentCursor.currentCol();
        Object object2 = alignmentCursor.lastCol();
        for (n2 = 0; n2 < this.getDotStatesIndex(); ++n2) {
            if (stateArray[n2] == this.getModel().magicalState()) {
                object2[n2] = 0.0;
                object[n2] = 0.0;
                objectArray2[n2] = backPointerArray[n2] = new BackPointer(stateArray[n2]);
                continue;
            }
            object2[n2] = Double.NEGATIVE_INFINITY;
            object[n2] = Double.NEGATIVE_INFINITY;
        }
        for (n2 = this.getDotStatesIndex(); n2 < n3; ++n2) {
            objectArray = nArray[n2];
            double[] dArray3 = dArray2[n2];
            d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            n = -1;
            for (int i = 0; i < objectArray.length; ++i) {
                double d4 = dArray3[i];
                int n4 = objectArray[i];
                d = object[n4];
                double d5 = d4 + d;
                if (!(d5 > d2)) continue;
                d2 = d5;
                n = n4;
                d3 = d4;
            }
            if (n != -1) {
                object[n2] = object2[n2] = d2;
                objectArray2[n2] = backPointerArray[n2] = new BackPointer(stateArray[n2], backPointerArray[n], d3);
                continue;
            }
            object2[n2] = Double.NEGATIVE_INFINITY;
            object[n2] = Double.NEGATIVE_INFINITY;
            backPointerArray[n2] = null;
            objectArray2[n2] = null;
        }
        while (alignmentCursor.canAdvance()) {
            alignmentCursor.advance();
            object = this.getProfileEmission(alignmentCursor.currentResidues(), dArray);
            object2 = alignmentCursor.currentCol();
            double[] dArray4 = alignmentCursor.lastCol();
            for (int i = 0; i < stateArray.length; ++i) {
                double d6 = i < this.getDotStatesIndex() ? object[i] : 0.0;
                int[] nArray2 = nArray[i];
                double[] dArray5 = dArray2[i];
                if (d6 == Double.NEGATIVE_INFINITY) {
                    object2[i] = Double.NEGATIVE_INFINITY;
                    backPointerArray[i] = null;
                    continue;
                }
                double d7 = Double.NEGATIVE_INFINITY;
                double d8 = Double.NEGATIVE_INFINITY;
                int n5 = -1;
                for (int j = 0; j < nArray2.length; ++j) {
                    int n6 = nArray2[j];
                    double d9 = dArray5[j];
                    Object object3 = i < this.getDotStatesIndex() ? dArray4[n6] : (Object)object2[n6];
                    double d10 = d9 + object3;
                    if (!(d10 > d7)) continue;
                    d7 = d10;
                    n5 = n6;
                    d8 = d9;
                }
                if (n5 != -1) {
                    object2[i] = d7 + d6;
                    backPointerArray[i] = new BackPointer(stateArray[i], i < this.getDotStatesIndex() ? objectArray2[n5] : backPointerArray[n5], d8 + d6);
                    continue;
                }
                object2[i] = Double.NEGATIVE_INFINITY;
                backPointerArray[i] = null;
            }
            objectArray = backPointerArray;
            backPointerArray = objectArray2;
            objectArray2 = objectArray;
        }
        object = null;
        object2 = alignmentCursor.currentCol();
        int[] nArray3 = nArray[0];
        double d11 = Double.NEGATIVE_INFINITY;
        d2 = Double.NEGATIVE_INFINITY;
        int n7 = -1;
        for (int i = 0; i < nArray3.length; ++i) {
            double d12 = 0.0;
            n = nArray3[i];
            double d13 = object2[n];
            d = d12 + d13;
            if (!(d > d11)) continue;
            d11 = d;
            n7 = n;
            d2 = d12;
        }
        if (n7 != -1) {
            object = new BackPointer(stateArray[0], objectArray2[n7], d2);
        }
        object2 = new StringBuffer(sequenceArray[0].seqString());
        int n8 = ((StringBuffer)object2).length() - 1;
        while (object.state instanceof MagicalState) {
            object = object.back;
        }
        while (n8 >= 0) {
            while (n8 >= 0 && ((StringBuffer)object2).charAt(n8) == '-') {
                --n8;
            }
            while (n8 >= 0 && object.state instanceof DotState) {
                object = object.back;
            }
            if (n8 >= 0 && object.state instanceof SimpleEmissionState) {
                String string;
                try {
                    string = (String)object.state.getAnnotation().getProperty((Object)"Label");
                }
                catch (Exception exception) {
                    string = "X";
                }
                ((StringBuffer)object2).setCharAt(n8, string.charAt(0));
            }
            --n8;
            object = object.back;
        }
        this.unlockModel();
        return ((StringBuffer)object2).toString();
    }

    public void go(Sequence[] sequenceArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2) throws Exception {
        Object[] objectArray;
        Object object;
        boolean bl5 = bl2 || bl3 || n > 0;
        LabelProbMatrix labelProbMatrix = null;
        Object object2 = null;
        double[] dArray = null;
        if (bl) {
            dArray = WeightScheme.getInstance().getWeights(sequenceArray);
        }
        if (this.constraints != null) {
            this.constraints.mapConstraints(sequenceArray[0].length(), this.getDotStatesIndex(), this.labels, this.labelIx2states);
        }
        OutputHandler.getInstance().printInit();
        for (int i = 0; sequenceArray.length > i; ++i) {
            object = sequenceArray[i];
            if (this.constraints != null) {
                this.constraints.adjust((Sequence)object);
            }
            if (object2 == null) {
                object2 = object;
            }
            objectArray = new Sequence[]{object};
            LabelProbMatrix labelProbMatrix2 = null;
            if (bl5) {
                labelProbMatrix2 = this.calcPosteriorLabelProbability((SymbolList[])objectArray);
            }
            if (!bl) {
                Hashtable<String, String> hashtable;
                if (bl5) {
                    labelProbMatrix2.normalize();
                }
                if ((hashtable = LabeledFastaFormat.getLabels((Sequence)object)) == null) {
                    hashtable = new Hashtable<String, String>();
                }
                if (bl3) {
                    hashtable.put("?M", this.maxPLP(labelProbMatrix2));
                }
                if (bl4) {
                    hashtable.put("?V", this.viterbi((SymbolList[])objectArray));
                }
                if (bl2) {
                    hashtable.put("?O", this.optimalPLP(labelProbMatrix2));
                }
                if (n2 > 0) {
                    String[] stringArray = this.doNbest((Sequence[])objectArray, null, n2, false);
                    for (int j = 0; j < stringArray.length; ++j) {
                        hashtable.put("?" + j, stringArray[j]);
                    }
                }
                if (n > 0) {
                    labelProbMatrix2.printPLP(System.out, true);
                    continue;
                }
                LabeledFastaFormat.setLabels((Sequence)object, hashtable);
                OutputHandler.getInstance().printSequence((Sequence)object);
                continue;
            }
            if (labelProbMatrix == null) {
                if (!bl5) continue;
                labelProbMatrix = labelProbMatrix2;
                labelProbMatrix.weight(dArray[i]);
                continue;
            }
            if (!bl5) continue;
            labelProbMatrix.join(labelProbMatrix2, dArray[i]);
        }
        if (bl) {
            if (bl5) {
                labelProbMatrix.normalize();
            }
            if ((object = LabeledFastaFormat.getLabels(object2)) == null) {
                object = new Hashtable();
            }
            if (bl3) {
                ((Hashtable)object).put("?M", this.maxPLP(labelProbMatrix));
            }
            if (bl2) {
                ((Hashtable)object).put("?O", this.optimalPLP(labelProbMatrix));
            }
            if (bl4) {
                ((Hashtable)object).put("?V", this.doHomologyViterbi(sequenceArray, dArray));
            }
            if (n2 > 0) {
                objectArray = this.doNbest(sequenceArray, dArray, n2, true);
                for (int i = 0; i < objectArray.length; ++i) {
                    ((Hashtable)object).put("?" + i, objectArray[i]);
                }
            }
            if (n > 0) {
                labelProbMatrix.printPLP(System.out, (n & 2) == 0);
            } else {
                LabeledFastaFormat.setLabels((Sequence)object2, (Hashtable)object);
                OutputHandler.getInstance().printSequence((Sequence)object2);
            }
        }
        OutputHandler.getInstance().printTail();
    }

    public String viterbi(SymbolList[] symbolListArray) throws Exception {
        StatePath statePath = this.viterbi(symbolListArray, ScoreType.PROBABILITY);
        String string = "";
        Iterator iterator = statePath.symbolListForLabel(StatePath.STATES).iterator();
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            try {
                string = string + (String)state.getAnnotation().getProperty((Object)"Label");
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public double[] getEmission(Symbol symbol, ScoreType scoreType) throws IllegalSymbolException {
        HashMap hashMap;
        if (scoreType == ScoreType.PROBABILITY) {
            hashMap = this.emissionsProb;
        } else if (scoreType == ScoreType.ODDS) {
            hashMap = this.emissionsOdds;
        } else if (scoreType == ScoreType.NULL_MODEL) {
            hashMap = this.emissionsNull;
        } else {
            throw new BioError("Unknown ScoreType object: " + scoreType);
        }
        double[] dArray = (double[])hashMap.get(symbol);
        if (dArray == null) {
            int n = this.getDotStatesIndex();
            dArray = new double[n];
            State[] stateArray = this.getStates();
            dArray[0] = symbol == AlphabetManager.getGapSymbol() ? 0.0 : Double.NEGATIVE_INFINITY;
            for (int i = 1; i < n; ++i) {
                EmissionState emissionState = (EmissionState)stateArray[i];
                Distribution distribution = emissionState.getDistribution();
                double d = scoreType.calculateScore(distribution, symbol);
                dArray[i] = d > 0.0 ? Math.log(d) : Double.NEGATIVE_INFINITY;
            }
            hashMap.put(symbol, dArray);
        }
        return dArray;
    }

    public double[] getProfileEmission(Symbol[] symbolArray, double[] dArray) throws IllegalSymbolException {
        int n;
        int n2 = this.getDotStatesIndex();
        double[] dArray2 = new double[n2];
        int n3 = 0;
        double d = 0.0;
        for (n = 0; n < symbolArray.length; ++n) {
            if (symbolArray[n].getName().length() < 3 || symbolArray[n] == AlphabetManager.getGapSymbol()) continue;
            ++n3;
            d += dArray[n];
            double[] dArray3 = this.getRawEmission(symbolArray[n]);
            for (int i = 0; i < n2; ++i) {
                if (dArray3[i] > 0.0) {
                    int n4 = i;
                    dArray2[n4] = dArray2[n4] + Math.log(dArray3[i]) * dArray[n];
                    continue;
                }
                dArray2[i] = Double.NEGATIVE_INFINITY;
            }
        }
        if (n3 < symbolArray.length) {
            if (n3 > 0) {
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = dArray2[n] / d;
                }
            } else {
                for (n = 1; n < n2; ++n) {
                    dArray2[n] = Double.NEGATIVE_INFINITY;
                }
                dArray2[0] = 0.0;
            }
        }
        return dArray2;
    }

    public double[] getRawProfileEmission(Symbol[] symbolArray, double[] dArray) throws IllegalSymbolException {
        int n;
        int n2 = this.getDotStatesIndex();
        double[] dArray2 = new double[n2];
        Arrays.fill(dArray2, 1.0);
        int n3 = 0;
        double d = 0.0;
        for (n = 0; n < symbolArray.length; ++n) {
            if (symbolArray[n].getName().length() < 3 || symbolArray[n] == AlphabetManager.getGapSymbol()) continue;
            ++n3;
            d += dArray[n];
            double[] dArray3 = this.getRawEmission(symbolArray[n]);
            for (int i = 0; i < n2; ++i) {
                if (dArray3[i] > 0.0) {
                    int n4 = i;
                    dArray2[n4] = dArray2[n4] * Math.pow(dArray3[i], dArray[n]);
                } else {
                    dArray2[i] = 0.0;
                }
                if (dArray3[i] == dArray2[i]) continue;
                n3 += 0;
            }
        }
        if (d > 0.0) {
            d = 1.0 / d;
        }
        if (n3 < symbolArray.length) {
            if (n3 > 0) {
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = Math.pow(dArray2[n], d);
                }
            } else {
                for (n = 1; n < n2; ++n) {
                    dArray2[n] = 0.0;
                }
                dArray2[0] = 1.0;
            }
        }
        return dArray2;
    }

    public double[] getRawEmission(Symbol symbol) throws IllegalSymbolException {
        double[] dArray = (double[])this.rawEmissions.get(symbol);
        if (dArray == null) {
            int n = this.getDotStatesIndex();
            dArray = new double[n];
            State[] stateArray = this.getStates();
            if (symbol == gap) {
                dArray[0] = 1.0;
            } else {
                dArray[0] = 0.0;
                for (int i = 1; i < n; ++i) {
                    EmissionState emissionState = (EmissionState)stateArray[i];
                    Distribution distribution = emissionState.getDistribution();
                    dArray[i] = distribution.getWeight(symbol);
                    if (!Double.isNaN(dArray[i])) continue;
                    dArray[i] = symbol instanceof AtomicSymbol ? 0.0 : 0.05;
                }
            }
            this.rawEmissions.put(symbol, dArray);
        }
        return dArray;
    }

    public double[][] forwardTransitionRawScores(MarkovModel markovModel, State[] stateArray, int[][] nArray) throws IllegalSymbolException {
        if (this.rawTransitionScores != null) {
            return this.rawTransitionScores;
        }
        int n = stateArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            State state = stateArray[i];
            dArrayArray[i] = new double[nArray[i].length];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                try {
                    dArrayArray[i][j] = markovModel.getWeights(stateArray[nArray[i][j]]).getWeight((Symbol)state);
                    continue;
                }
                catch (IllegalSymbolException illegalSymbolException) {
                    throw new BioError((Throwable)illegalSymbolException, "Transition listed in transitions array has dissapeared.");
                }
            }
        }
        this.rawTransitionScores = dArrayArray;
        return dArrayArray;
    }

    public static double[][] backwardTransitionRawScores(MarkovModel markovModel, State[] stateArray, int[][] nArray) throws IllegalSymbolException {
        int n = stateArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            State state = stateArray[i];
            dArrayArray[i] = new double[nArray[i].length];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                try {
                    dArrayArray[i][j] = markovModel.getWeights(state).getWeight((Symbol)stateArray[nArray[i][j]]);
                    continue;
                }
                catch (IllegalSymbolException illegalSymbolException) {
                    throw new BioError((Throwable)illegalSymbolException, "Transition listed in transitions array has dissapeared");
                }
            }
        }
        return dArrayArray;
    }

    public FBMatrix forwardbackwardMatrix(SymbolList symbolList) throws IllegalSymbolException {
        int n;
        int n2;
        int n3;
        FBMatrix fBMatrix = new FBMatrix(symbolList, this.getDotStatesIndex());
        int n4 = fBMatrix.getUngappedLen();
        int[] nArray = fBMatrix.ung2g;
        double[] dArray = new double[this.getStates().length];
        double[] dArray2 = new double[this.getStates().length];
        double[] dArray3 = new double[this.getStates().length];
        State[] stateArray = this.getStates();
        int[][] nArray2 = this.getForwardTransitions();
        double[][] dArray4 = this.forwardTransitionRawScores(this.getModel(), stateArray, nArray2);
        int[][] nArray3 = this.getBackwardTransitions();
        double[][] dArray5 = AlignedDP.backwardTransitionRawScores(this.getModel(), stateArray, nArray3);
        int[] nArray4 = nArray3[0];
        double[] dArray6 = dArray5[0];
        for (n3 = 0; n3 < nArray4.length; ++n3) {
            if (nArray4[n3] == 0) continue;
            dArray[nArray4[n3]] = dArray6[n3];
        }
        for (n2 = this.getDotStatesIndex(); n2 < stateArray.length; ++n2) {
            nArray4 = nArray3[n2];
            dArray6 = dArray5[n2];
            for (n3 = 0; n3 < nArray4.length; ++n3) {
                if (nArray4[n3] == 0) continue;
                int n5 = nArray4[n3];
                dArray[n5] = dArray[n5] + dArray6[n3] * dArray[n2];
            }
        }
        int n6 = nArray[0];
        double[] dArray7 = this.getRawEmission(symbolList.symbolAt(n6 + 1));
        for (n2 = 0; n2 < this.getDotStatesIndex(); ++n2) {
            int n7 = n2;
            dArray[n7] = dArray[n7] * dArray7[n2];
        }
        if (this.constraints != null) {
            this.constraints.constrain(n6, dArray);
        }
        double d = 0.0;
        for (n2 = 1; n2 < this.getDotStatesIndex(); ++n2) {
            d += dArray[n2];
        }
        fBMatrix.c[0] = 1.0 / d;
        for (n2 = 1; n2 < this.getDotStatesIndex(); ++n2) {
            fBMatrix.alfa[0][n2] = dArray[n2] * fBMatrix.c[0];
        }
        System.arraycopy(fBMatrix.alfa[0], 0, dArray, 0, this.getDotStatesIndex());
        for (n2 = this.getDotStatesIndex(); n2 < stateArray.length; ++n2) {
            nArray4 = nArray2[n2];
            dArray6 = dArray4[n2];
            dArray[n2] = 0.0;
            for (n3 = 0; n3 < nArray4.length; ++n3) {
                if (nArray4[n3] == 0) continue;
                int n8 = n2;
                dArray[n8] = dArray[n8] + dArray6[n3] * dArray[nArray4[n3]];
            }
        }
        for (n = 1; n < n4; ++n) {
            n6 = nArray[n];
            double[] dArray8 = dArray2;
            dArray2 = dArray;
            dArray = dArray8;
            Arrays.fill(dArray, 0.0);
            dArray7 = this.getRawEmission(symbolList.symbolAt(n6 + 1));
            for (n2 = 0; n2 < this.getDotStatesIndex(); ++n2) {
                nArray4 = nArray2[n2];
                dArray6 = dArray4[n2];
                for (n3 = 0; n3 < nArray4.length; ++n3) {
                    if (nArray4[n3] == 0) continue;
                    int n9 = n2;
                    dArray[n9] = dArray[n9] + dArray6[n3] * dArray2[nArray4[n3]];
                }
                int n10 = n2;
                dArray[n10] = dArray[n10] * dArray7[n2];
            }
            if (this.constraints != null) {
                this.constraints.constrain(n6, dArray);
            }
            d = 0.0;
            for (n2 = 1; n2 < this.getDotStatesIndex(); ++n2) {
                d += dArray[n2];
            }
            fBMatrix.c[n] = 1.0 / d;
            for (n2 = 1; n2 < this.getDotStatesIndex(); ++n2) {
                fBMatrix.alfa[n][n2] = dArray[n2] * fBMatrix.c[n];
            }
            System.arraycopy(fBMatrix.alfa[n], 0, dArray, 0, this.getDotStatesIndex());
            for (n2 = this.getDotStatesIndex(); n2 < stateArray.length; ++n2) {
                nArray4 = nArray2[n2];
                dArray6 = dArray4[n2];
                for (n3 = 0; n3 < nArray4.length; ++n3) {
                    if (nArray4[n3] == 0) continue;
                    int n11 = n2;
                    dArray[n11] = dArray[n11] + dArray6[n3] * dArray[nArray4[n3]];
                }
            }
        }
        nArray4 = nArray2[0];
        d = 0.0;
        for (n3 = 0; n3 < nArray4.length; ++n3) {
            if (nArray4[n3] == 0) continue;
            d += dArray[nArray4[n3]];
        }
        fBMatrix.c[n4] = 1.0 / d;
        double d2 = 0.0;
        for (n = 0; n <= n4; ++n) {
            d2 -= Math.log(fBMatrix.c[n]);
        }
        fBMatrix.score = d2;
        nArray4 = nArray2[0];
        dArray6 = dArray4[0];
        for (n3 = 0; n3 < nArray4.length; ++n3) {
            if (nArray4[n3] == 0) continue;
            dArray3[nArray4[n3]] = 1.0;
        }
        for (n2 = stateArray.length - 1; n2 >= this.getDotStatesIndex(); --n2) {
            nArray4 = nArray2[n2];
            dArray6 = dArray4[n2];
            for (n3 = nArray4.length - 1; n3 >= 0; --n3) {
                if (nArray4[n3] == 0) continue;
                int n12 = nArray4[n3];
                dArray3[n12] = dArray3[n12] + dArray6[n3] * dArray3[n2];
            }
        }
        if (this.constraints != null) {
            this.constraints.constrain(nArray[n4 - 1], dArray3);
        }
        for (n2 = 1; n2 < this.getDotStatesIndex(); ++n2) {
            fBMatrix.beta[n4 - 1][n2] = dArray3[n2] * fBMatrix.c[n4 - 1] * fBMatrix.c[n4];
        }
        for (n = n4 - 2; n >= 0; --n) {
            System.arraycopy(fBMatrix.beta[n + 1], 0, dArray3, 0, this.getDotStatesIndex());
            int n13 = nArray[n + 1];
            dArray7 = this.getRawEmission(symbolList.symbolAt(n13 + 1));
            for (n2 = stateArray.length - 1; n2 >= this.getDotStatesIndex(); --n2) {
                nArray4 = nArray3[n2];
                dArray6 = dArray5[n2];
                dArray3[n2] = 0.0;
                for (n3 = nArray4.length - 1; n3 >= 0; --n3) {
                    if (nArray4[n3] == 0) continue;
                    int n14 = n2;
                    dArray3[n14] = dArray3[n14] + dArray6[n3] * dArray3[nArray4[n3]];
                }
            }
            for (n2 = 0; n2 < this.getDotStatesIndex(); ++n2) {
                int n15 = n2;
                dArray3[n15] = dArray3[n15] * dArray7[n2];
            }
            for (n2 = 0; n2 < this.getDotStatesIndex(); ++n2) {
                nArray4 = nArray3[n2];
                dArray6 = dArray5[n2];
                for (n3 = 0; n3 < nArray4.length; ++n3) {
                    if (nArray4[n3] == 0) continue;
                    double[] dArray9 = fBMatrix.beta[n];
                    int n16 = n2;
                    dArray9[n16] = dArray9[n16] + dArray6[n3] * dArray3[nArray4[n3]] * fBMatrix.c[n];
                }
            }
            if (this.constraints == null) continue;
            this.constraints.constrain(nArray[n], fBMatrix.beta[n]);
        }
        return fBMatrix;
    }

    public DPMatrix backwardMatrix(SymbolList[] symbolListArray, DPMatrix dPMatrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SingleDPMatrix singleDPMatrix = (SingleDPMatrix)dPMatrix;
        AlignedMatrixCursor alignedMatrixCursor = new AlignedMatrixCursor(singleDPMatrix, (Iterator)new DP.ReverseIterator(symbolListArray[0]), -1);
        singleDPMatrix.setScore(this.backward(alignedMatrixCursor, scoreType));
        this.unlockModel();
        return singleDPMatrix;
    }

    public DPMatrix backwardMatrix(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        SingleDPMatrix singleDPMatrix = new SingleDPMatrix((DP)this, symbolListArray[0]);
        return this.backwardMatrix(symbolListArray, (DPMatrix)singleDPMatrix, scoreType);
    }

    public DPMatrix forwardMatrix(SymbolList[] symbolListArray, DPMatrix dPMatrix, ScoreType scoreType) throws IllegalArgumentException, IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        if (symbolListArray.length != 1) {
            throw new IllegalArgumentException("seq must be 1 long, not " + symbolListArray.length);
        }
        this.lockModel();
        SingleDPMatrix singleDPMatrix = (SingleDPMatrix)dPMatrix;
        AlignedMatrixCursor alignedMatrixCursor = new AlignedMatrixCursor(singleDPMatrix, symbolListArray[0].iterator(), 1);
        singleDPMatrix.setScore(this.forward(alignedMatrixCursor, scoreType));
        this.unlockModel();
        return singleDPMatrix;
    }

    public DPMatrix forwardMatrix(SymbolList[] symbolListArray, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalSymbolException {
        SingleDPMatrix singleDPMatrix = new SingleDPMatrix((DP)this, symbolListArray[0]);
        return this.forwardMatrix(symbolListArray, (DPMatrix)singleDPMatrix, scoreType);
    }

    public AlignedDP(MarkovModel markovModel, Constraints constraints) throws IllegalSymbolException, IllegalTransitionException, BioException {
        super(markovModel);
        this.mapLabels(this.getStates());
        this.constraints = constraints;
    }

    public String maxPLP(SymbolList[] symbolListArray) throws Exception {
        LabelProbMatrix labelProbMatrix = this.calcPosteriorLabelProbability(symbolListArray);
        return this.maxPLP(labelProbMatrix);
    }

    public String maxPLP(LabelProbMatrix labelProbMatrix) throws Exception {
        SymbolList[] symbolListArray = labelProbMatrix.getSymList();
        String string = "";
        for (int i = 0; i < symbolListArray[0].length(); ++i) {
            int n = 0;
            double d = Double.NEGATIVE_INFINITY;
            String string2 = "Q";
            if (symbolListArray.length == 1 && symbolListArray[0].symbolAt(i + 1).getName().equals("[]")) {
                string2 = "-";
            } else {
                Iterator iterator = labelProbMatrix.getLabels().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (labelProbMatrix.scores[i][n] > d) {
                        d = labelProbMatrix.scores[i][n];
                        string2 = string3;
                    }
                    ++n;
                }
            }
            if (string2 == "X") continue;
            string = string + string2;
        }
        return string;
    }

    public LabelProbMatrix calcPosteriorLabelProbability(SymbolList[] symbolListArray) throws Exception {
        FBMatrix fBMatrix = this.forwardbackwardMatrix(symbolListArray[0]);
        LabelProbMatrix labelProbMatrix = new LabelProbMatrix((DP)this, symbolListArray[0]);
        labelProbMatrix.setValues(fBMatrix);
        return labelProbMatrix;
    }

    public String optimalPLP(SymbolList[] symbolListArray) throws Exception {
        LabelProbMatrix labelProbMatrix = this.calcPosteriorLabelProbability(symbolListArray);
        return this.optimalPLP(labelProbMatrix);
    }

    public String optimalPLP(LabelProbMatrix labelProbMatrix) throws Exception {
        int n;
        int n2;
        int n3;
        this.lockModel();
        SymbolList symbolList = labelProbMatrix.getSymList()[0];
        SmallCursor smallCursor = new SmallCursor(this.getStates(), symbolList, symbolList.iterator());
        State[] stateArray = this.getStates();
        int[][] nArray = this.getForwardTransitions();
        int n4 = stateArray.length;
        BackPointer backPointer = new BackPointer[n4];
        BackPointer backPointer2 = new BackPointer[n4];
        double[] dArray = smallCursor.currentCol();
        double[] dArray2 = smallCursor.lastCol();
        int n5 = 0;
        for (n3 = 0; n3 < this.getDotStatesIndex(); ++n3) {
            if (stateArray[n3] == this.getModel().magicalState()) {
                dArray[n3] = 1.0;
                dArray2[n3] = 0.0;
                backPointer2[n3] = new BackPointer(stateArray[n3]);
                backPointer[n3] = null;
                continue;
            }
            dArray2[n3] = 0.0;
            dArray[n3] = 0.0;
        }
        for (n3 = this.getDotStatesIndex(); n3 < n4; ++n3) {
            int[] nArray2 = nArray[n3];
            double d = 0.0;
            n2 = -1;
            for (int i = 0; i < nArray2.length; ++i) {
                n = nArray2[i];
                double d2 = dArray[n];
                if (!(d2 > d)) continue;
                d = d2;
                n2 = n;
            }
            if (n2 != -1) {
                dArray[n3] = d;
                backPointer2[n3] = new BackPointer(stateArray[n3], (BackPointer)backPointer2[n2], d);
                continue;
            }
            dArray2[n3] = 0.0;
            dArray[n3] = 0.0;
            backPointer2[n3] = null;
            backPointer[n3] = null;
        }
        BackPointer backPointer3 = backPointer2;
        backPointer2 = backPointer;
        backPointer = backPointer3;
        while (smallCursor.canAdvance()) {
            smallCursor.advance();
            backPointer3 = smallCursor.currentRes();
            dArray = smallCursor.currentCol();
            dArray2 = smallCursor.lastCol();
            dArray[0] = 0.0;
            backPointer2[0] = null;
            if (!backPointer3.getName().equals("[]") && !backPointer3.getName().equals("gap")) {
                double[] dArray3 = labelProbMatrix.scores[n5];
                for (int i = 1; i < stateArray.length; ++i) {
                    int[] nArray3 = nArray[i];
                    double d = i < this.getDotStatesIndex() ? dArray3[labelProbMatrix.state2labelIx[i]] : 0.0;
                    double d3 = 0.0;
                    int n6 = -1;
                    for (int j = 0; j < nArray3.length; ++j) {
                        double d4;
                        int n7 = nArray3[j];
                        double d5 = d4 = i < this.getDotStatesIndex() ? dArray2[n7] : dArray[n7];
                        if (!(d4 > d3)) continue;
                        d3 = d4;
                        n6 = n7;
                    }
                    if (n6 != -1) {
                        dArray[i] = d3 + d;
                        backPointer2[i] = new BackPointer(stateArray[i], i < this.getDotStatesIndex() ? backPointer[n6] : backPointer2[n6], dArray[i]);
                        continue;
                    }
                    dArray[i] = 0.0;
                    backPointer2[i] = null;
                }
                BackPointer backPointer4 = backPointer2;
                backPointer2 = backPointer;
                backPointer = backPointer4;
            } else {
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray[i] = dArray2[i];
                }
            }
            ++n5;
        }
        backPointer3 = null;
        int[] nArray4 = nArray[0];
        double d = 0.0;
        n2 = -1;
        for (int i = 0; i < nArray4.length; ++i) {
            n = nArray4[i];
            double d6 = dArray[n];
            if (!(d6 > d)) continue;
            d = d6;
            n2 = n;
        }
        if (n2 != -1) {
            backPointer3 = new BackPointer(stateArray[0], backPointer[n2], dArray[n2]);
        }
        StringBuffer stringBuffer = new StringBuffer(symbolList.seqString());
        n = stringBuffer.length() - 1;
        while (backPointer3.state instanceof MagicalState) {
            backPointer3 = backPointer3.back;
        }
        while (n >= 0) {
            while (n >= 0 && stringBuffer.charAt(n) == '-') {
                --n;
            }
            while (n >= 0 && backPointer3.state instanceof DotState) {
                backPointer3 = backPointer3.back;
            }
            if (n >= 0 && backPointer3.state instanceof SimpleEmissionState) {
                String string;
                try {
                    string = (String)backPointer3.state.getAnnotation().getProperty((Object)"Label");
                }
                catch (Exception exception) {
                    string = "X";
                }
                stringBuffer.setCharAt(n, string.charAt(0));
            }
            --n;
            backPointer3 = backPointer3.back;
        }
        this.unlockModel();
        return stringBuffer.toString();
    }

    protected final void forwardCalcEmissionStates(double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3, double[] dArray4) throws IllegalSymbolException {
        for (int i = 1; i < this.getDotStatesIndex(); ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                int n = i;
                dArray[n] = dArray[n] + dArray3[i][j] * dArray2[nArray2[j]];
            }
            int n = i;
            dArray[n] = dArray[n] * dArray4[i];
        }
    }

    protected final void forwardCalcDotStates(double[] dArray, int[][] nArray, double[][] dArray2) throws IllegalSymbolException {
        for (int i = this.getDotStatesIndex(); i < dArray.length; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                int n = i;
                dArray[n] = dArray[n] + dArray2[i][j] * dArray[nArray2[j]];
            }
        }
    }

    public String[] doNbest(Sequence[] sequenceArray, double[] dArray, int n, boolean bl) throws Exception {
        Iterator iterator;
        this.lockModel();
        AlignmentCursor alignmentCursor = new AlignmentCursor(this.getStates(), sequenceArray, 1);
        State[] stateArray = this.getStates();
        int[][] nArray = this.getForwardTransitions();
        double[][] dArray2 = this.forwardTransitionRawScores(this.getModel(), stateArray, nArray);
        int n2 = stateArray.length;
        ArrayList<Hypothesis> arrayList = new ArrayList<Hypothesis>();
        Hypothesis hypothesis = new Hypothesis(n2, this.labels.length);
        Hypothesis.dp = this;
        this.forwardCalcDotStates(hypothesis.oldCol, nArray, dArray2);
        arrayList.add(hypothesis);
        while (alignmentCursor.canAdvance()) {
            int n3;
            alignmentCursor.advance();
            double[] dArray3 = bl ? this.getRawProfileEmission(alignmentCursor.currentResidues(), dArray) : this.getRawEmission(alignmentCursor.currentRes());
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Hypothesis hypothesis2 = (Hypothesis)iterator.next();
                this.forwardCalcEmissionStates(hypothesis2.newCol, hypothesis2.oldCol, nArray, dArray2, dArray3);
                if (this.constraints == null) continue;
                this.constraints.constrain(alignmentCursor.currentIndex() - 1, hypothesis2.newCol);
            }
            for (n3 = 1; n3 < this.getDotStatesIndex(); ++n3) {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((Hypothesis)iterator.next()).setCompareState(n3);
                }
                Collections.sort(arrayList);
                for (int i = 0; i < arrayList.size() && i < n; ++i) {
                    Hypothesis hypothesis3 = (Hypothesis)arrayList.get(i);
                    if (Double.isInfinite(hypothesis3.cmpScore)) continue;
                    hypothesis3.alive[this.state2labelIx[n3]] = true;
                }
            }
            n3 = 0;
            while (n3 < arrayList.size()) {
                int n4;
                Hypothesis hypothesis4 = (Hypothesis)arrayList.get(n3);
                int n5 = 0;
                for (n4 = 0; n4 < hypothesis4.alive.length; ++n4) {
                    if (!hypothesis4.alive[n4]) continue;
                    ++n5;
                }
                if (n5 == 0) {
                    arrayList.remove(n3);
                    continue;
                }
                n4 = 0;
                while (n5 > 1) {
                    while (!hypothesis4.alive[n4]) {
                        ++n4;
                    }
                    arrayList.add(n3++, new Hypothesis(hypothesis4, n4++));
                    --n5;
                }
                while (!hypothesis4.alive[n4]) {
                    ++n4;
                }
                hypothesis4.move(n4);
                ++n3;
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Hypothesis hypothesis5 = (Hypothesis)iterator.next();
                this.forwardCalcDotStates(hypothesis5.oldCol, nArray, dArray2);
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Hypothesis hypothesis6 = (Hypothesis)iterator.next();
            int[] nArray2 = nArray[0];
            for (int i = 0; i < nArray2.length; ++i) {
                hypothesis6.newCol[0] = hypothesis6.newCol[0] + hypothesis6.oldCol[nArray2[i]];
            }
            hypothesis6.finishUp();
        }
        Collections.sort(arrayList);
        String[] stringArray = new String[n];
        for (int i = 0; i < arrayList.size() && i < n; ++i) {
            StringBuffer stringBuffer = new StringBuffer(sequenceArray[0].seqString());
            String string = ((Hypothesis)arrayList.get(i)).getLabeling();
            int n6 = 0;
            int n7 = 0;
            while (n7 < string.length()) {
                while (stringBuffer.charAt(n6) == '-') {
                    ++n6;
                }
                stringBuffer.setCharAt(n6++, string.charAt(n7++));
            }
            stringArray[i] = stringBuffer.toString();
        }
        this.unlockModel();
        return stringArray;
    }
}

