/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import java.util.Arrays;
import java.util.Iterator;
import org.biojava.bio.dp.onehead.DPCursor;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class AlignedMatrixCursor
implements DPCursor {
    private static final Symbol gap = AlphabetManager.getGapSymbol();
    private Symbol currentRes;
    private Symbol lastRes;
    private Iterator symIterator;
    private final SingleDPMatrix matrix;
    private final int dir;
    private int currentIndex;
    private int lastIndex;
    protected int gaps;

    public int length() {
        return this.matrix.symList()[0].length() + 2;
    }

    public SymbolList symList() {
        return this.matrix.symList()[0];
    }

    public Symbol currentRes() {
        return this.currentRes;
    }

    public Symbol lastRes() {
        return this.lastRes;
    }

    public double[] currentCol() {
        return this.matrix.scores[this.currentIndex];
    }

    public double[] lastCol() {
        return this.matrix.scores[this.lastIndex];
    }

    public void advance() {
        this.doadvance();
    }

    protected void postadvance() {
        if (this.gaps > 0) {
            for (int i = this.lastIndex + this.dir; i != this.currentIndex; i += this.dir) {
                Arrays.fill(this.matrix.scores[i], -Math.log(this.matrix.states().length));
            }
            this.gaps = 0;
        }
    }

    protected void doadvance() {
        this.lastRes = this.currentRes;
        this.lastIndex = this.currentIndex;
        this.gaps = 0;
        while (this.symIterator.hasNext()) {
            this.currentRes = (Symbol)this.symIterator.next();
            this.currentIndex += this.dir;
            if (this.currentRes.getName().length() > 2) break;
            ++this.gaps;
        }
        if (this.currentRes.getName().length() <= 2 && !this.symIterator.hasNext()) {
            this.currentRes = gap;
            this.currentIndex += this.dir;
        }
    }

    public boolean canAdvance() {
        return this.symIterator.hasNext();
    }

    public AlignedMatrixCursor(SingleDPMatrix singleDPMatrix, Iterator iterator, int n) throws IllegalArgumentException {
        this.symIterator = iterator;
        this.gaps = 0;
        this.currentRes = gap;
        this.lastRes = gap;
        this.matrix = singleDPMatrix;
        this.dir = n;
        this.currentIndex = n == 1 ? 0 : this.length() - 1;
    }
}

