/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.dp.State;
import org.biojava.bio.dp.onehead.DPCursor;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class AlignmentCursor
implements DPCursor {
    private static final Symbol gap = AlphabetManager.getGapSymbol();
    private Sequence[] sequences;
    private Symbol currentRes;
    private Symbol lastRes;
    private final int dir;
    private int currentIndex;
    private int lastNoGap;
    private double[] currentC;
    private double[] lastC;

    public int length() {
        return this.sequences[0].length();
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public SymbolList symList() {
        return this.sequences[0];
    }

    public Symbol currentRes() {
        return this.currentRes;
    }

    public Symbol[] currentResidues() {
        Symbol[] symbolArray = new Symbol[this.sequences.length];
        try {
            for (int i = 0; i < symbolArray.length; ++i) {
                symbolArray[i] = this.sequences[i].symbolAt(this.currentIndex);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Symbol[] symbolArray2 = new Symbol[]{gap};
            return symbolArray2;
        }
        return symbolArray;
    }

    public Symbol lastRes() {
        return this.lastRes;
    }

    public double[] currentCol() {
        return this.currentC;
    }

    public double[] lastCol() {
        return this.lastC;
    }

    public void advance() {
        this.lastRes = this.currentRes;
        while (this.canAdvance()) {
            this.currentIndex += this.dir;
            try {
                this.currentRes = this.sequences[0].symbolAt(this.currentIndex);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.currentRes = gap;
                break;
            }
            if (this.currentRes.getName().length() <= 2) continue;
        }
        if (this.currentRes.getName().length() <= 2 && this.canAdvance()) {
            this.currentRes = gap;
            this.currentIndex += this.dir;
        }
        double[] dArray = this.lastC;
        this.lastC = this.currentC;
        this.currentC = dArray;
    }

    public boolean canAdvance() {
        return this.dir == 1 ? this.currentIndex < this.lastNoGap : this.currentIndex > this.lastNoGap;
    }

    public AlignmentCursor(State[] stateArray, Sequence[] sequenceArray, int n) throws IllegalArgumentException {
        this.sequences = sequenceArray;
        this.currentRes = gap;
        this.lastRes = gap;
        this.dir = n;
        this.currentIndex = n == 1 ? 0 : this.length() - 1;
        this.lastNoGap = n == 1 ? this.length() : 1;
        this.currentC = new double[stateArray.length];
        this.lastC = new double[stateArray.length];
        while (sequenceArray[0].symbolAt(this.lastNoGap).getName().length() <= 2) {
            this.lastNoGap -= n;
        }
    }
}

