/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import java.util.Arrays;
import java.util.HashMap;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Symbol;
import se.ki.cgb.labeledhmm.WeightScheme;

public class ConservedHenikoffWeights
extends WeightScheme {
    protected ConservedHenikoffWeights() {
    }

    public double[] getWeights(Sequence[] sequenceArray) {
        int n;
        double[] dArray = new double[sequenceArray.length];
        if (sequenceArray.length == 0) {
            return dArray;
        }
        HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
        for (int i = 1; i <= sequenceArray[0].length(); ++i) {
            int n2;
            boolean bl = true;
            for (n = 0; n < sequenceArray.length; ++n) {
                Symbol symbol = sequenceArray[n].symbolAt(i);
                if (symbol.getName().length() == 3) {
                    if (hashMap.containsKey(symbol)) {
                        n2 = (Integer)hashMap.get(symbol) + 1;
                        hashMap.put(symbol, new Integer(n2));
                        continue;
                    }
                    hashMap.put(symbol, new Integer(1));
                    continue;
                }
                bl = false;
                break;
            }
            if (!bl) continue;
            double d = hashMap.size();
            for (n2 = 0; n2 < sequenceArray.length; ++n2) {
                Symbol symbol = sequenceArray[n2].symbolAt(i);
                if (symbol.getName().length() != 3) continue;
                int n3 = (Integer)hashMap.get(symbol);
                int n4 = n2;
                dArray[n4] = dArray[n4] + 1.0 / (d * (double)n3);
            }
            hashMap.clear();
        }
        double d = 0.0;
        for (n = 0; n < sequenceArray.length; ++n) {
            d += dArray[n];
        }
        if (d > 0.0) {
            n = 0;
            while (n < sequenceArray.length) {
                int n5 = n++;
                dArray[n5] = dArray[n5] / d;
            }
        } else {
            Arrays.fill(dArray, 1.0 / (double)sequenceArray.length);
        }
        return dArray;
    }
}

