/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import java.util.HashMap;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Symbol;
import se.ki.cgb.labeledhmm.WeightScheme;

public class EddyHenikoffWeights
extends WeightScheme {
    protected EddyHenikoffWeights() {
    }

    public double[] getWeights(Sequence[] sequenceArray) {
        int n;
        double[] dArray = new double[sequenceArray.length];
        int[] nArray = new int[sequenceArray.length];
        if (sequenceArray.length == 0) {
            return dArray;
        }
        HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
        for (int i = 1; i <= sequenceArray[0].length(); ++i) {
            int n2;
            for (int j = 0; j < sequenceArray.length; ++j) {
                Symbol symbol = sequenceArray[j].symbolAt(i);
                if (symbol.getName().length() != 3) continue;
                int n3 = j;
                nArray[n3] = nArray[n3] + 1;
                if (hashMap.containsKey(symbol)) {
                    n2 = (Integer)hashMap.get(symbol) + 1;
                    hashMap.put(symbol, new Integer(n2));
                    continue;
                }
                hashMap.put(symbol, new Integer(1));
            }
            double d = hashMap.size();
            for (n2 = 0; n2 < sequenceArray.length; ++n2) {
                Symbol symbol = sequenceArray[n2].symbolAt(i);
                if (symbol.getName().length() != 3) continue;
                int n4 = (Integer)hashMap.get(symbol);
                int n5 = n2;
                dArray[n5] = dArray[n5] + 1.0 / (d * (double)n4);
            }
            hashMap.clear();
        }
        double d = 0.0;
        for (n = 0; n < sequenceArray.length; ++n) {
            int n6 = n;
            dArray[n6] = dArray[n6] / (double)nArray[n];
        }
        for (n = 0; n < sequenceArray.length; ++n) {
            d += dArray[n];
        }
        n = 0;
        while (n < sequenceArray.length) {
            int n7 = n++;
            dArray[n7] = dArray[n7] / d;
        }
        return dArray;
    }
}

