/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class FBMatrix {
    public final double[][] alfa;
    public final double[][] beta;
    public final double[] c;
    public final int[] g2ung;
    public final int[] ung2g;
    public double score;
    protected int seqlen;
    protected int ungappedlen;
    protected int statelen;
    protected SymbolList sequence;
    protected static double[] gammaRet;

    public FBMatrix(SymbolList symbolList, int n) {
        int n2;
        this.sequence = symbolList;
        this.seqlen = symbolList.length();
        this.statelen = n;
        this.g2ung = new int[this.seqlen];
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.seqlen; ++n2) {
            Symbol symbol;
            try {
                symbol = symbolList.symbolAt(n2 + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                symbol = AlphabetManager.getGapSymbol();
            }
            if (symbol == AlphabetManager.getGapSymbol() || symbol.getName().length() < 3) {
                this.g2ung[n2] = -1;
                ++n3;
                continue;
            }
            this.g2ung[n2] = n4++;
        }
        this.ungappedlen = n4;
        this.ung2g = new int[n4];
        for (n2 = 0; n2 < this.seqlen; ++n2) {
            if (this.g2ung[n2] < 0) continue;
            this.ung2g[this.g2ung[n2]] = n2;
        }
        this.alfa = new double[n4][n];
        this.beta = new double[n4][n];
        this.c = new double[n4 + 1];
    }

    double[] getGamma(int n) {
        if (n < 0 || n > this.seqlen || this.g2ung[n] < 0) {
            return null;
        }
        int n2 = this.g2ung[n];
        if (gammaRet == null) {
            gammaRet = new double[this.statelen];
        }
        double[] dArray = gammaRet;
        for (int i = 0; i < this.statelen; ++i) {
            dArray[i] = this.alfa[n2][i] * this.beta[n2][i] / this.c[n2];
            if (!(dArray[i] < 0.0) && !(dArray[i] > 1.0)) continue;
            System.err.println("Probability " + dArray[i] + " detected");
        }
        return dArray;
    }

    public int getUngappedLen() {
        return this.ungappedlen;
    }
}

