/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import java.util.HashMap;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Symbol;
import se.ki.cgb.labeledhmm.WeightScheme;

public class HenikoffWeights
extends WeightScheme {
    protected HenikoffWeights() {
    }

    public double[] getWeights(Sequence[] sequenceArray) {
        int n;
        double[] dArray = new double[sequenceArray.length];
        if (sequenceArray.length == 0) {
            return dArray;
        }
        HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
        for (int i = 1; i <= sequenceArray[0].length(); ++i) {
            int n2;
            for (int j = 0; j < sequenceArray.length; ++j) {
                Symbol symbol = sequenceArray[j].symbolAt(i);
                if (hashMap.containsKey(symbol)) {
                    n2 = (Integer)hashMap.get(symbol) + 1;
                    hashMap.put(symbol, new Integer(n2));
                    continue;
                }
                hashMap.put(symbol, new Integer(1));
            }
            double d = hashMap.size();
            n2 = 0;
            while (n2 < sequenceArray.length) {
                Symbol symbol = sequenceArray[n2].symbolAt(i);
                int n3 = (Integer)hashMap.get(symbol);
                int n4 = n2++;
                dArray[n4] = dArray[n4] + 1.0 / (d * (double)n3);
            }
            hashMap.clear();
        }
        double d = 0.0;
        for (n = 0; n < sequenceArray.length; ++n) {
            d += dArray[n];
        }
        n = 0;
        while (n < sequenceArray.length) {
            int n5 = n++;
            dArray[n5] = dArray[n5] / d;
        }
        return dArray;
    }
}

