/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import java.util.Arrays;
import se.ki.cgb.labeledhmm.AlignedDP;

public class Hypothesis
implements Comparable {
    static AlignedDP dp;
    protected int lastSwitch;
    protected char label;
    protected int labelIx;
    protected String labeling;
    protected double logScore;
    double cmpScore;
    public double[] newCol;
    public double[] oldCol;
    boolean[] alive;

    public Hypothesis(int n, int n2) {
        this.lastSwitch = 0;
        this.label = (char)32;
        this.labelIx = -1;
        this.labeling = "";
        this.alive = new boolean[n2];
        Arrays.fill(this.alive, false);
        this.newCol = new double[n];
        this.oldCol = new double[n];
        this.oldCol[0] = 1.0;
        this.logScore = 0.0;
    }

    public void move(int n) {
        int n2;
        if (this.labelIx != n) {
            this.lastSwitch = this.labeling.length();
            this.labelIx = n;
            this.label = Hypothesis.dp.labels[this.labelIx];
        }
        this.labeling = this.labeling + this.label;
        double[] dArray = this.oldCol;
        this.oldCol = this.newCol;
        this.newCol = dArray;
        Arrays.fill(this.newCol, 0.0);
        int n3 = 0;
        int[] nArray = Hypothesis.dp.labelIx2states[this.labelIx];
        double d = 0.0;
        for (n2 = 0; n2 < this.newCol.length; ++n2) {
            if (n3 >= nArray.length || n2 < nArray[n3]) {
                this.oldCol[n2] = 0.0;
                continue;
            }
            d += this.oldCol[n2];
            ++n3;
        }
        if (d > 0.0) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n4 = nArray[n2];
                this.oldCol[n4] = this.oldCol[n4] / d;
            }
        }
        this.logScore += Math.log(d);
        Arrays.fill(this.alive, false);
    }

    public Hypothesis(Hypothesis hypothesis, int n) {
        int n2;
        this.lastSwitch = hypothesis.lastSwitch;
        this.label = hypothesis.label;
        this.labelIx = hypothesis.labelIx;
        this.labeling = new String(hypothesis.labeling);
        this.alive = new boolean[hypothesis.alive.length];
        Arrays.fill(this.alive, false);
        this.newCol = new double[hypothesis.newCol.length];
        this.oldCol = new double[hypothesis.oldCol.length];
        this.logScore = hypothesis.logScore;
        this.lastSwitch = hypothesis.lastSwitch;
        if (this.labelIx != n) {
            this.lastSwitch = this.labeling.length();
            this.labelIx = n;
            this.label = Hypothesis.dp.labels[this.labelIx];
        }
        this.labeling = this.labeling + this.label;
        int[] nArray = Hypothesis.dp.labelIx2states[this.labelIx];
        double d = 0.0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.oldCol[nArray[n2]] = hypothesis.newCol[nArray[n2]];
            d += this.oldCol[nArray[n2]];
        }
        if (d > 0.0) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n3 = nArray[n2];
                this.oldCol[n3] = this.oldCol[n3] / d;
            }
        }
        this.logScore += Math.log(d);
    }

    public void initNorm() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.oldCol.length; ++n) {
            d += this.oldCol[n];
        }
        n = 0;
        while (n < this.oldCol.length) {
            int n2 = n++;
            this.oldCol[n2] = this.oldCol[n2] / d;
        }
        this.logScore += Math.log(d);
    }

    public void setCompareState(int n) {
        this.cmpScore = this.logScore + Math.log(this.newCol[n]);
    }

    public void finishUp() {
        this.logScore += Math.log(this.newCol[0]);
        if (this.newCol[0] > 0.0) {
            this.newCol[0] = 1.0;
        }
        this.cmpScore = this.logScore;
    }

    public int compareTo(Object object) {
        return Double.compare(((Hypothesis)object).cmpScore, this.cmpScore);
    }

    public final String getLabeling() {
        return this.labeling;
    }
}

