/*
 * Decompiled with CFR 0.152.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.seq.Sequence;
import se.ki.cgb.labeledhmm.ConservedHenikoffWeights;
import se.ki.cgb.labeledhmm.EddyHenikoffWeights;
import se.ki.cgb.labeledhmm.FlatWeights;
import se.ki.cgb.labeledhmm.HenikoffWeights;
import se.ki.cgb.labeledhmm.IgnoreGapsHenikoffWeights;
import se.ki.cgb.labeledhmm.NoGapHenikoffWeights;

public abstract class WeightScheme {
    public static final int FLAT = 0;
    public static final int GAPPED_HENIKOFF = 1;
    public static final int UNGAPPED_HENIKOFF = 2;
    public static final int CONSERVED_HENIKOFF = 3;
    public static final int EDDY_HENIKOFF = 4;
    public static final int IGNORE_HENIKOFF = 5;
    protected static WeightScheme inst = null;

    protected WeightScheme() {
    }

    public static void selectScheme(int n) {
        switch (n) {
            case 0: {
                inst = new FlatWeights();
                break;
            }
            case 1: {
                inst = new HenikoffWeights();
                break;
            }
            case 2: {
                inst = new NoGapHenikoffWeights();
                break;
            }
            case 3: {
                inst = new ConservedHenikoffWeights();
                break;
            }
            case 4: {
                inst = new EddyHenikoffWeights();
                break;
            }
            case 5: {
                inst = new IgnoreGapsHenikoffWeights();
                break;
            }
            default: {
                System.err.println("Scheme not implemented");
            }
        }
    }

    public static WeightScheme getInstance() {
        if (inst == null) {
            inst = new EddyHenikoffWeights();
        }
        return inst;
    }

    public abstract double[] getWeights(Sequence[] var1);
}

