/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.anhmmfile;

import java.io.*;
import org.biojava.bio.dp.*;
import org.biojava.bio.symbol.*;
import org.biojava.bio.seq.ProteinTools;
import java.util.*;
import java.util.regex.*;
import java.util.Iterator;

/**
 * Singleton for parsing anhmm hmm model files
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.4 $
 */
public class AnReader {
	
    private static AnReader m_instance;
    
	/**
	 * 
	 */
	private AnReader() throws Exception {
		super();
		if (m_instance!=null) throw new java.lang.Exception("Allready an instance of this singleton");
		m_instance=this;
	}
	
	public static AnReader getInstance() throws Exception {
		if (m_instance!=null)
			return m_instance;
		return new AnReader();
	}
	
	public MarkovModel parseStream(BufferedReader in )  throws Exception {
		String buff = "";
		try {
			while(true) {
				buff += in.readLine().replaceAll("[#].*$","");
			}
		}
		catch(EOFException e){;}
		catch(NullPointerException e){;}
		Pattern p = Pattern.compile("(.+?)\\s\\{(.*?)\\}");
		Matcher m = p.matcher(buff);
		m.find();
		if (!m.group(1).equals("header"))
			throw new Exception ("Could not find alphabet");

		HashMap proxies = new HashMap();
		while (m.find()) {
			proxies.put(m.group(1), new StateProxy(m.group(1),m.group(2)));
		}
		
		FiniteAlphabet emissionAlphabet = ProteinTools.getAlphabet();
		SimpleMarkovModel model = new SimpleMarkovModel(1, emissionAlphabet, "AnhmmImportedModel");
		StateProxy.m_model = model;
		
		Iterator vals = proxies.values().iterator();
		while (vals.hasNext()) {
			StateProxy proxy = (StateProxy)vals.next();
			proxy.getDistribution(proxies);
	    }
		vals = proxies.values().iterator();
		while (vals.hasNext()) {
			StateProxy proxy = (StateProxy)vals.next();
			proxy.createTranstions(proxies);
		}
		return model;
	}
}


