/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.anhmmfile;

import java.io.IOException;

import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.Sequence;

import se.ki.cgb.labeledhmm.OutputHandler;

/**
 * Vanilla implementation of OutputHandler.
 * Prints labeled fasta.
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.2 $
 */
public class FastaOutputHandler extends OutputHandler {

	SequenceFormat format;

	public FastaOutputHandler () {
		format = new LabeledFastaFormat();	
	}
	
	/* (non-Javadoc)
	 * @see se.ki.cgb.labeledhmm.OutputHandler#printSequence(org.biojava.bio.seq.Sequence)
	 */
	public void printSequence(Sequence seq) throws IOException {
		format.writeSequence(seq,System.out);
	}

}
