/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.anhmmfile;

import org.biojava.bio.seq.io.*;
import java.io.*;
/**
 * Parses the Labeled fasta format
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.4 $
 */
public class LabeledFastaParser extends FastaDescriptionLineParser {

	public static class Factory implements SequenceBuilderFactory, Serializable {
		private SequenceBuilderFactory delegateFactory;
	
		public Factory(SequenceBuilderFactory delegateFactory) {
			this.delegateFactory = delegateFactory;
		}
	
		public SequenceBuilder makeSequenceBuilder() {
			return new LabeledFastaParser(delegateFactory.makeSequenceBuilder());
		}
		public static final long serialVersionUID = 5623789;

	}
	/**
	 * @param delegate
	 */
	public LabeledFastaParser(SequenceBuilder delegate) {
		super(delegate);
	}

/*
	public void addSequenceProperty(Object key, Object value) throws ParseException {
		super.addSequenceProperty(key, value);
		if (LabeledFastaFormat.PROPERTY_LABELS.equals(key)) {
				getDelegate().addSequenceProperty(key, value);
		} 
	}
*/

}
