/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.anhmmfile;

import org.biojava.bio.dp.*;
import org.biojava.bio.symbol.*;
import org.biojava.bio.dist.*;
import org.biojava.bio.*;
import java.util.*;
import java.util.regex.*;
import org.biojava.bio.seq.io.SymbolTokenization;

/**
 * helper class for parsin anhmm hmm model files
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.3 $
 */

public class StateProxy {
	public static int [] m_advance = { 1 };
	public static MarkovModel m_model;
	protected String m_body;
	protected String m_name;
	protected Distribution m_dist = null;
	protected State m_state = null;
	protected Annotation m_annotation = null;
	
	public StateProxy(String name, String body) {
		m_body = body;
		m_name = name;
	}
	
	public void createTranstions(HashMap proxies) throws Exception {
		Pattern p = Pattern.compile("trans\\s+(.*?);",Pattern.MULTILINE);
		Matcher m = p.matcher(m_body);
		m.find();
		String letters = m.group(1);
		p = Pattern.compile("(\\w+)\\s?:\\s?([0-9.eE\\-+]+)\\s?:\\s?([0-9.eE\\-+]+)?");
		m = p.matcher(letters);
		HashMap weights = new HashMap();
		double leftOver = 0.0;
		if (!m_body.matches(".*end\\s+0.*")) {
			State to = m_model.magicalState();
			m_model.createTransition(getState(),to);
//			leftOver = 1e-10;
			weights.put(to,new Double(leftOver));
		}
		while (m.find()) {
			String toName = m.group(1);
			State to = ((StateProxy)proxies.get(toName)).getState();
			m_model.createTransition(getState(),to);
			Double weight = new Double(m.group(2));
			if (leftOver >0.0 && weight.doubleValue() >= leftOver*5) {
				weight = new Double(weight.doubleValue() - leftOver);
				leftOver = 0.0;
			}
			weights.put(to,weight);
		}
		Iterator i = weights.keySet().iterator();
		while (i.hasNext()) {
			State to = (State)i.next();
			double weight = ((Double)weights.get(to)).doubleValue();
			m_model.getWeights(getState()).setWeight(to, weight);		
		}
	}

	public Distribution getDistribution(HashMap proxies) throws Exception  {
		if (m_state==null && m_dist==null) {
			if (m_name.matches("begin")) {
				m_state = m_model.magicalState();
			} else if (m_body.matches(".*tied_letter.*")) {
				// Get tied distribution
				Pattern p = Pattern.compile("tied_letter\\s(.*?);");
				Matcher m = p.matcher(m_body);
				m.find();
				String depend = m.group(1);
				m_dist=((StateProxy)proxies.get(depend)).getDistribution(proxies);
				m_state= new SimpleEmissionState(m_name, getAnnotation(),
					StateProxy.m_advance, m_dist);
				m_model.addState(m_state);
			} else if ((!m_body.matches(".*letter.*") && !m_body.matches(".*only.*")) || m_body.matches(".*letter NULL;.*")) {
				m_state = new SimpleDotState(m_name,getAnnotation()); 
				m_model.addState(m_state);
			} else {
				m_dist = DistributionFactory.DEFAULT.createDistribution(m_model.emissionAlphabet());
				Pattern p = Pattern.compile("(letter|only)\\s+(.*?);",Pattern.MULTILINE);
				Matcher m = p.matcher(m_body);
				m.find();
				String letters = m.group(2);
				String posPattern = "(\\w)\\s?:\\s?([0123456789.eE\\-\\+]+)\\s?(:\\s?[0123456789.eE\\-\\+]+)?";
				p = Pattern.compile(posPattern);
				m = p.matcher(letters);
				SymbolTokenization tokenization = m_model.emissionAlphabet().getTokenization("token");
				while (m.find()) {
					Symbol s = tokenization.parseToken(m.group(1));
					m_dist.setWeight(s,(Double.parseDouble(m.group(2))));
				}
				m_state= new SimpleEmissionState(m_name, getAnnotation(),
					StateProxy.m_advance, m_dist);
				m_model.addState(m_state);
			}		    
		}
		return m_dist;		
	}

    public Annotation getAnnotation() {
		if (m_annotation == null) {
			m_annotation = new SimpleAnnotation();
			Pattern p = Pattern.compile("label\\s(.*?);");
			Matcher m = p.matcher(m_body);
			if (m.find()) {
				try {
					m_annotation.setProperty("Label",m.group(1));
				} catch (Exception e) {}
			}
		}
		return m_annotation;
	}
	/**
	 * @return
	 */
	public State getState() {
		return m_state;
	}
}
